/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.google.inject.Inject;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.backup.NullBackupProfile;
import com.plotsquared.core.backup.PlayerBackupProfile;
import com.plotsquared.core.command.CmdConfirm;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="backup", usage="/plot backup <save | list | load>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup")
public final class Backup
extends Command {
    private final BackupManager backupManager;

    @Inject
    public Backup(@NonNull BackupManager backupManager) {
        super(MainCommand.getInstance(), true);
        this.backupManager = backupManager;
    }

    private static boolean sendMessage(PlotPlayer<?> player) {
        player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"/plot backup <save | list | load>"));
        return true;
    }

    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        if (args.length == 0 || !Arrays.asList("save", "list", "load").contains(args[0].toLowerCase(Locale.ENGLISH))) {
            return CompletableFuture.completedFuture(Backup.sendMessage(player));
        }
        return super.execute(player, args, confirm, whenDone);
    }

    @Override
    public Collection<Command> tab(PlotPlayer<?> player, String[] args, boolean space) {
        CompletableFuture<List<com.plotsquared.core.backup.Backup>> backupList;
        BackupProfile backupProfile;
        Plot plot;
        if (args.length == 1) {
            return Stream.of("save", "list", "load").filter(value -> value.startsWith(args[0].toLowerCase(Locale.ENGLISH))).map(value -> new Command(null, false, (String)value, "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("load") && (plot = player.getCurrentPlot()) != null && (backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot))) instanceof PlayerBackupProfile && (backupList = backupProfile.listBackups()).isDone()) {
            List backups = backupList.getNow(new ArrayList());
            if (backups.isEmpty()) {
                return new ArrayList<Command>();
            }
            return IntStream.range(1, 1 + backups.size()).mapToObj(i -> new Command(null, false, Integer.toString(i), "", RequiredType.NONE, null){}).collect(Collectors.toList());
        }
        return this.tabOf(player, args, space, new String[0]);
    }

    @CommandDeclaration(command="save", usage="/plot backup save", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.save")
    public void save(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        } else if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_unowned").getComponent(player)));
        } else if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
        } else if (plot.isMerged()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_merged").getComponent(player)));
        } else if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else {
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_other").getComponent(player)));
            } else {
                backupProfile.createBackup().whenComplete((backup, throwable) -> {
                    if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_save_failed"), Template.of((String)"reason", (String)throwable.getMessage()));
                        throwable.printStackTrace();
                    } else {
                        player.sendMessage(TranslatableCaption.of("backups.backup_save_success"), new Template[0]);
                    }
                });
            }
        }
    }

    @CommandDeclaration(command="list", usage="/plot backup list", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.list")
    public void list(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        } else if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_unowned").getComponent(player)));
        } else if (plot.isMerged()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_merged").getComponent(player)));
        } else if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
        } else if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else {
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_other").getComponent(player)));
            } else {
                backupProfile.listBackups().whenComplete((backups, throwable) -> {
                    if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_list_failed"), Template.of((String)"reason", (String)throwable.getMessage()));
                        throwable.printStackTrace();
                    } else {
                        player.sendMessage(TranslatableCaption.of("backups.backup_list_header"), Template.of((String)"plot", (String)plot.getId().toCommaSeparatedString()));
                        try {
                            for (int i = 0; i < backups.size(); ++i) {
                                player.sendMessage(TranslatableCaption.of("backups.backup_list_entry"), Template.of((String)"number", (String)Integer.toString(i + 1)), Template.of((String)"value", (String)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(((com.plotsquared.core.backup.Backup)backups.get(i)).getCreationTime()), ZoneId.systemDefault()))));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    @CommandDeclaration(command="load", usage="/plot backup load <#>", category=CommandCategory.SETTINGS, requiredType=RequiredType.PLAYER, permission="plots.backup.load")
    public void load(Command command, PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Plot plot = player.getCurrentPlot();
        if (plot == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
        } else if (!plot.hasOwner()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_unowned").getComponent(player)));
        } else if (plot.isMerged()) {
            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_merged").getComponent(player)));
        } else if (plot.getVolume() > 2.147483647E9) {
            player.sendMessage(TranslatableCaption.of("schematics.schematic_too_large"), new Template[0]);
        } else if (!plot.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN_BACKUP_OTHER)) {
            player.sendMessage(TranslatableCaption.of("permission.no_permission"), Template.of((String)"node", (String)String.valueOf((Object)Permission.PERMISSION_ADMIN_BACKUP_OTHER)));
        } else if (args.length == 0) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), Template.of((String)"value", (String)"Usage: /plot backup save/list/load"));
        } else {
            int number;
            try {
                number = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                player.sendMessage(TranslatableCaption.of("invalid.not_a_number"), Template.of((String)"value", (String)args[0]));
                return;
            }
            BackupProfile backupProfile = Objects.requireNonNull(this.backupManager.getProfile(plot));
            if (backupProfile instanceof NullBackupProfile) {
                player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_other").getComponent(player)));
            } else {
                backupProfile.listBackups().whenComplete((backups, throwable) -> {
                    if (throwable != null) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_load_failure"), Template.of((String)"reason", (String)throwable.getMessage()));
                        throwable.printStackTrace();
                    } else if (number < 1 || number > backups.size()) {
                        player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_invalid_choice").getComponent(player)));
                    } else {
                        com.plotsquared.core.backup.Backup backup = (com.plotsquared.core.backup.Backup)backups.get(number - 1);
                        if (backup == null || backup.getFile() == null || !Files.exists(backup.getFile(), new LinkOption[0])) {
                            player.sendMessage(TranslatableCaption.of("backups.backup_impossible"), Template.of((String)"plot", (String)TranslatableCaption.of("generic.generic_invalid_choice").getComponent(player)));
                        } else {
                            CmdConfirm.addPending(player, "/plot backup load " + number, () -> backupProfile.restoreBackup(backup, player).whenComplete((n, error) -> {
                                if (error != null) {
                                    player.sendMessage(TranslatableCaption.of("backups.backup_load_failure"), Template.of((String)"reason", (String)error.getMessage()));
                                } else {
                                    player.sendMessage(TranslatableCaption.of("backups.backup_load_success"), new Template[0]);
                                }
                            }));
                        }
                    }
                });
            }
        }
    }
}

