/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.jdbc;

import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.jdbc.JdbcDatabaseResults;
import com.j256.ormlite.jdbc.TypeValMapper;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseResults;
import java.io.Closeable;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcCompiledStatement
implements CompiledStatement {
    private final PreparedStatement preparedStatement;
    private final StatementBuilder.StatementType type;
    private final boolean cacheStore;
    private ResultSetMetaData metaData = null;

    public JdbcCompiledStatement(PreparedStatement preparedStatement, StatementBuilder.StatementType type, boolean cacheStore) {
        this.preparedStatement = preparedStatement;
        this.type = type;
        this.cacheStore = cacheStore;
    }

    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int column) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnName(column + 1);
    }

    public int runUpdate() throws SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + this.type + " statement");
        }
        return this.preparedStatement.executeUpdate();
    }

    public DatabaseResults runQuery(ObjectCache objectCache) throws SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + this.type + " statement");
        }
        return new JdbcDatabaseResults(this.preparedStatement, this.preparedStatement.executeQuery(), objectCache, this.cacheStore);
    }

    public int runExecute() throws SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + this.type + " statement");
        }
        this.preparedStatement.execute();
        return this.preparedStatement.getUpdateCount();
    }

    public void close() throws IOException {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new IOException("could not close prepared statement", e);
        }
    }

    public void closeQuietly() {
        IOUtils.closeQuietly((Closeable)((Object)this));
    }

    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws SQLException {
        if (obj == null) {
            this.preparedStatement.setNull(parameterIndex + 1, TypeValMapper.getTypeValForSqlType(sqlType));
        } else {
            this.preparedStatement.setObject(parameterIndex + 1, obj, TypeValMapper.getTypeValForSqlType(sqlType));
        }
    }

    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    public void setQueryTimeout(long millis) throws SQLException {
        this.preparedStatement.setQueryTimeout(Long.valueOf(millis).intValue() / 1000);
    }

    boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }
}

