/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueString
extends Value {
    private static final ValueString EMPTY = new ValueString("");
    protected final String value;

    protected ValueString(String string) {
        this.value = string;
    }

    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equals(((ValueString)object).value);
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueString valueString = (ValueString)value;
        return compareMode.compareString(this.value, valueString.value, false);
    }

    public String getString() {
        return this.value;
    }

    public long getPrecision() {
        return this.value.length();
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.value);
    }

    public int getDisplaySize() {
        return this.value.length();
    }

    public int getMemory() {
        return this.value.length() * 2 + 48;
    }

    public Value convertPrecision(long l) {
        if (l == 0L || (long)this.value.length() <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return this.getNew(this.value.substring(0, n));
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int getType() {
        return 13;
    }

    public static ValueString get(String string) {
        if (string.length() == 0) {
            return EMPTY;
        }
        ValueString valueString = new ValueString(StringUtils.cache(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueString;
        }
        return (ValueString)Value.cache(valueString);
    }

    protected Value getNew(String string) {
        return ValueString.get(string);
    }
}

