/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.config;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;

public class ProxyConfig {
    private static final Proxy.Type TYPE = Proxy.Type.HTTP;
    @NonNull
    private final String hostname;
    @NonNull
    private final Integer port;
    private final String username;
    private final char[] password;
    private final AtomicReference<Object> proxy = new AtomicReference();
    private final AtomicReference<Object> authenticator = new AtomicReference();

    public void apply(OkHttpClient.Builder builder) {
        builder.proxy(this.getProxy()).proxyAuthenticator(this.getAuthenticator());
    }

    public void clearPassword() {
        Arrays.fill(this.password, '0');
    }

    private Authenticator buildAuthenticator() {
        if (this.username == null && this.password == null) {
            return Authenticator.NONE;
        }
        return (route, response) -> response.request().newBuilder().header("Proxy-Authorization", Credentials.basic((String)this.username, (String)String.valueOf(this.password))).build();
    }

    private SocketAddress buildAddress() {
        return new InetSocketAddress(this.hostname, (int)this.port);
    }

    @Generated
    ProxyConfig(@NonNull String hostname, @NonNull Integer port, String username, char[] password) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        if (port == null) {
            throw new NullPointerException("port is marked non-null but is null");
        }
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    @Generated
    public static ProxyConfigBuilder builder() {
        return new ProxyConfigBuilder();
    }

    @NonNull
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @NonNull
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyConfig)) {
            return false;
        }
        ProxyConfig other = (ProxyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Authenticator this$authenticator = this.getAuthenticator();
        Authenticator other$authenticator = other.getAuthenticator();
        return !(this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProxyConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Authenticator $authenticator = this.getAuthenticator();
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProxyConfig(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", proxy=" + this.getProxy() + ", authenticator=" + this.getAuthenticator() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Proxy getProxy() {
        Object $value = this.proxy.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.proxy;
            synchronized (atomicReference) {
                $value = this.proxy.get();
                if ($value == null) {
                    Proxy actualValue = new Proxy(TYPE, this.buildAddress());
                    $value = actualValue == null ? this.proxy : actualValue;
                    this.proxy.set($value);
                }
            }
        }
        return (Proxy)($value == this.proxy ? null : $value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Authenticator getAuthenticator() {
        Object $value = this.authenticator.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.authenticator;
            synchronized (atomicReference) {
                $value = this.authenticator.get();
                if ($value == null) {
                    Authenticator actualValue = this.buildAuthenticator();
                    $value = actualValue == null ? this.authenticator : actualValue;
                    this.authenticator.set($value);
                }
            }
        }
        return (Authenticator)($value == this.authenticator ? null : $value);
    }

    @Generated
    public static class ProxyConfigBuilder {
        @Generated
        private String hostname;
        @Generated
        private Integer port;
        @Generated
        private String username;
        @Generated
        private char[] password;

        @Generated
        ProxyConfigBuilder() {
        }

        @Generated
        public ProxyConfigBuilder hostname(@NonNull String hostname) {
            if (hostname == null) {
                throw new NullPointerException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            return this;
        }

        @Generated
        public ProxyConfigBuilder port(@NonNull Integer port) {
            if (port == null) {
                throw new NullPointerException("port is marked non-null but is null");
            }
            this.port = port;
            return this;
        }

        @Generated
        public ProxyConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ProxyConfigBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public ProxyConfig build() {
            return new ProxyConfig(this.hostname, this.port, this.username, this.password);
        }

        @Generated
        public String toString() {
            return "ProxyConfig.ProxyConfigBuilder(hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ")";
        }
    }
}

