/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.pubsub;

import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.client.websocket.WebsocketConnection;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.pubsub.TwitchPubSub;
import com.github.twitch4j.pubsub.domain.PubSubResponsePayload;
import com.github.twitch4j.util.IBackoffStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchPubSubBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchPubSubBuilder.class);
    private WebsocketConnection websocketConnection = null;
    private EventManager eventManager = null;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private ProxyConfig proxyConfig = null;
    private Collection<String> botOwnerIds = new HashSet<String>();
    private int wsPingPeriod = 15000;
    private int wsCloseDelay = 1000;
    private IBackoffStrategy connectionBackoffStrategy = null;
    private Consumer<PubSubResponsePayload> fallbackTopicHandler = null;

    public static TwitchPubSubBuilder builder() {
        return new TwitchPubSubBuilder();
    }

    public TwitchPubSub build() {
        log.debug("PubSub: Initializing Module ...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-pubsub-" + CryptoUtils.generateNonce((int)4)), (Integer)1);
        }
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        return new TwitchPubSub(this.websocketConnection, this.eventManager, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.connectionBackoffStrategy, this.wsCloseDelay, this.fallbackTopicHandler);
    }

    public TwitchPubSubBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchPubSubBuilder withBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds.addAll(botOwnerIds);
        return this;
    }

    @Generated
    public WebsocketConnection getWebsocketConnection() {
        return this.websocketConnection;
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    @Generated
    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    @Generated
    public int getWsPingPeriod() {
        return this.wsPingPeriod;
    }

    @Generated
    public int getWsCloseDelay() {
        return this.wsCloseDelay;
    }

    @Generated
    public IBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    @Generated
    public Consumer<PubSubResponsePayload> getFallbackTopicHandler() {
        return this.fallbackTopicHandler;
    }

    @Generated
    private TwitchPubSubBuilder() {
    }

    @Generated
    private TwitchPubSubBuilder(WebsocketConnection websocketConnection, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, ProxyConfig proxyConfig, Collection<String> botOwnerIds, int wsPingPeriod, int wsCloseDelay, IBackoffStrategy connectionBackoffStrategy, Consumer<PubSubResponsePayload> fallbackTopicHandler) {
        this.websocketConnection = websocketConnection;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.proxyConfig = proxyConfig;
        this.botOwnerIds = botOwnerIds;
        this.wsPingPeriod = wsPingPeriod;
        this.wsCloseDelay = wsCloseDelay;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.fallbackTopicHandler = fallbackTopicHandler;
    }

    @Generated
    protected TwitchPubSubBuilder withWebsocketConnection(WebsocketConnection websocketConnection) {
        return this.websocketConnection == websocketConnection ? this : new TwitchPubSubBuilder(websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchPubSubBuilder(this.websocketConnection, eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    @Generated
    public TwitchPubSubBuilder withWsPingPeriod(int wsPingPeriod) {
        return this.wsPingPeriod == wsPingPeriod ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withWsCloseDelay(int wsCloseDelay) {
        return this.wsCloseDelay == wsCloseDelay ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, wsCloseDelay, this.connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withConnectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
        return this.connectionBackoffStrategy == connectionBackoffStrategy ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, connectionBackoffStrategy, this.fallbackTopicHandler);
    }

    @Generated
    public TwitchPubSubBuilder withFallbackTopicHandler(Consumer<PubSubResponsePayload> fallbackTopicHandler) {
        return this.fallbackTopicHandler == fallbackTopicHandler ? this : new TwitchPubSubBuilder(this.websocketConnection, this.eventManager, this.defaultEventHandler, this.scheduledThreadPoolExecutor, this.proxyConfig, this.botOwnerIds, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, fallbackTopicHandler);
    }
}

