/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.tmi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.twitch4j.common.exception.NotFoundException;
import com.github.twitch4j.common.exception.UnauthorizedException;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.tmi.domain.TMIError;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class TwitchMessagingInterfaceErrorDecoder
implements ErrorDecoder {
    final Decoder decoder;
    final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();
    final ObjectMapper objectMapper = TypeConvert.getObjectMapper();

    public TwitchMessagingInterfaceErrorDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public Exception decode(String methodKey, Response response) {
        try {
            String responseBody = IOUtils.toString((InputStream)response.body().asInputStream(), (String)StandardCharsets.UTF_8.name());
            if (response.status() == 401) {
                throw new UnauthorizedException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody);
            }
            if (response.status() == 404) {
                throw new NotFoundException().addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody);
            }
            if (response.status() == 503) {
                return new RetryableException(response.status(), "getting service unavailable, retrying ...", Request.HttpMethod.GET, null, response.request());
            }
            TMIError error = (TMIError)this.objectMapper.readValue(responseBody, TMIError.class);
            return new ContextedRuntimeException("TMI API Error").addContextValue("requestUrl", (Object)response.request().url()).addContextValue("requestMethod", (Object)response.request().httpMethod()).addContextValue("responseBody", (Object)responseBody).addContextValue("errorType", (Object)error.getError()).addContextValue("errorStatus", (Object)error.getStatus()).addContextValue("errorType", (Object)error.getMessage());
        }
        catch (IOException fallbackToDefault) {
            return this.defaultDecoder.decode(methodKey, response);
        }
    }
}

