/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.twitch4j.common.util.TypeConvert;
import com.github.twitch4j.eventsub.EventSubNotification;
import com.github.twitch4j.eventsub.EventSubSubscription;
import com.github.twitch4j.eventsub.events.EventSubEvent;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import java.io.IOException;
import java.util.Optional;

public class NotificationDeserializer
extends JsonDeserializer<EventSubNotification> {
    public EventSubNotification deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        EventSubEvent event;
        JsonNode root = (JsonNode)p.getCodec().readTree(p);
        EventSubSubscription sub = NotificationDeserializer.getObject(p.getCodec(), root, "subscription", EventSubSubscription.class);
        if (sub == null) {
            return null;
        }
        String challenge = root.path("challenge").asText(null);
        SubscriptionType<?, ?, ?> type = sub.getType();
        if (challenge == null && type != null && sub.isBatchingEnabled().booleanValue()) {
            JsonNode eventsNode = root.get("events");
            if (eventsNode == null || !eventsNode.isArray()) {
                event = null;
            } else {
                JsonNode eventsObj = TypeConvert.getObjectMapper().createObjectNode().set("events", eventsNode);
                event = (EventSubEvent)p.getCodec().treeToValue((TreeNode)eventsObj, type.getEventClass());
            }
        } else {
            event = type != null ? (EventSubEvent)NotificationDeserializer.getObject(p.getCodec(), root, "event", type.getEventClass()) : null;
        }
        return new EventSubNotification(sub, event, challenge);
    }

    private static <T> T getObject(ObjectCodec codec, JsonNode parent, String field, Class<T> clazz) {
        return Optional.ofNullable(parent).map(r -> r.get(field)).filter(JsonNode::isObject).map(node -> {
            try {
                return codec.treeToValue((TreeNode)node, clazz);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }).orElse(null);
    }
}

