/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.subscriptions;

import com.github.twitch4j.eventsub.subscriptions.BetaChannelSubscriptionGiftType;
import com.github.twitch4j.eventsub.subscriptions.BetaExtensionBitsTransactionCreateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelBanType;
import com.github.twitch4j.eventsub.subscriptions.ChannelCheerType;
import com.github.twitch4j.eventsub.subscriptions.ChannelFollowType;
import com.github.twitch4j.eventsub.subscriptions.ChannelModeratorAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelModeratorRemoveType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRedemptionAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRedemptionUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRemoveType;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardUpdateType;
import com.github.twitch4j.eventsub.subscriptions.ChannelRaidType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscribeType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionEndType;
import com.github.twitch4j.eventsub.subscriptions.ChannelUnbanType;
import com.github.twitch4j.eventsub.subscriptions.ChannelUpdateType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainBeginType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainEndType;
import com.github.twitch4j.eventsub.subscriptions.HypeTrainProgressType;
import com.github.twitch4j.eventsub.subscriptions.PollBeginType;
import com.github.twitch4j.eventsub.subscriptions.PollEndType;
import com.github.twitch4j.eventsub.subscriptions.PollProgressType;
import com.github.twitch4j.eventsub.subscriptions.PredictionBeginType;
import com.github.twitch4j.eventsub.subscriptions.PredictionEndType;
import com.github.twitch4j.eventsub.subscriptions.PredictionLockType;
import com.github.twitch4j.eventsub.subscriptions.PredictionProgressType;
import com.github.twitch4j.eventsub.subscriptions.StreamOfflineType;
import com.github.twitch4j.eventsub.subscriptions.StreamOnlineType;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import com.github.twitch4j.eventsub.subscriptions.UserAuthorizationRevokeType;
import com.github.twitch4j.eventsub.subscriptions.UserUpdateType;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SubscriptionTypes {
    private static final Map<String, SubscriptionType<?, ?, ?>> SUBSCRIPTION_TYPES;
    public static final ChannelBanType CHANNEL_BAN;
    public static final ChannelCheerType CHANNEL_CHEER;
    public static final ChannelFollowType CHANNEL_FOLLOW;
    public static final ChannelModeratorAddType CHANNEL_MODERATOR_ADD;
    public static final ChannelModeratorRemoveType CHANNEL_MODERATOR_REMOVE;
    public static final ChannelPointsCustomRewardAddType CHANNEL_POINTS_CUSTOM_REWARD_ADD;
    public static final ChannelPointsCustomRewardRedemptionAddType CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD;
    public static final ChannelPointsCustomRewardRedemptionUpdateType CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE;
    public static final ChannelPointsCustomRewardRemoveType CHANNEL_POINTS_CUSTOM_REWARD_REMOVE;
    public static final ChannelPointsCustomRewardUpdateType CHANNEL_POINTS_CUSTOM_REWARD_UPDATE;
    public static final ChannelRaidType CHANNEL_RAID;
    public static final ChannelSubscribeType CHANNEL_SUBSCRIBE;
    public static final ChannelSubscriptionEndType CHANNEL_SUBSCRIPTION_END;
    public static final BetaChannelSubscriptionGiftType BETA_CHANNEL_SUBSCRIPTION_GIFT;
    public static final ChannelUnbanType CHANNEL_UNBAN;
    public static final ChannelUpdateType CHANNEL_UPDATE;
    public static final BetaExtensionBitsTransactionCreateType BETA_EXTENSION_BITS_TRANSACTION_CREATE;
    public static final HypeTrainBeginType HYPE_TRAIN_BEGIN;
    public static final HypeTrainEndType HYPE_TRAIN_END;
    public static final HypeTrainProgressType HYPE_TRAIN_PROGRESS;
    public static final PollBeginType POLL_BEGIN;
    public static final PollProgressType POLL_PROGRESS;
    public static final PollEndType POLL_END;
    public static final PredictionBeginType PREDICTION_BEGIN;
    public static final PredictionProgressType PREDICTION_PROGRESS;
    public static final PredictionLockType PREDICTION_LOCK;
    public static final PredictionEndType PREDICTION_END;
    public static final StreamOfflineType STREAM_OFFLINE;
    public static final StreamOnlineType STREAM_ONLINE;
    public static final UserAuthorizationRevokeType USER_AUTHORIZATION_REVOKE;
    public static final UserUpdateType USER_UPDATE;

    public static SubscriptionType<?, ?, ?> getSubscriptionType(String subTypeName, String subTypeVersion) {
        return SUBSCRIPTION_TYPES.get(subTypeName + ':' + subTypeVersion);
    }

    private SubscriptionTypes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SubscriptionType[] subscriptionTypeArray = new SubscriptionType[31];
        CHANNEL_BAN = new ChannelBanType();
        subscriptionTypeArray[0] = CHANNEL_BAN;
        CHANNEL_CHEER = new ChannelCheerType();
        subscriptionTypeArray[1] = CHANNEL_CHEER;
        CHANNEL_FOLLOW = new ChannelFollowType();
        subscriptionTypeArray[2] = CHANNEL_FOLLOW;
        CHANNEL_MODERATOR_ADD = new ChannelModeratorAddType();
        subscriptionTypeArray[3] = CHANNEL_MODERATOR_ADD;
        CHANNEL_MODERATOR_REMOVE = new ChannelModeratorRemoveType();
        subscriptionTypeArray[4] = CHANNEL_MODERATOR_REMOVE;
        CHANNEL_POINTS_CUSTOM_REWARD_ADD = new ChannelPointsCustomRewardAddType();
        subscriptionTypeArray[5] = CHANNEL_POINTS_CUSTOM_REWARD_ADD;
        CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD = new ChannelPointsCustomRewardRedemptionAddType();
        subscriptionTypeArray[6] = CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD;
        CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE = new ChannelPointsCustomRewardRedemptionUpdateType();
        subscriptionTypeArray[7] = CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_UPDATE;
        CHANNEL_POINTS_CUSTOM_REWARD_REMOVE = new ChannelPointsCustomRewardRemoveType();
        subscriptionTypeArray[8] = CHANNEL_POINTS_CUSTOM_REWARD_REMOVE;
        CHANNEL_POINTS_CUSTOM_REWARD_UPDATE = new ChannelPointsCustomRewardUpdateType();
        subscriptionTypeArray[9] = CHANNEL_POINTS_CUSTOM_REWARD_UPDATE;
        CHANNEL_RAID = new ChannelRaidType();
        subscriptionTypeArray[10] = CHANNEL_RAID;
        CHANNEL_SUBSCRIBE = new ChannelSubscribeType();
        subscriptionTypeArray[11] = CHANNEL_SUBSCRIBE;
        CHANNEL_SUBSCRIPTION_END = new ChannelSubscriptionEndType();
        subscriptionTypeArray[12] = CHANNEL_SUBSCRIPTION_END;
        BETA_CHANNEL_SUBSCRIPTION_GIFT = new BetaChannelSubscriptionGiftType();
        subscriptionTypeArray[13] = BETA_CHANNEL_SUBSCRIPTION_GIFT;
        CHANNEL_UNBAN = new ChannelUnbanType();
        subscriptionTypeArray[14] = CHANNEL_UNBAN;
        CHANNEL_UPDATE = new ChannelUpdateType();
        subscriptionTypeArray[15] = CHANNEL_UPDATE;
        BETA_EXTENSION_BITS_TRANSACTION_CREATE = new BetaExtensionBitsTransactionCreateType();
        subscriptionTypeArray[16] = BETA_EXTENSION_BITS_TRANSACTION_CREATE;
        HYPE_TRAIN_BEGIN = new HypeTrainBeginType();
        subscriptionTypeArray[17] = HYPE_TRAIN_BEGIN;
        HYPE_TRAIN_END = new HypeTrainEndType();
        subscriptionTypeArray[18] = HYPE_TRAIN_END;
        HYPE_TRAIN_PROGRESS = new HypeTrainProgressType();
        subscriptionTypeArray[19] = HYPE_TRAIN_PROGRESS;
        POLL_BEGIN = new PollBeginType();
        subscriptionTypeArray[20] = POLL_BEGIN;
        POLL_PROGRESS = new PollProgressType();
        subscriptionTypeArray[21] = POLL_PROGRESS;
        POLL_END = new PollEndType();
        subscriptionTypeArray[22] = POLL_END;
        PREDICTION_BEGIN = new PredictionBeginType();
        subscriptionTypeArray[23] = PREDICTION_BEGIN;
        PREDICTION_PROGRESS = new PredictionProgressType();
        subscriptionTypeArray[24] = PREDICTION_PROGRESS;
        PREDICTION_LOCK = new PredictionLockType();
        subscriptionTypeArray[25] = PREDICTION_LOCK;
        PREDICTION_END = new PredictionEndType();
        subscriptionTypeArray[26] = PREDICTION_END;
        STREAM_OFFLINE = new StreamOfflineType();
        subscriptionTypeArray[27] = STREAM_OFFLINE;
        STREAM_ONLINE = new StreamOnlineType();
        subscriptionTypeArray[28] = STREAM_ONLINE;
        USER_AUTHORIZATION_REVOKE = new UserAuthorizationRevokeType();
        subscriptionTypeArray[29] = USER_AUTHORIZATION_REVOKE;
        USER_UPDATE = new UserUpdateType();
        subscriptionTypeArray[30] = USER_UPDATE;
        SUBSCRIPTION_TYPES = Collections.unmodifiableMap(Stream.of(subscriptionTypeArray).collect(Collectors.toMap(type -> type.getName() + ':' + type.getVersion(), Function.identity())));
    }
}

