/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub.domain;

import com.github.twitch4j.util.EnumUtil;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum ContentClassification {
    DRUGS("DrugsIntoxication"),
    GAMBLING("Gambling"),
    MATURE_GAME("MatureGame"),
    PROFANITY("ProfanityVulgarity"),
    SEXUAL("SexualThemes"),
    VIOLENCE("ViolentGraphic"),
    UNKNOWN("Unknown");

    private static final Map<String, ContentClassification> MAPPINGS;
    private final String twitchString;

    public String toString() {
        return this.twitchString;
    }

    @NotNull
    @ApiStatus.Internal
    public static ContentClassification parse(@NotNull String id) {
        return MAPPINGS.getOrDefault(id, UNKNOWN);
    }

    @Generated
    private ContentClassification(String twitchString) {
        this.twitchString = twitchString;
    }

    static {
        MAPPINGS = EnumUtil.buildMapping((Enum[])ContentClassification.values());
    }
}

