/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.eventsub;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.twitch4j.eventsub.EventSubSubscriptionStatus;
import com.github.twitch4j.eventsub.EventSubTransport;
import com.github.twitch4j.eventsub.condition.EventSubCondition;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionTypes;
import com.github.twitch4j.eventsub.util.EventSubConditionConverter;
import java.time.Instant;
import java.util.Map;

public class EventSubSubscription {
    private String id;
    private EventSubSubscriptionStatus status;
    @JsonIgnore
    private SubscriptionType<?, ?, ?> type;
    private EventSubCondition condition;
    private Instant createdAt;
    private EventSubTransport transport;
    private Integer cost;
    @JsonProperty(value="is_batching_enabled")
    private Boolean isBatchingEnabled;
    @JsonProperty(value="type")
    private String rawType;
    @JsonProperty(value="version")
    private String rawVersion;

    @JsonCreator
    public EventSubSubscription(@JsonProperty(value="id") String id, @JsonProperty(value="status") EventSubSubscriptionStatus status, @JsonProperty(value="type") String type, @JsonProperty(value="version") String version, @JsonProperty(value="condition") Map<String, Object> condition, @JsonProperty(value="created_at") Instant createdAt, @JsonProperty(value="transport") EventSubTransport transport, @JsonProperty(value="cost") Integer cost, @JsonProperty(value="is_batching_enabled") Boolean isBatchingEnabled) {
        this.id = id;
        this.status = status;
        this.rawType = type;
        this.rawVersion = version;
        this.type = SubscriptionTypes.getSubscriptionType(type, version);
        this.condition = EventSubConditionConverter.getCondition(this.type, condition);
        this.createdAt = createdAt;
        this.transport = transport;
        this.cost = cost;
        this.isBatchingEnabled = isBatchingEnabled != null ? isBatchingEnabled.booleanValue() : this.getType().isBatchingEnabled();
    }

    public static EventSubSubscriptionBuilder builder() {
        return new EventSubSubscriptionBuilder();
    }

    public String getId() {
        return this.id;
    }

    public EventSubSubscriptionStatus getStatus() {
        return this.status;
    }

    public EventSubCondition getCondition() {
        return this.condition;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public EventSubTransport getTransport() {
        return this.transport;
    }

    public Integer getCost() {
        return this.cost;
    }

    public Boolean isBatchingEnabled() {
        return this.isBatchingEnabled;
    }

    public String getRawType() {
        return this.rawType;
    }

    public String getRawVersion() {
        return this.rawVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSubSubscription)) {
            return false;
        }
        EventSubSubscription other = (EventSubSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cost = this.getCost();
        Integer other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        Boolean this$isBatchingEnabled = this.isBatchingEnabled();
        Boolean other$isBatchingEnabled = other.isBatchingEnabled();
        if (this$isBatchingEnabled == null ? other$isBatchingEnabled != null : !((Object)this$isBatchingEnabled).equals(other$isBatchingEnabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        EventSubSubscriptionStatus this$status = this.getStatus();
        EventSubSubscriptionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        SubscriptionType<?, ?, ?> this$type = this.getType();
        SubscriptionType<?, ?, ?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        EventSubCondition this$condition = this.getCondition();
        EventSubCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        EventSubTransport this$transport = this.getTransport();
        EventSubTransport other$transport = other.getTransport();
        if (this$transport == null ? other$transport != null : !((Object)this$transport).equals(other$transport)) {
            return false;
        }
        String this$rawType = this.getRawType();
        String other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        String this$rawVersion = this.getRawVersion();
        String other$rawVersion = other.getRawVersion();
        return !(this$rawVersion == null ? other$rawVersion != null : !this$rawVersion.equals(other$rawVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventSubSubscription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        Boolean $isBatchingEnabled = this.isBatchingEnabled();
        result = result * 59 + ($isBatchingEnabled == null ? 43 : ((Object)$isBatchingEnabled).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        EventSubSubscriptionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        SubscriptionType<?, ?, ?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        EventSubCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        EventSubTransport $transport = this.getTransport();
        result = result * 59 + ($transport == null ? 43 : ((Object)$transport).hashCode());
        String $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        String $rawVersion = this.getRawVersion();
        result = result * 59 + ($rawVersion == null ? 43 : $rawVersion.hashCode());
        return result;
    }

    public String toString() {
        return "EventSubSubscription(id=" + this.getId() + ", status=" + (Object)((Object)this.getStatus()) + ", condition=" + this.getCondition() + ", createdAt=" + this.getCreatedAt() + ", transport=" + this.getTransport() + ", cost=" + this.getCost() + ", isBatchingEnabled=" + this.isBatchingEnabled() + ", rawType=" + this.getRawType() + ", rawVersion=" + this.getRawVersion() + ")";
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setStatus(EventSubSubscriptionStatus status) {
        this.status = status;
    }

    @JsonIgnore
    private void setType(SubscriptionType<?, ?, ?> type) {
        this.type = type;
    }

    private void setCondition(EventSubCondition condition) {
        this.condition = condition;
    }

    private void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    private void setTransport(EventSubTransport transport) {
        this.transport = transport;
    }

    private void setCost(Integer cost) {
        this.cost = cost;
    }

    @JsonProperty(value="is_batching_enabled")
    private EventSubSubscription isBatchingEnabled(Boolean isBatchingEnabled) {
        this.isBatchingEnabled = isBatchingEnabled;
        return this;
    }

    @JsonProperty(value="type")
    private void setRawType(String rawType) {
        this.rawType = rawType;
    }

    @JsonProperty(value="version")
    private void setRawVersion(String rawVersion) {
        this.rawVersion = rawVersion;
    }

    public EventSubSubscription() {
    }

    public EventSubSubscription(String id, EventSubSubscriptionStatus status, SubscriptionType<?, ?, ?> type, EventSubCondition condition, Instant createdAt, EventSubTransport transport, Integer cost, Boolean isBatchingEnabled, String rawType, String rawVersion) {
        this.id = id;
        this.status = status;
        this.type = type;
        this.condition = condition;
        this.createdAt = createdAt;
        this.transport = transport;
        this.cost = cost;
        this.isBatchingEnabled = isBatchingEnabled;
        this.rawType = rawType;
        this.rawVersion = rawVersion;
    }

    @JsonIgnore
    public SubscriptionType<?, ?, ?> getType() {
        return this.type;
    }

    public EventSubSubscription withTransport(EventSubTransport transport) {
        return this.transport == transport ? this : new EventSubSubscription(this.id, this.status, this.type, this.condition, this.createdAt, transport, this.cost, this.isBatchingEnabled, this.rawType, this.rawVersion);
    }

    public static class EventSubSubscriptionBuilder {
        private String id;
        private EventSubSubscriptionStatus status;
        private SubscriptionType<?, ?, ?> type;
        private EventSubCondition condition;
        private Instant createdAt;
        private EventSubTransport transport;
        private Integer cost;
        private Boolean isBatchingEnabled;
        private String rawType;
        private String rawVersion;

        EventSubSubscriptionBuilder() {
        }

        public EventSubSubscriptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EventSubSubscriptionBuilder status(EventSubSubscriptionStatus status) {
            this.status = status;
            return this;
        }

        @JsonIgnore
        public EventSubSubscriptionBuilder type(SubscriptionType<?, ?, ?> type) {
            this.type = type;
            return this;
        }

        public EventSubSubscriptionBuilder condition(EventSubCondition condition) {
            this.condition = condition;
            return this;
        }

        public EventSubSubscriptionBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public EventSubSubscriptionBuilder transport(EventSubTransport transport) {
            this.transport = transport;
            return this;
        }

        public EventSubSubscriptionBuilder cost(Integer cost) {
            this.cost = cost;
            return this;
        }

        @JsonProperty(value="is_batching_enabled")
        public EventSubSubscriptionBuilder isBatchingEnabled(Boolean isBatchingEnabled) {
            this.isBatchingEnabled = isBatchingEnabled;
            return this;
        }

        @JsonProperty(value="type")
        public EventSubSubscriptionBuilder rawType(String rawType) {
            this.rawType = rawType;
            return this;
        }

        @JsonProperty(value="version")
        public EventSubSubscriptionBuilder rawVersion(String rawVersion) {
            this.rawVersion = rawVersion;
            return this;
        }

        public EventSubSubscription build() {
            return new EventSubSubscription(this.id, this.status, this.type, this.condition, this.createdAt, this.transport, this.cost, this.isBatchingEnabled, this.rawType, this.rawVersion);
        }

        public String toString() {
            return "EventSubSubscription.EventSubSubscriptionBuilder(id=" + this.id + ", status=" + (Object)((Object)this.status) + ", type=" + this.type + ", condition=" + this.condition + ", createdAt=" + this.createdAt + ", transport=" + this.transport + ", cost=" + this.cost + ", isBatchingEnabled=" + this.isBatchingEnabled + ", rawType=" + this.rawType + ", rawVersion=" + this.rawVersion + ")";
        }
    }
}

