/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum SubscriptionPlan {
    NONE("none"),
    TWITCH_PRIME("Prime"),
    TIER1("1000"),
    TIER2("2000"),
    TIER3("3000");

    private final String ordinalName;
    private static final SubscriptionPlan[] VALUES;

    @JsonCreator
    public static SubscriptionPlan fromString(String plan) {
        if (plan != null) {
            for (SubscriptionPlan subPlan : VALUES) {
                if (!plan.equalsIgnoreCase(subPlan.ordinalName)) continue;
                return subPlan;
            }
        }
        return NONE;
    }

    public String toString() {
        return this.ordinalName;
    }

    private SubscriptionPlan(String ordinalName) {
        this.ordinalName = ordinalName;
    }

    public String ordinalName() {
        return this.ordinalName;
    }

    static {
        VALUES = SubscriptionPlan.values();
    }
}

