/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.common.util;

import com.github.twitch4j.common.enums.CommandPermission;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.EscapeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class TwitchUtils {
    public static final EventUser ANONYMOUS_GIFTER = new EventUser("274598607", "ananonymousgifter");
    public static final EventUser ANONYMOUS_CHEERER = new EventUser("407665396", "ananonymouscheerer");

    @Deprecated
    public static Set<CommandPermission> getPermissionsFromTags(Map<String, Object> tags) {
        return TwitchUtils.getPermissionsFromTags(tags, new HashMap<String, String>());
    }

    @Deprecated
    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        return TwitchUtils.getPermissionsFromTags(tags, badges, null, null);
    }

    @ApiStatus.Internal
    public static Set<CommandPermission> getPermissionsFromTags(@NonNull Map<String, Object> tags, @NonNull Map<String, String> badges, String userId, Collection<String> botOwnerIds) {
        Object inputBadges;
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        Object subscriber = tags.get("subscriber");
        if (subscriber instanceof CharSequence && !StringUtils.equals((CharSequence)"0", (CharSequence)((CharSequence)subscriber))) {
            badges.put("subscriber", subscriber.toString());
        }
        if ((inputBadges = tags.get("badges")) instanceof CharSequence) {
            return TwitchUtils.getPermissionsFromTags((CharSequence)inputBadges, userId, botOwnerIds, badges);
        }
        if (inputBadges instanceof Collection) {
            Collection list = (Collection)inputBadges;
            for (Object badgeObj : list) {
                Map badge;
                Object badgeId;
                if (!(badgeObj instanceof Map) || !((badgeId = (badge = (Map)badgeObj).get("id")) instanceof String)) continue;
                Object badgeVersion = badge.get("version");
                badges.put((String)badgeId, badgeVersion instanceof String ? (String)badgeVersion : null);
            }
        }
        return TwitchUtils.getPermissionsFromTags(null, userId, botOwnerIds, badges);
    }

    @ApiStatus.Internal
    public static <T> Set<CommandPermission> getPermissions(Iterable<T> badges, Function<T, String> badgeName, Function<T, String> badgeValue) {
        EnumSet<CommandPermission> perms = EnumSet.of(CommandPermission.EVERYONE);
        block42: for (T badge : badges) {
            String key;
            switch (key = badgeName.apply(badge)) {
                case "premium": 
                case "turbo": {
                    perms.add(CommandPermission.PRIME_TURBO);
                    break;
                }
                case "partner": 
                case "ambassador": {
                    perms.add(CommandPermission.PARTNER);
                    break;
                }
                case "subscriber": {
                    perms.add(CommandPermission.SUBSCRIBER);
                    break;
                }
                case "founder": {
                    perms.add(CommandPermission.FOUNDER);
                    break;
                }
                case "sub-gifter": 
                case "sub-gift-leader": {
                    perms.add(CommandPermission.SUBGIFTER);
                    break;
                }
                case "bits": 
                case "bits-leader": 
                case "anonymous-cheerer": {
                    perms.add(CommandPermission.BITS_CHEERER);
                    break;
                }
                case "hype-train": {
                    String hypeBadge = badgeValue.apply(badge);
                    if ("1".equals(hypeBadge)) {
                        perms.add(CommandPermission.CURRENT_HYPE_TRAIN_CONDUCTOR);
                        break;
                    }
                    if (!"2".equals(hypeBadge)) break;
                    perms.add(CommandPermission.FORMER_HYPE_TRAIN_CONDUCTOR);
                    break;
                }
                case "predictions": {
                    String predictionBadge = badgeValue.apply(badge);
                    if (predictionBadge == null || predictionBadge.isEmpty()) break;
                    char first = predictionBadge.charAt(0);
                    if (first == 'b') {
                        perms.add(CommandPermission.PREDICTIONS_BLUE);
                        break;
                    }
                    if (first != 'p') continue block42;
                    perms.add(CommandPermission.PREDICTIONS_PINK);
                    break;
                }
                case "no_audio": {
                    perms.add(CommandPermission.NO_AUDIO);
                    break;
                }
                case "no_video": {
                    perms.add(CommandPermission.NO_VIDEO);
                    break;
                }
                case "moments": {
                    perms.add(CommandPermission.MOMENTS);
                    break;
                }
                case "artist-badge": {
                    perms.add(CommandPermission.ARTIST);
                    break;
                }
                case "vip": {
                    perms.add(CommandPermission.VIP);
                    break;
                }
                case "staff": 
                case "admin": {
                    perms.add(CommandPermission.TWITCHSTAFF);
                    break;
                }
                case "moderator": {
                    perms.add(CommandPermission.MODERATOR);
                    break;
                }
                case "broadcaster": {
                    perms.add(CommandPermission.BROADCASTER);
                    perms.add(CommandPermission.MODERATOR);
                    break;
                }
            }
        }
        return perms;
    }

    private static Set<CommandPermission> getPermissionsFromTags(@Nullable CharSequence badgesTag, String userId, Collection<String> botOwnerIds, @NonNull Map<String, String> badges) {
        if (badges == null) {
            throw new NullPointerException("badges is marked non-null but is null");
        }
        if (badgesTag != null) {
            badges.putAll(TwitchUtils.parseBadges(badgesTag.toString()));
        }
        Set<CommandPermission> permissionSet = TwitchUtils.getPermissions(badges.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
        if (userId != null && botOwnerIds != null && botOwnerIds.contains(userId)) {
            permissionSet.add(CommandPermission.OWNER);
        }
        return permissionSet;
    }

    public static Map<String, String> parseBadges(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return map;
        }
        raw = EscapeUtils.unescapeTagValue(raw);
        for (String tag : raw.split(",")) {
            String[] val = tag.split("/", 2);
            String key = val[0];
            String value = val.length > 1 ? val[1] : null;
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }
}

