/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.enums.NoticeTag;
import com.github.twitch4j.chat.events.AbstractChannelEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import org.jetbrains.annotations.Nullable;

public final class ChannelNoticeEvent
extends AbstractChannelEvent {
    private final String msgId;
    private final String message;
    @Nullable
    private final NoticeTag type;

    public ChannelNoticeEvent(EventChannel channel, String msgId, String message) {
        super(channel);
        this.msgId = msgId;
        this.type = NoticeTag.parse(msgId);
        this.message = message;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public NoticeTag getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "ChannelNoticeEvent(super=" + super.toString() + ", msgId=" + this.getMsgId() + ", message=" + this.getMessage() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelNoticeEvent)) {
            return false;
        }
        ChannelNoticeEvent other = (ChannelNoticeEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        NoticeTag this$type = this.getType();
        NoticeTag other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelNoticeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        NoticeTag $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }
}

