/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events;

import com.github.twitch4j.chat.events.TwitchEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import java.time.Duration;

public class AbstractChannelEvent
extends TwitchEvent {
    private final EventChannel channel;

    public AbstractChannelEvent(EventChannel channel) {
        this.channel = channel;
    }

    public void timeout(String user, Duration duration, String reason) {
        StringBuilder sb = new StringBuilder().append(duration.getSeconds());
        if (reason != null) {
            sb.append(" ").append(reason);
        }
        this.getTwitchChat().sendMessage(this.channel.getName(), String.format("/timeout %s %s", user, sb.toString()));
    }

    public void ban(String user, String reason) {
        StringBuilder sb = new StringBuilder(user);
        if (reason != null) {
            sb.append(" ").append(reason);
        }
        this.getTwitchChat().sendMessage(this.channel.getName(), String.format("/ban %s", sb.toString()));
    }

    public void unban(String user) {
        this.getTwitchChat().sendMessage(this.channel.getName(), String.format("/unban %s", user));
    }

    @Override
    public String toString() {
        return "AbstractChannelEvent(channel=" + this.getChannel() + ")";
    }

    public EventChannel getChannel() {
        return this.channel;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractChannelEvent)) {
            return false;
        }
        AbstractChannelEvent other = (AbstractChannelEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EventChannel this$channel = this.getChannel();
        EventChannel other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractChannelEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }
}

