/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public enum NoticeTag {
    ALREADY_BANNED,
    ALREADY_EMOTE_ONLY_OFF,
    ALREADY_EMOTE_ONLY_ON,
    ALREADY_R9K_OFF,
    ALREADY_R9K_ON,
    ALREADY_SUBS_OFF,
    ALREADY_SUBS_ON,
    BAD_BAN_ADMIN,
    BAD_BAN_ANON,
    BAD_BAN_BROADCASTER,
    BAD_BAN_GLOBAL_MOD,
    BAD_BAN_MOD,
    BAD_BAN_SELF,
    BAD_BAN_STAFF,
    BAD_COMMERCIAL_ERROR,
    BAD_DELETE_MESSAGE_BROADCASTER,
    BAD_DELETE_MESSAGE_ERROR,
    BAD_DELETE_MESSAGE_MOD,
    BAD_HOST_ERROR,
    BAD_HOST_HOSTING,
    BAD_HOST_RATE_EXCEEDED,
    BAD_HOST_REJECTED,
    BAD_HOST_SELF,
    BAD_MARKER_CLIENT,
    BAD_MOD_BANNED,
    BAD_MOD_MOD,
    BAD_SLOW_DURATION,
    BAD_TIMEOUT_ADMIN,
    BAD_TIMEOUT_ANON,
    BAD_TIMEOUT_BROADCASTER,
    BAD_TIMEOUT_DURATION,
    BAD_TIMEOUT_GLOBAL_MOD,
    BAD_TIMEOUT_MOD,
    BAD_TIMEOUT_SELF,
    BAD_TIMEOUT_STAFF,
    BAD_UNBAN_NO_BAN,
    BAD_UNHOST_ERROR,
    BAD_UNMOD_MOD,
    BAD_UNVIP_GRANTEE_NOT_VIP,
    BAD_VIP_ACHIEVEMENT_INCOMPLETE,
    BAD_VIP_GRANTEE_ALREADY_VIP,
    BAD_VIP_GRANTEE_BANNED,
    BAD_VIP_MAX_VIPS_REACHED,
    BAN_SUCCESS,
    CMDS_AVAILABLE,
    COLOR_CHANGED,
    COMMERCIAL_SUCCESS,
    DELETE_MESSAGE_SUCCESS,
    EMOTE_ONLY_OFF,
    EMOTE_ONLY_ON,
    FOLLOWERS_OFF,
    FOLLOWERS_ON,
    FOLLOWERS_ONZERO,
    HOST_OFF,
    HOST_ON,
    HOST_SUCCESS,
    HOST_SUCCESS_VIEWERS,
    HOST_TARGET_WENT_OFFLINE,
    HOSTS_REMAINING,
    INVALID_USER,
    MOD_SUCCESS,
    MSG_BANNED,
    MSG_BAD_CHARACTERS,
    MSG_BANNED_EMAIL_ALIAS,
    MSG_CHANNEL_BLOCKED,
    MSG_CHANNEL_SUSPENDED,
    MSG_DUPLICATE,
    MSG_EMOTEONLY,
    MSG_FACEBOOK,
    MSG_FOLLOWERSONLY,
    MSG_FOLLOWERSONLY_FOLLOWED,
    MSG_FOLLOWERSONLY_ZERO,
    MSG_R9K,
    MSG_RATELIMIT,
    MSG_REJECTED,
    MSG_REJECTED_MANDATORY,
    MSG_REQUIRES_VERIFIED_PHONE_NUMBER,
    MSG_ROOM_NOT_FOUND,
    MSG_SLOWMODE,
    MSG_SUBSONLY,
    MSG_SUSPENDED,
    MSG_TIMEDOUT,
    MSG_VERIFIED_EMAIL,
    NO_HELP,
    NO_MODS,
    NOT_HOSTING,
    NO_PERMISSION,
    NO_VIPS,
    R9K_OFF,
    R9K_ON,
    RAID_ERROR_ALREADY_RAIDING,
    RAID_ERROR_FORBIDDEN,
    RAID_ERROR_SELF,
    RAID_ERROR_TOO_MANY_VIEWERS,
    RAID_ERROR_UNEXPECTED,
    RAID_NOTICE_MATURE,
    RAID_NOTICE_RESTRICTED_CHAT,
    ROOM_MODS,
    SLOW_OFF,
    SLOW_ON,
    SUBS_OFF,
    SUBS_ON,
    TIMEOUT_NO_TIMEOUT,
    TIMEOUT_SUCCESS,
    TOS_BAN,
    TURBO_ONLY_COLOR,
    UNBAN_SUCCESS,
    UNMOD_SUCCESS,
    UNRAID_ERROR_NO_ACTIVE_RAID,
    UNRAID_ERROR_UNEXPECTED,
    UNRAID_SUCCESS,
    UNRECOGNIZED_CMD,
    UNSUPPORTED_CHATROOMS_CMD,
    UNTIMEOUT_BANNED,
    UNTIMEOUT_SUCCESS,
    UNVIP_SUCCESS,
    USAGE_BAN,
    USAGE_CLEAR,
    USAGE_COLOR,
    USAGE_COMMERCIAL,
    USAGE_DISCONNECT,
    USAGE_EMOTE_ONLY_OFF,
    USAGE_EMOTE_ONLY_ON,
    USAGE_FOLLOWERS_OFF,
    USAGE_FOLLOWERS_ON,
    USAGE_HELP,
    USAGE_HOST,
    USAGE_MARKER,
    USAGE_ME,
    USAGE_MOD,
    USAGE_MODS,
    USAGE_R9K_OFF,
    USAGE_R9K_ON,
    USAGE_RAID,
    USAGE_SLOW_OFF,
    USAGE_SLOW_ON,
    USAGE_SUBS_OFF,
    USAGE_SUBS_ON,
    USAGE_TIMEOUT,
    USAGE_UNBAN,
    USAGE_UNHOST,
    USAGE_UNMOD,
    USAGE_UNRAID,
    USAGE_UNTIMEOUT,
    USAGE_VIP,
    USAGE_VIPS,
    VIP_SUCCESS,
    VIPS_SUCCESS,
    WHISPER_BANNED,
    WHISPER_BANNED_RECIPIENT,
    WHISPER_INVALID_ARGS,
    WHISPER_INVALID_LOGIN,
    WHISPER_INVALID_SELF,
    WHISPER_LIMIT_PER_MIN,
    WHISPER_LIMIT_PER_SEC,
    WHISPER_RESTRICTED,
    WHISPER_RESTRICTED_RECIPIENT;

    private static final Map<String, NoticeTag> MAPPINGS;

    public String toString() {
        return this.name().toLowerCase();
    }

    @Nullable
    public static NoticeTag parse(String msgId) {
        return MAPPINGS.get(msgId);
    }

    static {
        MAPPINGS = Arrays.stream(NoticeTag.values()).collect(Collectors.toMap(NoticeTag::toString, Function.identity()));
    }
}

