/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.util;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.local.LocalBucketBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TwitchChatLimitHelper {
    public static final Bandwidth USER_MESSAGE_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(30L));
    public static final Bandwidth MOD_MESSAGE_LIMIT = Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(30L));
    public static final Bandwidth KNOWN_MESSAGE_LIMIT = Bandwidth.simple((long)50L, (Duration)Duration.ofSeconds(30L));
    public static final Bandwidth VERIFIED_MESSAGE_LIMIT = Bandwidth.simple((long)7500L, (Duration)Duration.ofSeconds(30L));
    public static final List<Bandwidth> USER_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)100L, (Duration)Duration.ofSeconds(60L)), Bandwidth.simple((long)3L, (Duration)Duration.ofSeconds(1L))));
    public static final List<Bandwidth> KNOWN_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)200L, (Duration)Duration.ofSeconds(60L)), Bandwidth.simple((long)10L, (Duration)Duration.ofSeconds(1L))));
    public static final List<Bandwidth> VERIFIED_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(Bandwidth.simple((long)1200L, (Duration)Duration.ofSeconds(60L)), Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(1L))));
    public static final Bandwidth USER_JOIN_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(10L));
    public static final Bandwidth VERIFIED_JOIN_LIMIT = Bandwidth.simple((long)2000L, (Duration)Duration.ofSeconds(10L));
    public static final Bandwidth USER_AUTH_LIMIT = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(10L));
    public static final Bandwidth VERIFIED_AUTH_LIMIT = Bandwidth.simple((long)200L, (Duration)Duration.ofSeconds(10L));

    public static Bucket createBucket(Bandwidth limit) {
        return ((LocalBucketBuilder)Bucket4j.builder().addLimit(limit)).build();
    }

    public static Bucket createBucket(Bandwidth ... limits) {
        LocalBucketBuilder builder = Bucket4j.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    public static Bucket createBucket(Iterable<Bandwidth> limits) {
        LocalBucketBuilder builder = Bucket4j.builder();
        for (Bandwidth limit : limits) {
            builder.addLimit(limit);
        }
        return builder.build();
    }

    private TwitchChatLimitHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

