/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.chat.enums.CommandSource;
import com.github.twitch4j.chat.enums.TMIConnectionState;
import com.github.twitch4j.chat.events.CommandEvent;
import com.github.twitch4j.chat.events.IRCEventHandler;
import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.util.CryptoUtils;
import com.github.twitch4j.common.util.EscapeUtils;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import io.github.bucket4j.Bucket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchChat
implements ITwitchChat {
    private static final Logger log = LoggerFactory.getLogger(TwitchChat.class);
    private final Object $lock = new Object[0];
    public static final int REQUIRED_THREAD_COUNT = 2;
    private final EventManager eventManager;
    private final CredentialManager credentialManager;
    private OAuth2Credential chatCredential;
    public static final String TWITCH_WEB_SOCKET_SERVER = "wss://irc-ws.chat.twitch.tv:443";
    public static final String FDGT_TEST_SOCKET_SERVER = "wss://irc.fdgt.dev";
    protected final String baseUrl;
    protected final boolean sendCredentialToThirdPartyHost;
    private volatile WebSocket webSocket;
    private volatile TMIConnectionState connectionState = TMIConnectionState.DISCONNECTED;
    private final ReentrantLock channelCacheLock = new ReentrantLock();
    protected final Set<String> currentChannels = ConcurrentHashMap.newKeySet();
    protected final Map<String, String> channelIdToChannelName = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> channelNameToChannelId = new ConcurrentHashMap<String, String>();
    protected final Bucket ircMessageBucket;
    protected final Bucket ircWhisperBucket;
    protected final Bucket ircJoinBucket;
    protected final BlockingQueue<String> ircCommandQueue;
    protected final ScheduledFuture<?> queueThread;
    private final AtomicBoolean flushing = new AtomicBoolean();
    private final AtomicBoolean flushRequested = new AtomicBoolean();
    private final Runnable flushCommand;
    protected volatile boolean stopQueueThread = false;
    protected final Collection<String> botOwnerIds;
    protected final List<String> commandPrefixes;
    protected final ScheduledExecutorService taskExecutor;
    protected final long chatQueueTimeout;
    protected final WebSocketFactory webSocketFactory;
    protected final boolean autoJoinOwnChannel;
    protected final boolean enableMembershipEvents;
    protected final ExponentialBackoffStrategy backoff = ExponentialBackoffStrategy.builder().immediateFirst(true).baseMillis(Duration.ofSeconds(1L).toMillis()).jitter(true).multiplier(2.0).maximumBackoff(Duration.ofMinutes(5L).toMillis()).build();
    private volatile Future<?> backoffClearer;

    public TwitchChat(EventManager eventManager, CredentialManager credentialManager, OAuth2Credential chatCredential, String baseUrl, boolean sendCredentialToThirdPartyHost, List<String> commandPrefixes, Integer chatQueueSize, Bucket ircMessageBucket, Bucket ircWhisperBucket, Bucket ircJoinBucket, ScheduledThreadPoolExecutor taskExecutor, long chatQueueTimeout, ProxyConfig proxyConfig, boolean autoJoinOwnChannel, boolean enableMembershipEvents, Collection<String> botOwnerIds) {
        this.eventManager = eventManager;
        this.credentialManager = credentialManager;
        this.chatCredential = chatCredential;
        this.baseUrl = baseUrl;
        this.sendCredentialToThirdPartyHost = sendCredentialToThirdPartyHost;
        this.commandPrefixes = commandPrefixes;
        this.botOwnerIds = botOwnerIds;
        this.ircCommandQueue = new ArrayBlockingQueue<String>(chatQueueSize, true);
        this.ircMessageBucket = ircMessageBucket;
        this.ircWhisperBucket = ircWhisperBucket;
        this.ircJoinBucket = ircJoinBucket;
        this.taskExecutor = taskExecutor;
        this.chatQueueTimeout = chatQueueTimeout;
        this.autoJoinOwnChannel = autoJoinOwnChannel;
        this.enableMembershipEvents = enableMembershipEvents;
        this.webSocketFactory = new WebSocketFactory();
        if (proxyConfig != null) {
            proxyConfig.applyWs(this.webSocketFactory.getProxySettings());
        }
        if (this.chatCredential == null) {
            log.info("TwitchChat: No ChatAccount provided, Chat will be joined anonymously! Please look at the docs Twitch4J -> Chat if this is unintentional");
        } else if (this.chatCredential.getUserName() == null) {
            log.info("TwitchChat: AccessToken does not contain any user information, fetching using the CredentialManager ...");
            Optional credential = ((OAuth2IdentityProvider)credentialManager.getOAuth2IdentityProviderByName("twitch").orElse(new TwitchIdentityProvider(null, null, null))).getAdditionalCredentialInformation(this.chatCredential);
            if (credential.isPresent()) {
                this.chatCredential = (OAuth2Credential)credential.get();
            } else {
                log.error("TwitchChat: Failed to get AccessToken Information, the token is probably not valid. Please check the docs Twitch4J -> Chat on how to obtain a valid token.");
            }
        }
        this.eventManager.getServiceMediator().addService("twitch4j-chat", (Object)this);
        IRCEventHandler ircEventHandler = new IRCEventHandler(this);
        this.connect();
        this.flushCommand = () -> {
            if (this.flushing.getAndSet(true)) {
                return;
            }
            while (!this.stopQueueThread && this.connectionState == TMIConnectionState.CONNECTED) {
                String command = null;
                try {
                    command = this.ircCommandQueue.poll(this.chatQueueTimeout, TimeUnit.MILLISECONDS);
                    if (command == null) break;
                    this.sendTextToWebSocket(command, false);
                    log.debug("Processed command from queue: [{}].", (Object)(command.startsWith("PASS") ? "***OAUTH TOKEN HIDDEN***" : command));
                }
                catch (Exception ex) {
                    log.error("Chat: Unexpected error in worker thread", (Throwable)ex);
                    if (command == null) break;
                    try {
                        this.ircCommandQueue.offer(command, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        log.error("Failed to reschedule command", (Throwable)e);
                    }
                    break;
                }
            }
            this.flushRequested.set(false);
            this.flushing.set(false);
        };
        this.queueThread = taskExecutor.scheduleAtFixedRate(this.flushCommand, 0L, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
        log.debug("Started IRC Queue Worker");
        log.debug("Registering the following command triggers: " + commandPrefixes.toString());
        eventManager.onEvent("twitch4j-chat-command-trigger", ChannelMessageEvent.class, this::onChannelMessage);
        eventManager.onEvent(IRCMessageEvent.class, event -> {
            if ("ROOMSTATE".equalsIgnoreCase(event.getCommandType()) && event.getChannelId() != null) {
                this.channelCacheLock.lock();
                try {
                    event.getChannelName().map(String::toLowerCase).filter(this.currentChannels::contains).ifPresent(name -> {
                        String oldName = this.channelIdToChannelName.put(event.getChannelId(), (String)name);
                        if (!name.equals(oldName)) {
                            if (oldName != null) {
                                this.channelNameToChannelId.remove(oldName, event.getChannelId());
                            }
                            this.channelNameToChannelId.put((String)name, event.getChannelId());
                        }
                    });
                }
                finally {
                    this.channelCacheLock.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.connectionState.equals((Object)TMIConnectionState.DISCONNECTED) || this.connectionState.equals((Object)TMIConnectionState.RECONNECTING)) {
                try {
                    this.connectionState = TMIConnectionState.CONNECTING;
                    this.createWebSocket();
                    this.webSocket.connect();
                }
                catch (Exception ex) {
                    log.error("Connection to Twitch IRC failed: Retrying ...", (Throwable)ex);
                    try {
                        this.backoff.sleep();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.reconnect();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.connectionState.equals((Object)TMIConnectionState.CONNECTED)) {
                this.sendTextToWebSocket("QUIT", true);
                this.connectionState = TMIConnectionState.DISCONNECTING;
            }
            this.connectionState = TMIConnectionState.DISCONNECTED;
            this.webSocket.clearListeners();
            this.webSocket.disconnect();
            this.webSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.$lock;
        synchronized (object) {
            this.connectionState = TMIConnectionState.RECONNECTING;
            this.disconnect();
            this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWebSocket() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                this.webSocket = this.webSocketFactory.createSocket(this.baseUrl);
                this.webSocket.clearListeners();
                this.webSocket.addListener((WebSocketListener)new WebSocketAdapter(){

                    public void onConnected(WebSocket ws, Map<String, List<String>> headers) {
                        String userName;
                        log.info("Connecting to Twitch IRC {}", (Object)TwitchChat.this.baseUrl);
                        TwitchChat.this.sendTextToWebSocket("CAP REQ :twitch.tv/tags twitch.tv/commands" + (TwitchChat.this.enableMembershipEvents ? " twitch.tv/membership" : ""), true);
                        TwitchChat.this.sendTextToWebSocket("CAP END", true);
                        if (TwitchChat.this.chatCredential != null) {
                            boolean sendRealPass = TwitchChat.this.sendCredentialToThirdPartyHost || TwitchChat.this.baseUrl.equalsIgnoreCase(TwitchChat.TWITCH_WEB_SOCKET_SERVER) || TwitchChat.this.baseUrl.equalsIgnoreCase(TwitchChat.TWITCH_WEB_SOCKET_SERVER.substring(0, TwitchChat.TWITCH_WEB_SOCKET_SERVER.length() - 4));
                            TwitchChat.this.sendTextToWebSocket(String.format("pass oauth:%s", sendRealPass ? TwitchChat.this.chatCredential.getAccessToken() : CryptoUtils.generateNonce((int)30)), true);
                            userName = String.valueOf(TwitchChat.this.chatCredential.getUserName()).toLowerCase();
                        } else {
                            userName = "justinfan" + ThreadLocalRandom.current().nextInt(100000);
                        }
                        TwitchChat.this.sendTextToWebSocket(String.format("nick %s", userName), true);
                        for (String channel : TwitchChat.this.currentChannels) {
                            TwitchChat.this.issueJoin(channel);
                        }
                        if (TwitchChat.this.chatCredential != null && TwitchChat.this.chatCredential.getUserName() != null) {
                            if (TwitchChat.this.autoJoinOwnChannel && !TwitchChat.this.currentChannels.contains(userName)) {
                                TwitchChat.this.joinChannel(userName);
                            }
                        } else {
                            log.warn("Chat: The whispers feature is currently not available because the provided credential does not hold information about the user. Please check the documentation on how to pass the token to the credentialManager where it will be enriched with the required information.");
                        }
                        TwitchChat.this.connectionState = TMIConnectionState.CONNECTED;
                        TwitchChat.this.backoffClearer = TwitchChat.this.taskExecutor.schedule(() -> {
                            if (TwitchChat.this.connectionState == TMIConnectionState.CONNECTED) {
                                TwitchChat.this.backoff.reset();
                            }
                        }, 30L, TimeUnit.SECONDS);
                    }

                    public void onTextMessage(WebSocket ws, String text) {
                        Arrays.asList(text.replace("\n\r", "\n").replace("\r", "\n").split("\n")).forEach(message -> {
                            if (!message.equals("")) {
                                log.trace("Received WebSocketMessage: " + message);
                                if (message.contains(":req Invalid CAP command")) {
                                    log.error("Failed to acquire requested IRC capabilities!");
                                } else if (message.contains(":tmi.twitch.tv CAP * ACK :")) {
                                    List<String> capabilities = Arrays.asList(message.replace(":tmi.twitch.tv CAP * ACK :", "").split(" "));
                                    capabilities.forEach(cap -> log.debug("Acquired chat capability: " + cap));
                                } else if (message.contains("PING :tmi.twitch.tv")) {
                                    TwitchChat.this.sendTextToWebSocket("PONG :tmi.twitch.tv", true);
                                    log.debug("Responding to PING request!");
                                } else if (message.equals(":tmi.twitch.tv NOTICE * :Login authentication failed")) {
                                    log.error("Invalid IRC Credentials. Login failed!");
                                } else {
                                    try {
                                        IRCMessageEvent event = new IRCMessageEvent((String)message, TwitchChat.this.channelIdToChannelName, TwitchChat.this.channelNameToChannelId, TwitchChat.this.botOwnerIds);
                                        if (event.isValid().booleanValue()) {
                                            TwitchChat.this.eventManager.publish((Object)event);
                                        } else {
                                            log.trace("Can't parse {}", (Object)event.getRawMessage());
                                        }
                                    }
                                    catch (Exception ex) {
                                        log.error(ex.getMessage(), (Throwable)ex);
                                    }
                                }
                            }
                        });
                    }

                    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) {
                        if (!TwitchChat.this.connectionState.equals((Object)TMIConnectionState.DISCONNECTING)) {
                            log.info("Connection to Twitch IRC lost (WebSocket)! Retrying soon ...");
                            if (TwitchChat.this.backoffClearer != null) {
                                TwitchChat.this.backoffClearer.cancel(false);
                            }
                            TwitchChat.this.taskExecutor.schedule(() -> TwitchChat.this.reconnect(), TwitchChat.this.backoff.get(), TimeUnit.MILLISECONDS);
                        } else {
                            TwitchChat.this.connectionState = TMIConnectionState.DISCONNECTED;
                            log.info("Disconnected from Twitch IRC (WebSocket)!");
                        }
                    }
                });
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void sendCommand(String command, String ... args) {
        this.sendRaw(String.format("%s %s", command.toUpperCase(), String.join((CharSequence)" ", args)));
    }

    public boolean sendRaw(String command) {
        return this.ircMessageBucket.asAsyncScheduler().consume(1L, this.taskExecutor).thenRunAsync(() -> this.queueCommand(command), this.taskExecutor) != null;
    }

    private void queueCommand(String command) {
        if (!this.ircCommandQueue.offer(command)) {
            try {
                this.ircCommandQueue.offer(command, this.chatQueueTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                log.warn("Chat: unable to add command to full queue", (Throwable)e);
                return;
            }
        }
        if (!this.flushing.get() && !this.flushRequested.getAndSet(true)) {
            this.taskExecutor.schedule(this.flushCommand, this.chatQueueTimeout / 20L, TimeUnit.MILLISECONDS);
        }
    }

    private boolean sendTextToWebSocket(String command, Boolean consumeToken) {
        if (!this.connectionState.equals((Object)TMIConnectionState.CONNECTED) && !this.connectionState.equals((Object)TMIConnectionState.CONNECTING)) {
            return false;
        }
        if (consumeToken.booleanValue()) {
            this.ircMessageBucket.tryConsume(1L);
        }
        this.webSocket.sendText(command);
        return true;
    }

    @Override
    public void joinChannel(String channelName) {
        String lowerChannelName = channelName.toLowerCase();
        this.channelCacheLock.lock();
        try {
            if (this.currentChannels.add(lowerChannelName)) {
                this.issueJoin(lowerChannelName);
                log.debug("Joining Channel [{}].", (Object)lowerChannelName);
            } else {
                log.warn("Already joined channel {}", (Object)channelName);
            }
        }
        finally {
            this.channelCacheLock.unlock();
        }
    }

    private void issueJoin(String channelName) {
        this.ircJoinBucket.asAsyncScheduler().consume(1L, this.taskExecutor).thenRunAsync(() -> this.queueCommand("JOIN #" + channelName.toLowerCase()), this.taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean leaveChannel(String channelName) {
        String lowerChannelName = channelName.toLowerCase();
        this.channelCacheLock.lock();
        try {
            if (this.currentChannels.remove(lowerChannelName)) {
                this.issuePart(lowerChannelName);
                log.debug("Leaving Channel [{}].", (Object)lowerChannelName);
                String cachedId = this.channelNameToChannelId.remove(lowerChannelName);
                if (cachedId != null) {
                    this.channelIdToChannelName.remove(cachedId);
                }
                boolean bl = true;
                return bl;
            }
            log.warn("Already left channel {}", (Object)channelName);
            boolean bl = false;
            return bl;
        }
        finally {
            this.channelCacheLock.unlock();
        }
    }

    private void issuePart(String channelName) {
        this.ircJoinBucket.asAsyncScheduler().consume(1L, this.taskExecutor).thenRunAsync(() -> this.queueCommand("PART #" + channelName.toLowerCase()), this.taskExecutor);
    }

    @Override
    public boolean sendMessage(String channel, String message, Map<String, Object> tags) {
        StringBuilder sb = new StringBuilder();
        if (tags != null && !tags.isEmpty()) {
            sb.append('@');
            tags.forEach((k, v) -> sb.append((String)k).append('=').append(EscapeUtils.escapeTagValue((Object)v)).append(';'));
            sb.setCharAt(sb.length() - 1, ' ');
        }
        sb.append("PRIVMSG #").append(channel.toLowerCase()).append(" :").append(message);
        log.debug("Adding message for channel [{}] with content [{}] to the queue.", (Object)channel.toLowerCase(), (Object)message);
        return this.sendRaw(sb.toString());
    }

    public void sendPrivateMessage(String targetUser, String message) {
        log.debug("Adding private message for user [{}] with content [{}] to the queue.", (Object)targetUser, (Object)message);
        this.ircWhisperBucket.asAsyncScheduler().consume(1L, this.taskExecutor).thenRunAsync(() -> this.queueCommand(String.format("PRIVMSG #%s :/w %s %s", this.chatCredential.getUserName().toLowerCase(), targetUser, message)), this.taskExecutor);
    }

    private void onChannelMessage(ChannelMessageEvent event) {
        Optional<Object> prefix = Optional.empty();
        Optional<Object> commandWithoutPrefix = Optional.empty();
        for (String commandPrefix : this.commandPrefixes) {
            if (!event.getMessage().startsWith(commandPrefix)) continue;
            prefix = Optional.of(commandPrefix);
            commandWithoutPrefix = Optional.of(event.getMessage().substring(commandPrefix.length()));
            break;
        }
        if (commandWithoutPrefix.isPresent()) {
            log.debug("Detected a command in channel {} with content: {}", (Object)event.getChannel().getName(), commandWithoutPrefix.get());
            this.eventManager.publish((Object)new CommandEvent(CommandSource.CHANNEL, event.getChannel().getName(), event.getUser(), (String)prefix.get(), (String)commandWithoutPrefix.get(), event.getPermissions()));
        }
    }

    @Override
    public void close() {
        this.stopQueueThread = true;
        this.queueThread.cancel(false);
        this.disconnect();
    }

    @Override
    public boolean isChannelJoined(String channelName) {
        return this.currentChannels.contains(channelName.toLowerCase());
    }

    @Deprecated
    public List<String> getCurrentChannels() {
        return Collections.unmodifiableList(new ArrayList<String>(this.currentChannels));
    }

    @Override
    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.currentChannels);
    }

    @Override
    public Map<String, String> getChannelIdToChannelName() {
        return Collections.unmodifiableMap(this.channelIdToChannelName);
    }

    @Override
    public Map<String, String> getChannelNameToChannelId() {
        return Collections.unmodifiableMap(this.channelNameToChannelId);
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    public TMIConnectionState getConnectionState() {
        return this.connectionState;
    }
}

