/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.channel;

import com.github.twitch4j.chat.events.AbstractChannelMessageEvent;
import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.util.ChatCrowdChant;
import com.github.twitch4j.common.enums.HypeChatLevel;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.ChatReply;
import com.github.twitch4j.common.util.DonationAmount;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ChannelMessageEvent
extends AbstractChannelMessageEvent {
    @Nullable
    private final AtomicReference<Object> replyInfo = new AtomicReference();
    @Deprecated
    @Nullable
    private final AtomicReference<Object> chantInfo = new AtomicReference();

    public ChannelMessageEvent(EventChannel channel, IRCMessageEvent messageEvent, EventUser user, String message) {
        super(channel, messageEvent, user, message);
    }

    public boolean isHighlightedMessage() {
        return StringUtils.equals((CharSequence)"highlighted-message", (CharSequence)this.getMessageEvent().getRawTag("msg-id"));
    }

    public boolean isSkipSubsModeMessage() {
        return StringUtils.equals((CharSequence)"skip-subs-mode-message", (CharSequence)this.getMessageEvent().getRawTag("msg-id"));
    }

    public Optional<String> getCustomRewardId() {
        return this.getMessageEvent().getTagValue("custom-reward-id");
    }

    public boolean isDesignatedFirstMessage() {
        return StringUtils.equals((CharSequence)"1", (CharSequence)this.getMessageEvent().getRawTag("first-msg"));
    }

    public boolean isUserIntroduction() {
        return StringUtils.equals((CharSequence)"user-intro", (CharSequence)this.getMessageEvent().getRawTag("msg-id"));
    }

    public Optional<DonationAmount> getElevatedChatPayment() {
        Map<String, CharSequence> tags = this.getMessageEvent().getEscapedTags();
        CharSequence amount = tags.get("pinned-chat-paid-amount");
        if (amount == null) {
            amount = tags.get("pinned-chat-paid-canonical-amount");
        }
        return Optional.ofNullable(amount).map(amt -> {
            try {
                return Long.parseLong(amt.toString());
            }
            catch (Exception e) {
                return null;
            }
        }).map(amt -> {
            int exponent;
            String currency = ((CharSequence)tags.getOrDefault("pinned-chat-paid-currency", "USD")).toString();
            String exponentStr = ((CharSequence)tags.getOrDefault("pinned-chat-paid-exponent", "2")).toString();
            try {
                exponent = Integer.parseInt(exponentStr);
            }
            catch (Exception e) {
                return null;
            }
            return new DonationAmount(amt, Integer.valueOf(exponent), currency);
        });
    }

    public Optional<HypeChatLevel> getHypeChatLevel() {
        return this.getMessageEvent().getTagValue("pinned-chat-paid-level").map(HypeChatLevel.MAPPINGS::get);
    }

    @Override
    public String toString() {
        return "ChannelMessageEvent(super=" + super.toString() + ", replyInfo=" + this.getReplyInfo() + ", chantInfo=" + this.getChantInfo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelMessageEvent)) {
            return false;
        }
        ChannelMessageEvent other = (ChannelMessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChatReply this$replyInfo = this.getReplyInfo();
        ChatReply other$replyInfo = other.getReplyInfo();
        if (this$replyInfo == null ? other$replyInfo != null : !this$replyInfo.equals(other$replyInfo)) {
            return false;
        }
        ChatCrowdChant this$chantInfo = this.getChantInfo();
        ChatCrowdChant other$chantInfo = other.getChantInfo();
        return !(this$chantInfo == null ? other$chantInfo != null : !((Object)this$chantInfo).equals(other$chantInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelMessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChatReply $replyInfo = this.getReplyInfo();
        result = result * 59 + ($replyInfo == null ? 43 : $replyInfo.hashCode());
        ChatCrowdChant $chantInfo = this.getChantInfo();
        result = result * 59 + ($chantInfo == null ? 43 : ((Object)$chantInfo).hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ChatReply getReplyInfo() {
        Object value = this.replyInfo.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.replyInfo;
            synchronized (atomicReference) {
                value = this.replyInfo.get();
                if (value == null) {
                    ChatReply actualValue = ChatReply.parse(this.getMessageEvent().getEscapedTags());
                    value = actualValue == null ? this.replyInfo : actualValue;
                    this.replyInfo.set(value);
                }
            }
        }
        return (ChatReply)(value == this.replyInfo ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public ChatCrowdChant getChantInfo() {
        Object value = this.chantInfo.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.chantInfo;
            synchronized (atomicReference) {
                value = this.chantInfo.get();
                if (value == null) {
                    ChatCrowdChant actualValue = ChatCrowdChant.parse(this.getMessageEvent());
                    value = actualValue == null ? this.chantInfo : actualValue;
                    this.chantInfo.set(value);
                }
            }
        }
        return (ChatCrowdChant)(value == this.chantInfo ? null : value);
    }
}

