/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.flag;

import com.github.twitch4j.chat.events.channel.IRCMessageEvent;
import com.github.twitch4j.chat.flag.AutoModFlag;
import com.github.twitch4j.chat.flag.FlagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class FlagParser {
    private static final String IRC_TAG_NAME = "flags";

    @NonNull
    public static List<AutoModFlag> parseFlags(@NonNull String rawFlags) {
        if (rawFlags == null) {
            throw new NullPointerException("rawFlags is marked non-null but is null");
        }
        String[] splitFlags = rawFlags.split(",");
        ArrayList<AutoModFlag> flags = new ArrayList<AutoModFlag>(splitFlags.length);
        for (String rawFlag : splitFlags) {
            String[] scores;
            String[] indices;
            String[] parts = rawFlag.split(":", -1);
            if (parts.length != 2 || (indices = parts[0].split("-")).length != 2) continue;
            int start = Integer.parseInt(indices[0]);
            int end = Integer.parseInt(indices[1]);
            AutoModFlag.AutoModFlagBuilder builder = AutoModFlag.builder().startIndex(start).endIndex(end);
            for (String score : scores = parts[1].split("/")) {
                FlagType type;
                String[] scoreParts = score.split("\\.");
                if (scoreParts.length != 2 || (type = FlagType.parse(scoreParts[0])) == null) continue;
                builder.score(type, Integer.parseInt(scoreParts[1]));
            }
            flags.add(builder.build());
        }
        return Collections.unmodifiableList(flags);
    }

    @NonNull
    public static List<AutoModFlag> parseFlags(@NonNull IRCMessageEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return event.getTagValue(IRC_TAG_NAME).map(FlagParser::parseFlags).orElse(Collections.emptyList());
    }

    private FlagParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

