/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.chat.events.roomstate;

import com.github.twitch4j.chat.events.roomstate.ChannelStatesEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import java.util.concurrent.TimeUnit;

public final class FollowersOnlyEvent
extends ChannelStatesEvent {
    private final long time;

    public FollowersOnlyEvent(EventChannel channel, long time, TimeUnit timeUnit) {
        super(channel, time > -1L);
        this.time = timeUnit.toSeconds(time);
    }

    public FollowersOnlyEvent(EventChannel channel, long time) {
        super(channel, time > -1L);
        this.time = TimeUnit.MINUTES.toSeconds(time);
    }

    public long getTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.time, TimeUnit.SECONDS);
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FollowersOnlyEvent)) {
            return false;
        }
        FollowersOnlyEvent other = (FollowersOnlyEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FollowersOnlyEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        return result;
    }

    @Override
    public String toString() {
        return "FollowersOnlyEvent(super=" + super.toString() + ", time=" + this.getTime() + ")";
    }
}

