/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.api.Property;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.parameter.ArrayParameter;
import com.github.theholywaffle.teamspeak3.commands.parameter.KeyValueParam;
import com.github.theholywaffle.teamspeak3.commands.parameter.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class CommandBuilder {
    private final String commandName;
    private final Collection<Parameter> parameters;

    public CommandBuilder(String commandName) {
        this(commandName, 0);
    }

    public CommandBuilder(String commandName, int expectedParamCount) {
        this.commandName = commandName;
        this.parameters = new ArrayList<Parameter>(expectedParamCount);
    }

    public CommandBuilder add(Parameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public CommandBuilder addIf(boolean test, Parameter parameter) {
        if (test) {
            this.parameters.add(parameter);
        }
        return this;
    }

    public CommandBuilder addProperties(Map<? extends Property, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        ArrayParameter parameter = new ArrayParameter(1, properties.size());
        for (Map.Entry<? extends Property, String> entry : properties.entrySet()) {
            Property property = entry.getKey();
            String value = entry.getValue();
            if (property == null) {
                throw new IllegalArgumentException("Property cannot be null");
            }
            if (!property.isChangeable()) {
                String className = property.getClass().getSimpleName();
                throw new IllegalArgumentException(className + " " + property.getName() + " is not changeable");
            }
            parameter.add(new KeyValueParam(property.getName(), value));
        }
        this.parameters.add(parameter);
        return this;
    }

    public Command build() {
        return new Command(this.commandName, this.parameters);
    }
}

