/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.reconnect;

import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectingConnectionHandler
implements ConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(ReconnectingConnectionHandler.class);
    private final ConnectionHandler userConnectionHandler;
    private final int startTimeout;
    private final int timeoutCap;
    private final int addend;
    private final double multiplier;

    public ReconnectingConnectionHandler(ConnectionHandler userConnectionHandler, int startTimeout, int timeoutCap, int addend, double multiplier) {
        this.userConnectionHandler = userConnectionHandler;
        this.startTimeout = startTimeout;
        this.timeoutCap = timeoutCap;
        this.addend = addend;
        this.multiplier = multiplier;
    }

    @Override
    public void onConnect(TS3Api api) {
        if (this.userConnectionHandler != null) {
            this.userConnectionHandler.onConnect(api);
        }
    }

    @Override
    public void onDisconnect(TS3Query ts3Query) {
        log.info("[Connection] Disconnected from TS3 server - reconnecting in {}ms", (Object)this.startTimeout);
        if (this.userConnectionHandler != null) {
            this.userConnectionHandler.onDisconnect(ts3Query);
        }
        int timeout = this.startTimeout;
        while (true) {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                return;
            }
            timeout = (int)Math.ceil((double)timeout * this.multiplier) + this.addend;
            if (this.timeoutCap > 0) {
                timeout = Math.min(timeout, this.timeoutCap);
            }
            try {
                ts3Query.connect();
                return;
            }
            catch (TS3ConnectionFailedException conFailed) {
                log.debug("[Connection] Failed to reconnect - waiting {}ms until next attempt", (Object)timeout);
                continue;
            }
            break;
        }
    }
}

