/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.IOChannel;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import net.schmizz.sshj.userauth.UserAuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSHChannel
implements IOChannel {
    private static final Logger log = LoggerFactory.getLogger(SSHChannel.class);
    private static final String KNOWN_HOSTS_FILE_NAME = "known_ts3_hosts";
    private final SSHClient client;
    private final Session session;

    SSHChannel(TS3Config config) throws IOException {
        if (!config.hasLoginCredentials()) {
            throw new TS3ConnectionFailedException("Anonymous queries are not supported when using SSH.\n\t\tYou must specify a query username and password using TS3Config#setLoginCredentials.");
        }
        try {
            this.client = new SSHClient();
            File knownHostsFile = new File(OpenSSHKnownHosts.detectSSHDir(), KNOWN_HOSTS_FILE_NAME);
            this.client.addHostKeyVerifier((HostKeyVerifier)new AutoAddKnownHosts(knownHostsFile));
            this.client.setConnectTimeout(config.getCommandTimeout());
            this.client.setTimeout(config.getCommandTimeout());
            this.client.setRemoteCharset(StandardCharsets.UTF_8);
            this.client.connect(config.getHost(), config.getQueryPort());
            this.client.getSocket().setTcpNoDelay(true);
            this.client.authPassword(config.getUsername(), config.getPassword());
            this.session = this.client.startSession();
            this.session.startShell();
        }
        catch (UserAuthException uae) {
            this.close();
            throw new TS3ConnectionFailedException("Invalid query username or password");
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.session.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            this.session.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    private static class AutoAddKnownHosts
    extends OpenSSHKnownHosts {
        public AutoAddKnownHosts(File khFile) throws IOException {
            super(khFile);
        }

        protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
            try {
                this.entries().add(new OpenSSHKnownHosts.HostEntry(null, hostname, KeyType.fromKey((Key)key), key));
                this.write();
                return true;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not write host keys to file", ioe);
            }
        }

        protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
            Logger log = log;
            log.error("The host key for {} has changed!", (Object)hostname);
            log.error("This could be because someone is eavesdropping on you (man-in-the-middle attack).");
            log.error("It could also be that the host key has changed, e.g. because the TS3 server was re-installed .");
            log.error("If you trust that the new host key is genuine, correct or remove the entry for {} in your known hosts file ({}).", (Object)hostname, (Object)this.khFile);
            return false;
        }

        public List<String> findExistingAlgorithms(String hostname, int port) {
            return Collections.emptyList();
        }
    }
}

