/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.CommandQueue;
import com.github.theholywaffle.teamspeak3.IOChannel;
import com.github.theholywaffle.teamspeak3.KeepAlive;
import com.github.theholywaffle.teamspeak3.SSHChannel;
import com.github.theholywaffle.teamspeak3.SocketChannel;
import com.github.theholywaffle.teamspeak3.StreamReader;
import com.github.theholywaffle.teamspeak3.StreamWriter;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class Connection {
    private final TS3Query ts3Query;
    private final IOChannel ioChannel;
    private final StreamReader streamReader;
    private final StreamWriter streamWriter;
    private final KeepAlive keepAlive;
    private final AtomicReference<CommandQueue> commandQueue;
    private final AtomicLong lastCommandSent;
    private final long commandTimeout;

    Connection(TS3Query query, TS3Config config, CommandQueue initialQueue) {
        this.ts3Query = query;
        this.commandQueue = new AtomicReference<CommandQueue>(initialQueue);
        this.lastCommandSent = new AtomicLong(System.currentTimeMillis());
        this.commandTimeout = config.getCommandTimeout();
        try {
            this.ioChannel = config.getProtocol() == TS3Query.Protocol.SSH ? new SSHChannel(config) : new SocketChannel(config);
            this.streamReader = new StreamReader(this, this.ioChannel.getInputStream(), query, config);
            this.streamWriter = new StreamWriter(this, this.ioChannel.getOutputStream(), config);
            this.keepAlive = new KeepAlive(this);
        }
        catch (IOException ioe) {
            this.closeSocket();
            throw new TS3ConnectionFailedException(ioe);
        }
        this.streamReader.start();
        this.streamWriter.start();
        this.keepAlive.start();
    }

    void internalDisconnect() {
        this.disconnect();
        CommandQueue queue = this.getCommandQueue();
        if (queue.isGlobal()) {
            this.ts3Query.fireDisconnect();
        } else {
            queue.failRemainingCommands();
        }
    }

    void disconnect() {
        this.keepAlive.interrupt();
        this.streamWriter.interrupt();
        this.streamReader.interrupt();
        boolean wasInterrupted = Connection.joinThread(this.keepAlive);
        wasInterrupted |= Connection.joinThread(this.streamWriter);
        if (wasInterrupted |= Connection.joinThread(this.streamReader)) {
            Thread.currentThread().interrupt();
        }
        this.closeSocket();
    }

    private static boolean joinThread(Thread thread) {
        if (thread == Thread.currentThread()) {
            return false;
        }
        try {
            thread.join();
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private void closeSocket() {
        if (this.ioChannel == null) {
            return;
        }
        try {
            this.ioChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    CommandQueue getCommandQueue() {
        return this.commandQueue.get();
    }

    void setCommandQueue(CommandQueue newQueue) {
        newQueue.resetSentCommands();
        CommandQueue oldQueue = this.commandQueue.getAndSet(newQueue);
        if (!oldQueue.isEmpty()) {
            throw new IllegalStateException("Old queue not empty");
        }
    }

    long getIdleTime() {
        return System.currentTimeMillis() - this.lastCommandSent.get();
    }

    void resetIdleTime() {
        this.lastCommandSent.set(System.currentTimeMillis());
    }

    boolean isTimedOut() {
        return this.getIdleTime() > this.commandTimeout && this.getCommandQueue().getBusyTime() > this.commandTimeout;
    }
}

