/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands.response;

import com.github.theholywaffle.teamspeak3.api.wrapper.QueryError;
import com.github.theholywaffle.teamspeak3.api.wrapper.Wrapper;
import com.github.theholywaffle.teamspeak3.commands.CommandEncoding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultArrayResponse {
    private static final DefaultArrayResponse EMPTY = new DefaultArrayResponse(new ArrayList<Wrapper>(0), "");
    private final List<Wrapper> responses;
    private final String rawResponse;

    public static DefaultArrayResponse parse(String rawResponse) {
        if (rawResponse == null || rawResponse.isEmpty()) {
            return EMPTY;
        }
        String[] rawMaps = rawResponse.split("\\|");
        ArrayList<Wrapper> responses = new ArrayList<Wrapper>(rawMaps.length);
        if (rawMaps.length == 0) {
            return new DefaultArrayResponse(responses, rawResponse);
        }
        Map<String, String> firstResponse = DefaultArrayResponse.parseMap(rawMaps[0]);
        responses.add(new Wrapper(firstResponse));
        for (int i = 1; i < rawMaps.length; ++i) {
            HashMap<String, String> responseMap = new HashMap<String, String>(firstResponse);
            Map<String, String> ithResponse = DefaultArrayResponse.parseMap(rawMaps[i]);
            responseMap.putAll(ithResponse);
            responses.add(new Wrapper(responseMap));
        }
        return new DefaultArrayResponse(responses, rawResponse);
    }

    public static QueryError parseError(String rawError) {
        String error = rawError.substring("error ".length());
        Map<String, String> errorMap = DefaultArrayResponse.parseMap(error);
        return new QueryError(errorMap);
    }

    private static Map<String, String> parseMap(String rawMap) {
        if (rawMap == null || rawMap.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] parameters = rawMap.split(" ");
        HashMap<String, String> map = new HashMap<String, String>(parameters.length);
        for (String param : parameters) {
            if (param.isEmpty()) continue;
            int pos = param.indexOf("=");
            if (pos == -1) {
                String valuelessKey = CommandEncoding.decode(param);
                map.put(valuelessKey, "");
                continue;
            }
            String key = CommandEncoding.decode(param.substring(0, pos));
            String value = CommandEncoding.decode(param.substring(pos + 1));
            map.put(key, value);
        }
        return map;
    }

    private DefaultArrayResponse(List<Wrapper> responses, String rawResponse) {
        this.responses = Collections.unmodifiableList(responses);
        this.rawResponse = rawResponse;
    }

    public List<Wrapper> getResponses() {
        return this.responses;
    }

    public Wrapper getFirstResponse() {
        if (this.responses.isEmpty()) {
            return Wrapper.EMPTY;
        }
        return this.responses.get(0);
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public String toString() {
        return this.rawResponse;
    }
}

