/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api.wrapper;

import com.github.theholywaffle.teamspeak3.api.ClientProperty;
import com.github.theholywaffle.teamspeak3.api.wrapper.Client;
import java.util.Map;

public class ClientInfo
extends Client {
    private final int clientId;

    public ClientInfo(int clientId, Map<String, String> map) {
        super(map);
        this.clientId = clientId;
    }

    @Override
    public int getId() {
        return this.clientId;
    }

    public String getAvatar() {
        return this.get(ClientProperty.CLIENT_FLAG_AVATAR);
    }

    public long getBandwidthReceivedLastMinute() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthReceivedLastSecond() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_RECEIVED_LAST_SECOND_TOTAL);
    }

    public long getBandwidthSentlastMinute() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_SENT_LAST_MINUTE_TOTAL);
    }

    public long getBandwidthSentLastSecond() {
        return this.getLong(ClientProperty.CONNECTION_BANDWIDTH_SENT_LAST_SECOND_TOTAL);
    }

    public String getBase64ClientUId() {
        return this.get("client_base64HashClientUID");
    }

    public int getDefaultChannel() {
        String channelId = this.get(ClientProperty.CLIENT_DEFAULT_CHANNEL);
        if (channelId.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(channelId.substring(1));
    }

    public String getDefaultToken() {
        return this.get(ClientProperty.CLIENT_DEFAULT_TOKEN);
    }

    public String getDescription() {
        return this.get(ClientProperty.CLIENT_DESCRIPTION);
    }

    public long getFiletransferBandwidthReceived() {
        return this.getLong(ClientProperty.CONNECTION_FILETRANSFER_BANDWIDTH_RECEIVED);
    }

    public long getFiletransferBandwidthSent() {
        return this.getLong(ClientProperty.CONNECTION_FILETRANSFER_BANDWIDTH_SENT);
    }

    public String getLoginName() {
        return this.get(ClientProperty.CLIENT_LOGIN_NAME);
    }

    public String getMetaData() {
        return this.get(ClientProperty.CLIENT_META_DATA);
    }

    public long getMonthlyBytesDownloaded() {
        return this.getLong(ClientProperty.CLIENT_MONTH_BYTES_DOWNLOADED);
    }

    public long getMonthlyBytesUploaded() {
        return this.getLong(ClientProperty.CLIENT_MONTH_BYTES_UPLOADED);
    }

    public int getNeededServerQueryViewPower() {
        return this.getInt(ClientProperty.CLIENT_NEEDED_SERVERQUERY_VIEW_POWER);
    }

    public String getPhoneticNickname() {
        return this.get(ClientProperty.CLIENT_NICKNAME_PHONETIC);
    }

    public String getTalkRequestMessage() {
        return this.get(ClientProperty.CLIENT_TALK_REQUEST_MSG);
    }

    public long getTimeConnected() {
        return this.getLong(ClientProperty.CONNECTION_CONNECTED_TIME);
    }

    public long getTotalBytesDownloaded() {
        return this.getLong(ClientProperty.CLIENT_TOTAL_BYTES_DOWNLOADED);
    }

    public long getTotalBytesReceived() {
        return this.getLong(ClientProperty.CONNECTION_BYTES_RECEIVED_TOTAL);
    }

    public long getTotalBytesSent() {
        return this.getLong(ClientProperty.CONNECTION_BYTES_SENT_TOTAL);
    }

    public long getTotalBytesUploaded() {
        return this.getLong(ClientProperty.CLIENT_TOTAL_BYTES_UPLOADED);
    }

    public int getTotalConnections() {
        return this.getInt(ClientProperty.CLIENT_TOTALCONNECTIONS);
    }

    public long getTotalPacketsReceived() {
        return this.getLong(ClientProperty.CONNECTION_PACKETS_RECEIVED_TOTAL);
    }

    public long getTotalPacketsSent() {
        return this.getLong(ClientProperty.CONNECTION_PACKETS_SENT_TOTAL);
    }

    public int getUnreadMessages() {
        return this.getInt(ClientProperty.CLIENT_UNREAD_MESSAGES);
    }

    public boolean isOutputOnlyMuted() {
        return this.getBoolean(ClientProperty.CLIENT_OUTPUTONLY_MUTED);
    }

    public boolean isRequestingToTalk() {
        return this.getBoolean(ClientProperty.CLIENT_TALK_REQUEST);
    }

    @Override
    public boolean isTalking() {
        throw new UnsupportedOperationException();
    }
}

