/*
 * Decompiled with CFR 0.152.
 */
package org.kathrynhuxtable.maven.wagon.gitsite.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.add.GitAddCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitSiteCheckInCommand
extends AbstractCheckInCommand
implements GitCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            return new CheckInScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        try {
            int exitCode;
            Commandline cl = null;
            if (!fileSet.getFileList().isEmpty() && (exitCode = GitCommandLineUtils.execute((Commandline)(cl = GitAddCommand.createCommandLine((File)fileSet.getBasedir(), (List)fileSet.getFileList())), (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger())) != 0) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), "The git-add command failed.", stderr.getOutput(), false);
                return checkInScmResult;
            }
            GitStatusConsumer statusConsumer = new GitStatusConsumer(this.getLogger(), fileSet.getBasedir());
            cl = GitStatusCommand.createCommandLine((GitScmProviderRepository)repository, (ScmFileSet)fileSet);
            exitCode = GitCommandLineUtils.execute((Commandline)cl, (StreamConsumer)statusConsumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
            if (exitCode != 0 && this.getLogger().isInfoEnabled()) {
                this.getLogger().info("nothing added to commit but untracked files present (use \"git add\" to track)");
            }
            if ((exitCode = GitCommandLineUtils.execute((Commandline)(cl = this.createCommitCommandLine(fileSet, messageFile)), (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger())) != 0) {
                CheckInScmResult ex = new CheckInScmResult(cl.toString(), "The git-commit command failed.", stderr.getOutput(), false);
                return ex;
            }
            cl = this.createPushCommandLine(fileSet, repository, version);
            exitCode = GitCommandLineUtils.execute((Commandline)cl, (CommandLineUtils.StringStreamConsumer)stdout, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)this.getLogger());
            if (exitCode != 0) {
                CheckInScmResult ex = new CheckInScmResult(cl.toString(), "The git-push command failed.", stderr.getOutput(), false);
                return ex;
            }
            ArrayList<ScmFile> checkedInFiles = new ArrayList<ScmFile>(statusConsumer.getChangedFiles().size());
            for (ScmFile foo : statusConsumer.getChangedFiles()) {
                ScmFile scmfile = new ScmFile(foo.getPath(), ScmFileStatus.CHECKED_IN);
                if (fileSet.getFileList().isEmpty()) {
                    checkedInFiles.add(scmfile);
                    continue;
                }
                for (File f : fileSet.getFileList()) {
                    if (!f.toString().equals(scmfile.getPath())) continue;
                    checkedInFiles.add(scmfile);
                }
            }
            CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), checkedInFiles);
            return checkInScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException ex) {}
        }
    }

    private Commandline createCommitCommandLine(ScmFileSet fileSet, File messageFile) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"commit");
        cl.createArg().setValue("--verbose");
        cl.createArg().setValue("--allow-empty");
        cl.createArg().setValue("-F");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        if (fileSet.getFileList().isEmpty()) {
            cl.createArg().setValue("-a");
        } else {
            GitCommandLineUtils.addTarget((Commandline)cl, (List)fileSet.getFileList());
        }
        if (GitUtil.getSettings().isCommitNoVerify()) {
            cl.createArg().setValue("--no-verify");
        }
        return cl;
    }

    private Commandline createPushCommandLine(ScmFileSet fileSet, GitScmProviderRepository repository, ScmVersion version) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine((File)fileSet.getBasedir(), (String)"push");
        cl.createArg().setValue("origin");
        cl.createArg().setValue("master:" + version.getName());
        return cl;
    }
}

