/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeferredTaskRunner {
    private final AtomicBoolean condition = new AtomicBoolean(false);
    private final List<Runnable> deferredTasks = new ArrayList<Runnable>();

    public void execute() {
        this.condition.set(true);
        this.deferredTasks.forEach(Runnable::run);
        this.deferredTasks.clear();
    }

    public void schedule(Runnable runnable) {
        if (this.condition.get()) {
            runnable.run();
            return;
        }
        this.deferredTasks.add(runnable);
    }
}

