/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.binary.BinaryDecoder;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.GroupMetadata;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.message.model.QuotedMessage;
import it.auties.whatsapp.model.message.server.ProtocolMessage;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.request.Request;
import it.auties.whatsapp.model.response.ContactStatusResponse;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.signal.auth.ClientHello;
import it.auties.whatsapp.model.signal.auth.HandshakeMessage;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.socket.AppStateHandler;
import it.auties.whatsapp.socket.AuthHandler;
import it.auties.whatsapp.socket.MessageHandler;
import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.socket.StreamHandler;
import it.auties.whatsapp.util.Clock;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class SocketHandler
implements SocketListener {
    private static final Executor DEFAULT_EXECUTOR = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : runnable -> new Thread(runnable).start();
    private static final Set<UUID> connectedUuids = ConcurrentHashMap.newKeySet();
    private static final Set<Long> connectedPhoneNumbers = ConcurrentHashMap.newKeySet();
    private static final Set<String> connectedAlias = ConcurrentHashMap.newKeySet();
    private SocketSession session;
    @NonNull
    private final Whatsapp whatsapp;
    @NonNull
    private final AuthHandler authHandler;
    @NonNull
    private final StreamHandler streamHandler;
    @NonNull
    private final MessageHandler messageHandler;
    @NonNull
    private final AppStateHandler appStateHandler;
    @NonNull
    private final ErrorHandler errorHandler;
    @NonNull
    private final Executor socketExecutor;
    @NonNull
    private SocketState state;
    @NonNull
    private Keys keys;
    @NonNull
    private Store store;
    private Thread shutdownHook;
    private CompletableFuture<Void> loginFuture;
    private CompletableFuture<Void> logoutFuture;
    private ExecutorService listenersService;
    private Node lastNode;

    public static boolean isConnected(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return connectedUuids.contains(uuid);
    }

    public static boolean isConnected(long phoneNumber) {
        return connectedPhoneNumbers.contains(phoneNumber);
    }

    public static boolean isConnected(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return connectedAlias.contains(id);
    }

    public SocketHandler(@NonNull Whatsapp whatsapp, @NonNull Store store, @NonNull Keys keys, ErrorHandler errorHandler, WebVerificationSupport webVerificationSupport, Executor socketExecutor) {
        if (whatsapp == null) {
            throw new NullPointerException("whatsapp is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.whatsapp = whatsapp;
        this.store = store;
        this.keys = keys;
        this.state = SocketState.WAITING;
        this.authHandler = new AuthHandler(this);
        this.streamHandler = new StreamHandler(this, webVerificationSupport);
        this.messageHandler = new MessageHandler(this);
        this.appStateHandler = new AppStateHandler(this);
        this.errorHandler = Objects.requireNonNullElse(errorHandler, ErrorHandler.toTerminal());
        this.socketExecutor = Objects.requireNonNullElse(socketExecutor, DEFAULT_EXECUTOR);
    }

    private void onShutdown(boolean reconnect) {
        if (this.state != SocketState.LOGGED_OUT && this.state != SocketState.RESTORE) {
            this.keys.dispose();
            this.store.dispose();
        }
        if (!reconnect) {
            this.dispose();
        }
    }

    protected void onSocketEvent(SocketEvent event) {
        this.callListenersAsync(listener -> {
            listener.onSocketEvent(this.whatsapp, event);
            listener.onSocketEvent(event);
        });
    }

    private void callListenersAsync(Consumer<Listener> consumer) {
        ExecutorService service = this.getOrCreateListenersService();
        this.store.listeners().forEach(listener -> service.execute(() -> this.invokeListenerSafe(consumer, (Listener)listener)));
    }

    @Override
    public void onOpen(SocketSession session) {
        this.session = session;
        if (this.state == SocketState.CONNECTED) {
            return;
        }
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(() -> this.onShutdown(false));
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        this.markConnected();
        this.state = SocketState.WAITING;
        this.onSocketEvent(SocketEvent.OPEN);
        ClientHello clientHello = new ClientHello(this.keys.ephemeralKeyPair().publicKey());
        HandshakeMessage handshakeMessage = new HandshakeMessage(clientHello);
        Request.of(handshakeMessage).sendWithPrologue(session, this.keys, this.store).exceptionallyAsync(throwable -> (Node)this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
    }

    protected void markConnected() {
        connectedUuids.add(this.store.uuid());
        this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::add);
        connectedAlias.addAll(this.store.alias());
    }

    @Override
    public void onMessage(byte[] message) {
        if (this.state != SocketState.CONNECTED && this.state != SocketState.RESTORE) {
            ((CompletableFuture)this.authHandler.login(this.session, message).thenApplyAsync(result -> result != false ? this.state(SocketState.CONNECTED) : null)).exceptionallyAsync(throwable -> (SocketHandler)this.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
            return;
        }
        if (this.keys.readKey() == null) {
            return;
        }
        BinaryDecoder decoder = new BinaryDecoder();
        byte[] plainText = AesGmc.decrypt(this.keys.readCounter(true), message, this.keys.readKey());
        Node node = decoder.decode(plainText);
        if (!node.hasNode("bad-mac")) {
            this.lastNode = node;
        }
        this.onNodeReceived(node);
        this.store.resolvePendingRequest(node, false);
        this.streamHandler.digest(node);
    }

    private void onNodeReceived(Node deciphered) {
        this.callListenersAsync(listener -> {
            listener.onNodeReceived(this.whatsapp, deciphered);
            listener.onNodeReceived(deciphered);
        });
    }

    @Override
    public void onClose() {
        if (this.state == SocketState.CONNECTED) {
            this.disconnect(DisconnectReason.RECONNECTING);
            return;
        }
        this.onDisconnected(this.state.toReason());
        this.onShutdown(this.state == SocketState.RECONNECTING);
    }

    @Override
    public void onError(Throwable throwable) {
        this.onSocketEvent(SocketEvent.ERROR);
        this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
    }

    public synchronized CompletableFuture<Void> connect() {
        if (this.state == SocketState.CONNECTED) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.loginFuture == null || this.loginFuture.isDone()) {
            this.loginFuture = new CompletableFuture();
        }
        if (this.logoutFuture == null || this.logoutFuture.isDone()) {
            this.logoutFuture = new CompletableFuture();
        }
        this.session = new SocketSession(this.store.proxy().orElse(null), this.socketExecutor);
        return this.session.connect(this).thenCompose(ignored -> this.loginFuture);
    }

    public CompletableFuture<Void> loginFuture() {
        return this.loginFuture;
    }

    public CompletableFuture<Void> logoutFuture() {
        return this.logoutFuture;
    }

    public CompletableFuture<Void> disconnect(DisconnectReason reason) {
        this.state(SocketState.of(reason));
        this.keys.clearReadWriteKey();
        return switch (reason) {
            default -> throw new IncompatibleClassChangeError();
            case DisconnectReason.DISCONNECTED -> {
                if (this.session != null) {
                    this.session.close();
                }
                yield CompletableFuture.completedFuture(null);
            }
            case DisconnectReason.RECONNECTING -> {
                if (this.session != null) {
                    this.session.close();
                }
                yield this.connect();
            }
            case DisconnectReason.LOGGED_OUT -> {
                this.store.deleteSession();
                this.store.resolveAllPendingRequests();
                if (this.session != null) {
                    this.session.close();
                }
                yield CompletableFuture.completedFuture(null);
            }
            case DisconnectReason.RESTORE -> {
                this.store.deleteSession();
                this.store.resolveAllPendingRequests();
                ArrayList<Listener> oldListeners = new ArrayList<Listener>(this.store.listeners());
                if (this.session != null) {
                    this.session.close();
                }
                UUID uuid = UUID.randomUUID();
                Long number = this.store.phoneNumber().map(PhoneNumber::number).orElse(null);
                this.keys = Keys.random(uuid, number, this.store.clientType(), this.store.serializer(), new String[0]);
                this.store = Store.random(uuid, number, this.store.clientType(), this.store.serializer(), new String[0]);
                this.store.addListeners(oldListeners);
                yield this.connect();
            }
        };
    }

    public CompletableFuture<Void> pushPatch(PatchRequest request) {
        return this.appStateHandler.push(this.store.jid(), List.of(request));
    }

    public CompletableFuture<Void> pushPatches(ContactJid jid, List<PatchRequest> requests) {
        return this.appStateHandler.push(jid, requests);
    }

    public void pullPatch(BinaryPatchType ... patchTypes) {
        this.appStateHandler.pull(patchTypes);
    }

    protected CompletableFuture<Void> pullInitialPatches() {
        return this.appStateHandler.pullInitial();
    }

    public void decodeMessage(Node node) {
        this.messageHandler.decode(node);
    }

    public CompletableFuture<Void> sendPeerMessage(ContactJid companion, ProtocolMessage message) {
        if (message == null) {
            return CompletableFuture.completedFuture(null);
        }
        MessageKey key = MessageKey.builder().chatJid(companion).fromMe(true).senderJid(this.store().jid()).build();
        MessageInfo info = MessageInfo.builder().senderJid(this.store().jid()).key(key).message(MessageContainer.of(message)).timestampSeconds(Clock.nowSeconds()).build();
        MessageSendRequest request = MessageSendRequest.builder().info(info).peer(true).build();
        return this.sendMessage(request);
    }

    public CompletableFuture<Void> sendMessage(MessageSendRequest request) {
        this.store.attribute(request.info());
        return this.messageHandler.encode(request);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String method, String category, Node ... body) {
        return this.sendQueryWithNoResponse(null, ContactJid.Server.WHATSAPP.toJid(), method, category, null, body);
    }

    public CompletableFuture<Void> sendQueryWithNoResponse(String id, ContactJid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        ConcurrentHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("id", id, Objects::nonNull).put("type", method).put("to", to).put("xmlns", category, Objects::nonNull).toMap();
        return this.sendWithNoResponse(Node.of("iq", attributes, body));
    }

    public CompletableFuture<Void> sendWithNoResponse(Node node) {
        if (this.state() == SocketState.RESTORE) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)node.toRequest(null, false).sendWithNoResponse(this.session, this.keys, this.store).exceptionallyAsync(throwable -> (Void)this.handleFailure(ErrorHandler.Location.STREAM, (Throwable)throwable))).thenRunAsync(() -> this.onNodeSent(node));
    }

    private void onNodeSent(Node node) {
        this.callListenersAsync(listener -> {
            listener.onNodeSent(this.whatsapp, node);
            listener.onNodeSent(node);
        });
    }

    public CompletableFuture<Optional<ContactStatusResponse>> queryAbout(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node query = Node.of("status");
        Node body = Node.of("user", Map.of("jid", chat.toJid()));
        return this.sendInteractiveQuery(query, body).thenApplyAsync(this::parseStatus);
    }

    public CompletableFuture<List<Node>> sendInteractiveQuery(Node queryNode, Node ... queryBody) {
        Node query = Node.of("query", (Object)queryNode);
        Node list = Node.of("list", queryBody);
        Node sync = Node.of("usync", Map.of("sid", UUID.randomUUID().toString(), "mode", "query", "last", "true", "index", "0", "context", "interactive"), query, list);
        return this.sendQuery("get", "usync", sync).thenApplyAsync(this::parseQueryResult);
    }

    private Optional<ContactStatusResponse> parseStatus(List<Node> responses) {
        return responses.stream().map(entry -> entry.findNode("status")).flatMap(Optional::stream).findFirst().map(ContactStatusResponse::new);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Node ... body) {
        return this.sendQuery(null, ContactJid.Server.WHATSAPP.toJid(), method, category, null, body);
    }

    private List<Node> parseQueryResult(Node result) {
        return result.findNodes("usync").stream().map(node -> node.findNode("list")).flatMap(Optional::stream).map(node -> node.findNodes("user")).flatMap(Collection::stream).toList();
    }

    public CompletableFuture<Node> sendQuery(String id, ContactJid to, String method, String category, Map<String, Object> metadata, Node ... body) {
        ConcurrentHashMap<String, Object> attributes = Attributes.ofNullable(metadata).put("id", id, Objects::nonNull).put("type", method).put("to", to).put("xmlns", category, Objects::nonNull).toMap();
        return this.send(Node.of("iq", attributes, body));
    }

    public CompletableFuture<Node> send(Node node) {
        return this.send(node, null);
    }

    public CompletableFuture<Node> send(Node node, Function<Node, Boolean> filter) {
        if (this.state() == SocketState.RESTORE) {
            return CompletableFuture.completedFuture(node);
        }
        Request request = node.toRequest(filter, true);
        CompletableFuture<Node> result = request.send(this.session, this.keys, this.store);
        this.onNodeSent(node);
        return result;
    }

    public CompletableFuture<Optional<URI>> queryPicture(@NonNull ContactJidProvider chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node body = Node.of("picture", Map.of("query", "url", "type", "image"));
        if (chat.toJid().hasServer(ContactJid.Server.GROUP)) {
            return ((CompletableFuture)this.queryGroupMetadata(chat.toJid()).thenComposeAsync(result -> this.sendQuery("get", "w:profile:picture", Map.of(result.community() ? "parent_group_jid" : "target", chat.toJid()), body))).thenApplyAsync(this::parseChatPicture);
        }
        return this.sendQuery("get", "w:profile:picture", Map.of("target", chat.toJid()), body).thenApplyAsync(this::parseChatPicture);
    }

    public CompletableFuture<Node> sendQuery(String method, String category, Map<String, Object> metadata, Node ... body) {
        return this.sendQuery(null, ContactJid.Server.WHATSAPP.toJid(), method, category, metadata, body);
    }

    private Optional<URI> parseChatPicture(Node result) {
        return result.findNode("picture").flatMap(picture -> picture.attributes().getOptionalString("url")).map(URI::create);
    }

    public CompletableFuture<List<ContactJid>> queryBlockList() {
        return this.sendQuery("get", "blocklist", new Node[]{null}).thenApplyAsync(this::parseBlockList);
    }

    private List<ContactJid> parseBlockList(Node result) {
        return result.findNode("list").orElseThrow(() -> new NoSuchElementException("Missing block list in response")).findNodes("item").stream().map(item -> item.attributes().getJid("jid")).flatMap(Optional::stream).toList();
    }

    public CompletableFuture<Void> subscribeToPresence(ContactJidProvider jid) {
        Node node = Node.of("presence", Map.of("to", jid.toJid(), "type", "subscribe"));
        return this.sendWithNoResponse(node);
    }

    public CompletableFuture<GroupMetadata> queryGroupMetadata(ContactJidProvider group) {
        Node body = Node.of("query", Map.of("request", "interactive"));
        return this.sendQuery(group.toJid(), "get", "w:g2", body).thenApplyAsync(response -> this.handleGroupMetadata(group, (Node)response));
    }

    private GroupMetadata handleGroupMetadata(ContactJidProvider group, Node response) {
        Chat entry;
        Chat chat;
        GroupMetadata metadata = response.findNode("group").map(GroupMetadata::of).orElseThrow(() -> new NoSuchElementException("Erroneous response: %s".formatted(response)));
        Chat chat2 = chat = group instanceof Chat ? (entry = (Chat)group) : (Chat)this.store.findChatByJid(group).orElse(null);
        if (chat != null) {
            metadata.founder().ifPresent(chat::founder);
            chat.foundationTimestampSeconds(metadata.foundationTimestamp().toEpochSecond());
            metadata.description().ifPresent(chat::description);
            chat.addParticipants(metadata.participants());
        }
        return metadata;
    }

    public CompletableFuture<Node> sendQuery(ContactJid to, String method, String category, Node ... body) {
        return this.sendQuery(null, to, method, category, null, body);
    }

    public void sendReceipt(ContactJid jid, ContactJid participant, List<String> messages, String type) {
        if (messages.isEmpty()) {
            return;
        }
        Attributes attributes = Attributes.of(new Map.Entry[0]).put("id", messages.get(0)).put("t", (Object)Clock.nowMilliseconds(), () -> Objects.equals(type, "read") || Objects.equals(type, "read-self")).put("to", jid).put("type", type, Objects::nonNull);
        if (Objects.equals(type, "sender") && jid.hasServer(ContactJid.Server.WHATSAPP)) {
            attributes.put("recipient", jid);
            attributes.put("to", participant);
        } else {
            attributes.put("to", jid);
            attributes.put("participant", participant, Objects::nonNull);
        }
        Node receipt = Node.of("receipt", attributes.toMap(), this.toMessagesNode(messages));
        this.sendWithNoResponse(receipt);
    }

    private List<Node> toMessagesNode(List<String> messages) {
        if (messages.size() <= 1) {
            return null;
        }
        return messages.subList(1, messages.size()).stream().map(id -> Node.of("item", Map.of("id", id))).toList();
    }

    protected void sendMessageAck(Node node) {
        Attributes attrs = node.attributes();
        String type = attrs.getOptionalString("type").filter(entry -> !Objects.equals(entry, "message")).orElse(null);
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", node.id()).put("to", node.attributes().getRequiredString("from")).put("class", node.description()).put("participant", attrs.getNullableString("participant"), Objects::nonNull).put("recipient", attrs.getNullableString("recipient"), Objects::nonNull).put("type", type, Objects::nonNull).toMap();
        this.sendWithNoResponse(Node.of("ack", attributes));
    }

    protected void onRegistrationCode(long code) {
        this.callListenersAsync(listener -> {
            listener.onRegistrationCode(this.whatsapp, code);
            listener.onRegistrationCode(code);
        });
    }

    protected void onMetadata(Map<String, String> properties) {
        this.callListenersAsync(listener -> {
            listener.onMetadata(this.whatsapp, properties);
            listener.onMetadata(properties);
        });
    }

    protected void onMessageStatus(MessageStatus status, Contact participant, MessageInfo message, Chat chat) {
        this.callListenersAsync(listener -> {
            if (participant == null) {
                listener.onConversationMessageStatus(this.whatsapp, message, status);
                listener.onConversationMessageStatus(message, status);
            }
            listener.onAnyMessageStatus(this.whatsapp, chat, participant, message, status);
            listener.onAnyMessageStatus(chat, participant, message, status);
        });
    }

    protected void onUpdateChatPresence(ContactStatus status, ContactJid contactJid, Chat chat) {
        Optional<Contact> contact = this.store.findContactByJid(contactJid);
        if (contact.isPresent()) {
            contact.get().lastKnownPresence(status);
            if (status == contact.get().lastKnownPresence()) {
                return;
            }
            contact.get().lastSeen(ZonedDateTime.now());
        }
        chat.presences().put(contactJid, status);
        this.callListenersAsync(listener -> {
            listener.onContactPresence(this.whatsapp, chat, contactJid, status);
            listener.onContactPresence(chat, contactJid, status);
        });
    }

    protected void onNewMessage(MessageInfo info, boolean offline) {
        this.callListenersAsync(listener -> {
            listener.onNewMessage(this.whatsapp, info);
            listener.onNewMessage(info);
            listener.onNewMessage(this.whatsapp, info, offline);
            listener.onNewMessage(info, offline);
        });
    }

    protected void onNewStatus(MessageInfo info) {
        this.callListenersAsync(listener -> {
            listener.onNewStatus(this.whatsapp, info);
            listener.onNewStatus(info);
        });
    }

    protected void onChatRecentMessages(Chat chat, boolean last) {
        this.callListenersAsync(listener -> {
            listener.onChatMessagesSync(this.whatsapp, chat, last);
            listener.onChatMessagesSync(chat, last);
        });
    }

    protected void onFeatures(ActionValueSync.PrimaryFeature features) {
        this.callListenersAsync(listener -> {
            listener.onFeatures(this.whatsapp, features.flags());
            listener.onFeatures(features.flags());
        });
    }

    protected void onSetting(Setting setting) {
        this.callListenersAsync(listener -> {
            listener.onSetting(this.whatsapp, setting);
            listener.onSetting(setting);
        });
    }

    protected void onMessageDeleted(MessageInfo message, boolean everyone) {
        this.callListenersAsync(listener -> {
            listener.onMessageDeleted(this.whatsapp, message, everyone);
            listener.onMessageDeleted(message, everyone);
        });
    }

    protected void onAction(Action action, MessageIndexInfo indexInfo) {
        this.callListenersAsync(listener -> {
            listener.onAction(this.whatsapp, action, indexInfo);
            listener.onAction(action, indexInfo);
        });
    }

    protected void onDisconnected(DisconnectReason loggedOut) {
        if (loggedOut != DisconnectReason.RECONNECTING) {
            connectedUuids.remove(this.store.uuid());
            this.store.phoneNumber().map(PhoneNumber::number).ifPresent(connectedPhoneNumbers::remove);
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            if (this.loginFuture != null && !this.loginFuture.isDone()) {
                this.loginFuture.complete(null);
            }
            if (this.logoutFuture != null && !this.logoutFuture.isDone()) {
                this.logoutFuture.complete(null);
            }
        }
        this.callListenersSync(listener -> {
            listener.onDisconnected(this.whatsapp, loggedOut);
            listener.onDisconnected(loggedOut);
        });
    }

    protected void onLoggedIn() {
        if (!this.loginFuture.isDone()) {
            this.loginFuture.complete(null);
        }
        this.callListenersAsync(listener -> {
            listener.onLoggedIn(this.whatsapp);
            listener.onLoggedIn();
        });
    }

    public void callListenersSync(Consumer<Listener> consumer) {
        ExecutorService service = this.getOrCreateListenersService();
        CompletableFuture[] futures = (CompletableFuture[])this.store.listeners().stream().map(listener -> CompletableFuture.runAsync(() -> this.invokeListenerSafe(consumer, (Listener)listener), service)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    private void invokeListenerSafe(Consumer<Listener> consumer, Listener listener) {
        try {
            consumer.accept(listener);
        }
        catch (Throwable throwable) {
            this.handleFailure(ErrorHandler.Location.UNKNOWN, throwable);
        }
    }

    protected void onChats() {
        this.callListenersAsync(listener -> {
            listener.onChats(this.whatsapp, this.store().chats());
            listener.onChats(this.store().chats());
        });
    }

    protected void onStatus() {
        this.callListenersAsync(listener -> {
            listener.onStatus(this.whatsapp, this.store().status());
            listener.onStatus(this.store().status());
        });
    }

    protected void onContacts() {
        this.callListenersAsync(listener -> {
            listener.onContacts(this.whatsapp, this.store().contacts());
            listener.onContacts(this.store().contacts());
        });
    }

    protected void onHistorySyncProgress(Integer progress, boolean recent) {
        this.callListenersAsync(listener -> {
            listener.onHistorySyncProgress(this.whatsapp, progress, recent);
            listener.onHistorySyncProgress(progress, recent);
        });
    }

    protected void onReply(MessageInfo info) {
        QuotedMessage quoted = info.quotedMessage().orElse(null);
        if (quoted == null) {
            return;
        }
        this.store.resolvePendingReply(info);
        this.callListenersAsync(listener -> {
            listener.onMessageReply(this.whatsapp, info, quoted);
            listener.onMessageReply(info, quoted);
        });
    }

    protected void onGroupPictureChange(Chat fromChat) {
        this.callListenersAsync(listener -> {
            listener.onGroupPictureChange(this.whatsapp, fromChat);
            listener.onGroupPictureChange(fromChat);
        });
    }

    protected void onContactPictureChange(Contact fromContact) {
        this.callListenersAsync(listener -> {
            listener.onContactPictureChange(this.whatsapp, fromContact);
            listener.onContactPictureChange(fromContact);
        });
    }

    protected void onUserAboutChange(String newAbout, String oldAbout) {
        this.callListenersAsync(listener -> {
            listener.onUserAboutChange(this.whatsapp, oldAbout, newAbout);
            listener.onUserAboutChange(oldAbout, newAbout);
        });
    }

    public void onUserPictureChange(URI newPicture, URI oldPicture) {
        this.callListenersAsync(listener -> {
            listener.onUserPictureChange(this.whatsapp, oldPicture, newPicture);
            listener.onUserPictureChange(oldPicture, newPicture);
        });
    }

    public void updateUserName(String newName, String oldName) {
        if (oldName != null && !Objects.equals(newName, oldName)) {
            this.sendWithNoResponse(Node.of("presence", Map.of("name", oldName, "type", "unavailable")));
            this.sendWithNoResponse(Node.of("presence", Map.of("name", newName, "type", "available")));
            this.onUserNameChange(newName, oldName);
        }
        ContactJid self = this.store().jid().toWhatsappJid();
        this.store().findContactByJid(self).orElseGet(() -> this.store().addContact(self)).chosenName(newName);
        this.store().name(newName);
    }

    private void onUserNameChange(String newName, String oldName) {
        this.callListenersAsync(listener -> {
            listener.onUserNameChange(this.whatsapp, oldName, newName);
            listener.onUserNameChange(oldName, newName);
        });
    }

    public void updateLocale(String newLocale, String oldLocale) {
        if (!Objects.equals(newLocale, oldLocale)) {
            return;
        }
        if (oldLocale != null) {
            this.onUserLocaleChange(newLocale, oldLocale);
        }
        this.store().locale(newLocale);
    }

    private void onUserLocaleChange(String newLocale, String oldLocale) {
        this.callListenersAsync(listener -> {
            listener.onUserLocaleChange(this.whatsapp, oldLocale, newLocale);
            listener.onUserLocaleChange(oldLocale, newLocale);
        });
    }

    protected void onContactBlocked(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onContactBlocked(this.whatsapp, contact);
            listener.onContactBlocked(contact);
        });
    }

    protected void onNewContact(Contact contact) {
        this.callListenersAsync(listener -> {
            listener.onNewContact(this.whatsapp, contact);
            listener.onNewContact(contact);
        });
    }

    protected void onDevices(LinkedHashMap<ContactJid, Integer> devices) {
        this.callListenersAsync(listener -> {
            listener.onLinkedDevices(this.whatsapp, devices.keySet());
            listener.onLinkedDevices(devices.keySet());
        });
    }

    public void onPrivacySettingChanged(PrivacySettingEntry oldEntry, PrivacySettingEntry newEntry) {
        this.callListenersAsync(listener -> {
            listener.onPrivacySettingChanged(this.whatsapp, oldEntry, newEntry);
            listener.onPrivacySettingChanged(oldEntry, newEntry);
        });
    }

    protected void querySessionsForcefully(ContactJid contactJid) {
        this.messageHandler.querySessions(List.of(contactJid), true);
    }

    private void dispose() {
        this.onSocketEvent(SocketEvent.CLOSE);
        this.streamHandler.dispose();
        this.messageHandler.dispose();
        this.appStateHandler.dispose();
        if (this.listenersService != null) {
            this.listenersService.shutdownNow();
        }
    }

    private synchronized ExecutorService getOrCreateListenersService() {
        if (this.listenersService == null || this.listenersService.isShutdown()) {
            this.listenersService = Executors.newCachedThreadPool();
        }
        return this.listenersService;
    }

    protected <T> T handleFailure(ErrorHandler.Location location, Throwable throwable) {
        if (this.state() == SocketState.RESTORE || this.state() == SocketState.LOGGED_OUT) {
            return null;
        }
        ErrorHandler.Result result = this.errorHandler.handleError(this.store.clientType(), location, throwable);
        switch (result) {
            case RESTORE: {
                this.disconnect(DisconnectReason.RESTORE);
                break;
            }
            case LOG_OUT: {
                this.disconnect(DisconnectReason.LOGGED_OUT);
                break;
            }
            case DISCONNECT: {
                this.disconnect(DisconnectReason.DISCONNECTED);
                break;
            }
            case RECONNECT: {
                this.disconnect(DisconnectReason.RECONNECTING);
            }
        }
        return null;
    }

    public CompletableFuture<Void> queryCompanionDevices() {
        return this.messageHandler.getDevices(List.of(this.store.jid().toWhatsappJid()), true).thenCompose(values -> this.messageHandler.querySessions((List<ContactJid>)values, false));
    }

    public void parseSessions(Node result) {
        this.messageHandler.parseSessions(result);
    }

    public CompletableFuture<List<BusinessCategory>> queryBusinessCategories() {
        return this.sendQuery("get", "fb:thrift_iq", Node.of("request", Map.of("op", "profile_typeahead", "type", "catkit", "v", "1"), (Object)Node.of("query", List.of()))).thenApplyAsync(this::parseBusinessCategories);
    }

    private List<BusinessCategory> parseBusinessCategories(Node result) {
        return result.findNode("response").flatMap(entry -> entry.findNode("categories")).stream().map(entry -> entry.findNodes("category")).flatMap(Collection::stream).map(BusinessCategory::of).toList();
    }

    Node lastNode() {
        return this.lastNode;
    }

    @NonNull
    public Whatsapp whatsapp() {
        return this.whatsapp;
    }

    @NonNull
    public SocketState state() {
        return this.state;
    }

    protected SocketHandler state(@NonNull SocketState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.state = state;
        return this;
    }

    @NonNull
    public Keys keys() {
        return this.keys;
    }

    @NonNull
    public Store store() {
        return this.store;
    }
}

