/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.Node;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@JsonDeserialize(builder=LTHashStateBuilder.class)
public class LTHashState {
    private BinaryPatchType name;
    private long version;
    private byte[] hash;
    private Map<String, byte[]> indexValueMap;

    public LTHashState(BinaryPatchType name) {
        this(name, 0L);
    }

    public LTHashState(BinaryPatchType name, long version) {
        this.name = name;
        this.version = version;
        this.hash = new byte[128];
        this.indexValueMap = new HashMap<String, byte[]>();
    }

    public Node toNode() {
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("name", (Object)this.name).put("version", this.version).put("return_snapshot", this.version == 0L).toMap();
        return Node.of("collection", attributes);
    }

    public LTHashState copy() {
        return new LTHashState(this.name, this.version, Arrays.copyOf(this.hash, this.hash.length), new HashMap<String, byte[]>(this.indexValueMap));
    }

    public boolean equals(Object o) {
        LTHashState that;
        return o instanceof LTHashState && this.version == (that = (LTHashState)o).version() && this.name == that.name() && Arrays.equals(this.hash, that.hash()) && this.checkIndexEquality(that);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name, this.version, this.indexValueMap});
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    private boolean checkIndexEquality(LTHashState that) {
        if (this.indexValueMap.size() != that.indexValueMap().size()) {
            return false;
        }
        return this.indexValueMap().entrySet().stream().allMatch(entry -> LTHashState.checkIndexEntryEquality(that, (String)entry.getKey(), (byte[])entry.getValue()));
    }

    private static boolean checkIndexEntryEquality(LTHashState that, String thisKey, byte[] thisValue) {
        byte[] thatValue = that.indexValueMap().get(thisKey);
        return thatValue != null && Arrays.equals(thatValue, thisValue);
    }

    public static LTHashStateBuilder builder() {
        return new LTHashStateBuilder();
    }

    public LTHashState(BinaryPatchType name, long version, byte[] hash, Map<String, byte[]> indexValueMap) {
        this.name = name;
        this.version = version;
        this.hash = hash;
        this.indexValueMap = indexValueMap;
    }

    public BinaryPatchType name() {
        return this.name;
    }

    public long version() {
        return this.version;
    }

    public byte[] hash() {
        return this.hash;
    }

    public Map<String, byte[]> indexValueMap() {
        return this.indexValueMap;
    }

    public LTHashState name(BinaryPatchType name) {
        this.name = name;
        return this;
    }

    public LTHashState version(long version) {
        this.version = version;
        return this;
    }

    public LTHashState hash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    public LTHashState indexValueMap(Map<String, byte[]> indexValueMap) {
        this.indexValueMap = indexValueMap;
        return this;
    }

    public String toString() {
        return "LTHashState(name=" + this.name() + ", version=" + this.version() + ", hash=" + Arrays.toString(this.hash()) + ", indexValueMap=" + this.indexValueMap() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class LTHashStateBuilder {
        private BinaryPatchType name;
        private long version;
        private byte[] hash;
        private Map<String, byte[]> indexValueMap;

        LTHashStateBuilder() {
        }

        public LTHashStateBuilder name(BinaryPatchType name) {
            this.name = name;
            return this;
        }

        public LTHashStateBuilder version(long version) {
            this.version = version;
            return this;
        }

        public LTHashStateBuilder hash(byte[] hash) {
            this.hash = hash;
            return this;
        }

        public LTHashStateBuilder indexValueMap(Map<String, byte[]> indexValueMap) {
            this.indexValueMap = indexValueMap;
            return this;
        }

        public LTHashState build() {
            return new LTHashState(this.name, this.version, this.hash, this.indexValueMap);
        }

        public String toString() {
            return "LTHashState.LTHashStateBuilder(name=" + this.name + ", version=" + this.version + ", hash=" + Arrays.toString(this.hash) + ", indexValueMap=" + this.indexValueMap + ")";
        }
    }
}

