/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.media.AttachmentProvider;
import it.auties.whatsapp.model.media.AttachmentType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@JsonDeserialize(builder=ExternalBlobReferenceBuilder.class)
public final class ExternalBlobReference
implements ProtobufMessage,
AttachmentProvider {
    @ProtobufProperty(index=1, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private String handle;
    @ProtobufProperty(index=4, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=5, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=6, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;

    @Override
    public String mediaUrl() {
        return null;
    }

    @Override
    public AttachmentProvider mediaUrl(String mediaUrl) {
        return this;
    }

    @Override
    public AttachmentType attachmentType() {
        return AttachmentType.APP_STATE;
    }

    public static ExternalBlobReferenceBuilder builder() {
        return new ExternalBlobReferenceBuilder();
    }

    public ExternalBlobReference(byte[] mediaKey, String mediaDirectPath, String handle, long mediaSize, byte[] mediaSha256, byte[] mediaEncryptedSha256) {
        this.mediaKey = mediaKey;
        this.mediaDirectPath = mediaDirectPath;
        this.handle = handle;
        this.mediaSize = mediaSize;
        this.mediaSha256 = mediaSha256;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    public String handle() {
        return this.handle;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    @Override
    public ExternalBlobReference mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Override
    public ExternalBlobReference mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    public ExternalBlobReference handle(String handle) {
        this.handle = handle;
        return this;
    }

    @Override
    public ExternalBlobReference mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    @Override
    public ExternalBlobReference mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public ExternalBlobReference mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalBlobReference)) {
            return false;
        }
        ExternalBlobReference other = (ExternalBlobReference)o;
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        String this$handle = this.handle();
        String other$handle = other.handle();
        if (this$handle == null ? other$handle != null : !this$handle.equals(other$handle)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        return Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        String $handle = this.handle();
        result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        return result;
    }

    public String toString() {
        return "ExternalBlobReference(mediaKey=" + Arrays.toString(this.mediaKey()) + ", mediaDirectPath=" + this.mediaDirectPath() + ", handle=" + this.handle() + ", mediaSize=" + this.mediaSize() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeUInt64(4, this.mediaSize);
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(1, this.mediaKey);
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(2, this.mediaDirectPath);
        }
        if (this.handle != null) {
            protobufOutputStream.writeString(3, this.handle);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(5, this.mediaSha256);
        }
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(6, this.mediaEncryptedSha256);
        }
        return protobufOutputStream.toByteArray();
    }

    public static ExternalBlobReference ofProtobuf(byte[] byArray) {
        int n;
        ExternalBlobReferenceBuilder externalBlobReferenceBuilder = ExternalBlobReference.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block8: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block8;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block8;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block8;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.handle(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block8;
                }
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block8;
                }
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    externalBlobReferenceBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block8;
                }
            }
            protobufInputStream.readBytes();
        }
        return externalBlobReferenceBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ExternalBlobReferenceBuilder {
        private byte[] mediaKey;
        private String mediaDirectPath;
        private String handle;
        private long mediaSize;
        private byte[] mediaSha256;
        private byte[] mediaEncryptedSha256;

        ExternalBlobReferenceBuilder() {
        }

        public ExternalBlobReferenceBuilder mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return this;
        }

        public ExternalBlobReferenceBuilder mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return this;
        }

        public ExternalBlobReferenceBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public ExternalBlobReferenceBuilder mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return this;
        }

        public ExternalBlobReferenceBuilder mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return this;
        }

        public ExternalBlobReferenceBuilder mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return this;
        }

        public ExternalBlobReference build() {
            return new ExternalBlobReference(this.mediaKey, this.mediaDirectPath, this.handle, this.mediaSize, this.mediaSha256, this.mediaEncryptedSha256);
        }

        public String toString() {
            return "ExternalBlobReference.ExternalBlobReferenceBuilder(mediaKey=" + Arrays.toString(this.mediaKey) + ", mediaDirectPath=" + this.mediaDirectPath + ", handle=" + this.handle + ", mediaSize=" + this.mediaSize + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ")";
        }
    }
}

