/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@JsonDeserialize(builder=SenderMessageKeyBuilder.class)
public record SenderMessageKey(int iteration, byte[] seed, byte[] iv, byte[] cipherKey) {
    public SenderMessageKey(int iteration, byte[] seed) {
        this(iteration, seed, SenderMessageKey.createIv(seed), SenderMessageKey.createCipherKey(seed));
    }

    private static byte[] createIv(byte[] seed) {
        byte[][] derivative = SenderMessageKey.getDerivedSeed(seed);
        return Arrays.copyOf(derivative[0], 16);
    }

    private static byte[] createCipherKey(byte[] seed) {
        byte[][] derivative = SenderMessageKey.getDerivedSeed(seed);
        byte[] data = Arrays.copyOfRange(derivative[0], 16, derivative[0].length);
        byte[] concat = BytesHelper.concat(data, derivative[1]);
        return Arrays.copyOf(concat, 32);
    }

    private static byte[][] getDerivedSeed(byte[] seed) {
        return Hkdf.deriveSecrets(seed, "WhisperGroup".getBytes(StandardCharsets.UTF_8));
    }

    public static SenderMessageKeyBuilder builder() {
        return new SenderMessageKeyBuilder();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SenderMessageKeyBuilder {
        private int iteration;
        private byte[] seed;
        private byte[] iv;
        private byte[] cipherKey;

        SenderMessageKeyBuilder() {
        }

        public SenderMessageKeyBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public SenderMessageKeyBuilder seed(byte[] seed) {
            this.seed = seed;
            return this;
        }

        public SenderMessageKeyBuilder iv(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public SenderMessageKeyBuilder cipherKey(byte[] cipherKey) {
            this.cipherKey = cipherKey;
            return this;
        }

        public SenderMessageKey build() {
            return new SenderMessageKey(this.iteration, this.seed, this.iv, this.cipherKey);
        }

        public String toString() {
            return "SenderMessageKey.SenderMessageKeyBuilder(iteration=" + this.iteration + ", seed=" + Arrays.toString(this.seed) + ", iv=" + Arrays.toString(this.iv) + ", cipherKey=" + Arrays.toString(this.cipherKey) + ")";
        }
    }
}

