/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import java.util.Arrays;

@JsonDeserialize(builder=SenderChainKeyBuilder.class)
public record SenderChainKey(int iteration, byte[] seed) {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};

    public SenderMessageKey toMessageKey() {
        byte[] hmac = Hmac.calculateSha256(MESSAGE_KEY_SEED, this.seed);
        return new SenderMessageKey(this.iteration, hmac);
    }

    public SenderChainKey next() {
        byte[] hmac = Hmac.calculateSha256(CHAIN_KEY_SEED, this.seed);
        return new SenderChainKey(this.iteration + 1, hmac);
    }

    public static SenderChainKeyBuilder builder() {
        return new SenderChainKeyBuilder();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SenderChainKeyBuilder {
        private int iteration;
        private byte[] seed;

        SenderChainKeyBuilder() {
        }

        public SenderChainKeyBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public SenderChainKeyBuilder seed(byte[] seed) {
            this.seed = seed;
            return this;
        }

        public SenderChainKey build() {
            return new SenderChainKey(this.iteration, this.seed);
        }

        public String toString() {
            return "SenderChainKey.SenderChainKeyBuilder(iteration=" + this.iteration + ", seed=" + Arrays.toString(this.seed) + ")";
        }
    }
}

