/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.response;

import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.response.ResponseWrapper;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.NoSuchElementException;
import lombok.NonNull;

public record ContactStatusResponse(@NonNull String status, @NonNull ZonedDateTime timestamp) implements ResponseWrapper
{
    public ContactStatusResponse(@NonNull String status, @NonNull ZonedDateTime timestamp) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (timestamp == null) {
            throw new NullPointerException("timestamp is marked non-null but is null");
        }
    }

    public ContactStatusResponse(@NonNull Node source) {
        this(source.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing status")), Clock.parseSeconds(source.attributes().getLong("t")));
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
    }
}

