/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.request;

import io.netty.buffer.ByteBuf;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.whatsapp.binary.BinaryEncoder;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.socket.SocketSession;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Exceptions;
import it.auties.whatsapp.util.Protobuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;

public record Request(String id, @NonNull Object body, @NonNull CompletableFuture<Node> future, Function<Node, Boolean> filter, Throwable caller) {
    private static final int TIMEOUT = 60;
    private static final Executor EXECUTOR = CompletableFuture.delayedExecutor(60L, TimeUnit.SECONDS);

    public Request(String id, @NonNull Object body, @NonNull CompletableFuture<Node> future, Function<Node, Boolean> filter, Throwable caller) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (future == null) {
            throw new NullPointerException("future is marked non-null but is null");
        }
    }

    private Request(String id, Function<Node, Boolean> filter, @NonNull Object body) {
        this(id, body, new CompletableFuture<Node>(), filter, Request.trace(body));
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        EXECUTOR.execute(this::cancelTimedFuture);
    }

    private static Throwable trace(Object body) {
        String string;
        if (body instanceof Node) {
            Node node = (Node)body;
            string = "%s node timed out".formatted(node.toString());
        } else {
            string = "Binary timed out";
        }
        String message = string;
        Throwable current = Exceptions.current(message);
        StackTraceElement[] actualStackTrace = (StackTraceElement[])Arrays.stream(current.getStackTrace()).filter(entry -> !entry.getClassName().equals(Request.class.getName()) && !entry.getClassName().equals(Node.class.getName())).toArray(StackTraceElement[]::new);
        current.setStackTrace(actualStackTrace);
        return current;
    }

    private void cancelTimedFuture() {
        if (this.future.isDone()) {
            return;
        }
        this.future.completeExceptionally(this.caller);
    }

    public static Request of(@NonNull Node body, Function<Node, Boolean> filter) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return new Request(body.id(), filter, body);
    }

    public static Request of(@NonNull ProtobufMessage body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return new Request(null, null, Protobuf.writeMessage(body));
    }

    public CompletableFuture<Node> sendWithPrologue(@NonNull SocketSession session, @NonNull Keys keys, @NonNull Store store) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        return this.send(session, keys, store, true, false);
    }

    public CompletableFuture<Node> send(@NonNull SocketSession session, @NonNull Keys keys, @NonNull Store store, boolean prologue, boolean response) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        byte[] ciphered = this.encryptMessage(keys);
        ByteBuf buffer = BytesHelper.newBuffer();
        buffer.writeBytes(prologue ? keys.prologue() : new byte[]{});
        buffer.writeInt(ciphered.length >> 16);
        buffer.writeShort(0xFFFF & ciphered.length);
        buffer.writeBytes(ciphered);
        ((CompletableFuture)session.sendBinary(BytesHelper.readBuffer(buffer)).thenRunAsync(() -> this.onSendSuccess(store, response))).exceptionallyAsync(this::onSendError);
        return this.future;
    }

    private byte[] encryptMessage(Keys keys) {
        Object encodedBody = this.body();
        byte[] body = this.getBody(encodedBody);
        if (keys.writeKey() == null) {
            return body;
        }
        return AesGmc.encrypt(keys.writeCounter(true), body, keys.writeKey());
    }

    private byte[] getBody(Object encodedBody) {
        if (encodedBody instanceof byte[]) {
            byte[] bytes = (byte[])encodedBody;
            return bytes;
        }
        if (encodedBody instanceof Node) {
            Node node = (Node)encodedBody;
            BinaryEncoder encoder = new BinaryEncoder();
            return encoder.encode(node);
        }
        throw new IllegalArgumentException("Cannot create request, illegal body: %s".formatted(encodedBody));
    }

    private void onSendSuccess(Store store, boolean response) {
        if (!response) {
            this.future.complete(null);
            return;
        }
        store.addRequest(this);
    }

    private Void onSendError(Throwable throwable) {
        this.future.completeExceptionally(new IOException("Cannot send %s, an unknown exception occurred".formatted(this), throwable));
        return null;
    }

    public CompletableFuture<Node> send(@NonNull SocketSession session, @NonNull Keys keys, @NonNull Store store) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        return this.send(session, keys, store, false, true);
    }

    public CompletableFuture<Void> sendWithNoResponse(@NonNull SocketSession session, @NonNull Keys keys, @NonNull Store store) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        return this.send(session, keys, store, false, false).thenRunAsync(() -> {});
    }

    public boolean complete(Node response, boolean exceptionally) {
        if (response == null) {
            this.future.complete(Node.of("xmlstreamend"));
            return true;
        }
        if (exceptionally) {
            this.future.completeExceptionally(new RuntimeException("Cannot process request %s with %s".formatted(this, response), this.caller));
            return true;
        }
        if (this.filter != null && !this.filter.apply(response).booleanValue()) {
            return false;
        }
        this.future.complete(response);
        return true;
    }
}

