/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.mobile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.VerificationCodeError;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.model.mobile.VerificationCodeStatus;
import java.util.Arrays;
import java.util.Base64;

@JsonDeserialize(builder=VerificationCodeResponseBuilder.class)
public record VerificationCodeResponse(@JsonProperty(value="login") PhoneNumber number, @JsonProperty(value="lid") long lid, @JsonProperty(value="status") VerificationCodeStatus status, @JsonProperty(value="reason") VerificationCodeError errorReason, @JsonProperty(value="method") VerificationCodeMethod method, @JsonProperty(value="length") int codeLength, @JsonProperty(value="notify_after") int notifyAfter, @JsonProperty(value="retry_after") long retryAfter, @JsonProperty(value="voice_length") long voiceLength, @JsonProperty(value="voice_wait") long voiceWait, @JsonProperty(value="sms_wait") long smsWait, @JsonProperty(value="email_otp_wait") long whatsappOtpWait, @JsonProperty(value="flash_type") long flashType, @JsonProperty(value="wa_old_wait") long oldWait, @JsonProperty(value="security_code_set") boolean securityCodeSet, @JsonProperty(value="email_otp_eligible") boolean whatsappOtpEligible, @JsonProperty(value="image_blob") byte[] imageCaptcha, @JsonProperty(value="audio_blob") byte[] audioCaptcha) {
    public static VerificationCodeResponseBuilder builder() {
        return new VerificationCodeResponseBuilder();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class VerificationCodeResponseBuilder {
        private PhoneNumber number;
        private long lid;
        private VerificationCodeStatus status;
        private VerificationCodeError errorReason;
        private VerificationCodeMethod method;
        private int codeLength;
        private int notifyAfter;
        private long retryAfter;
        private long voiceLength;
        private long voiceWait;
        private long smsWait;
        private long whatsappOtpWait;
        private long flashType;
        private long oldWait;
        private boolean securityCodeSet;
        private boolean whatsappOtpEligible;
        private byte[] imageCaptcha;
        private byte[] audioCaptcha;

        @JsonSetter(value="email_otp_wait")
        private void whatsappOtpWait(String whatsappOtpWait) {
            try {
                this.whatsappOtpWait = Long.parseLong(whatsappOtpWait);
            }
            catch (NumberFormatException exception) {
                this.whatsappOtpWait = -1L;
            }
        }

        @JsonSetter(value="voice_wait")
        private void voiceWait(String voiceWait) {
            try {
                this.voiceWait = Long.parseLong(voiceWait);
            }
            catch (NumberFormatException exception) {
                this.voiceWait = -1L;
            }
        }

        @JsonSetter(value="sms_wait")
        private void smsWait(String smsWait) {
            try {
                this.smsWait = Long.parseLong(smsWait);
            }
            catch (NumberFormatException exception) {
                this.smsWait = -1L;
            }
        }

        @JsonSetter(value="image_blob")
        private void imageCaptcha(String imageCaptcha) {
            if (imageCaptcha == null) {
                return;
            }
            this.imageCaptcha = Base64.getDecoder().decode(imageCaptcha);
        }

        @JsonSetter(value="audio_blob")
        private void audioCaptcha(String audioCaptcha) {
            if (this.imageCaptcha == null) {
                return;
            }
            this.audioCaptcha = Base64.getDecoder().decode(audioCaptcha);
        }

        VerificationCodeResponseBuilder() {
        }

        @JsonProperty(value="login")
        public VerificationCodeResponseBuilder number(PhoneNumber number) {
            this.number = number;
            return this;
        }

        @JsonProperty(value="lid")
        public VerificationCodeResponseBuilder lid(long lid) {
            this.lid = lid;
            return this;
        }

        @JsonProperty(value="status")
        public VerificationCodeResponseBuilder status(VerificationCodeStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="reason")
        public VerificationCodeResponseBuilder errorReason(VerificationCodeError errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @JsonProperty(value="method")
        public VerificationCodeResponseBuilder method(VerificationCodeMethod method) {
            this.method = method;
            return this;
        }

        @JsonProperty(value="length")
        public VerificationCodeResponseBuilder codeLength(int codeLength) {
            this.codeLength = codeLength;
            return this;
        }

        @JsonProperty(value="notify_after")
        public VerificationCodeResponseBuilder notifyAfter(int notifyAfter) {
            this.notifyAfter = notifyAfter;
            return this;
        }

        @JsonProperty(value="retry_after")
        public VerificationCodeResponseBuilder retryAfter(long retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        @JsonProperty(value="voice_length")
        public VerificationCodeResponseBuilder voiceLength(long voiceLength) {
            this.voiceLength = voiceLength;
            return this;
        }

        @JsonProperty(value="flash_type")
        public VerificationCodeResponseBuilder flashType(long flashType) {
            this.flashType = flashType;
            return this;
        }

        @JsonProperty(value="wa_old_wait")
        public VerificationCodeResponseBuilder oldWait(long oldWait) {
            this.oldWait = oldWait;
            return this;
        }

        @JsonProperty(value="security_code_set")
        public VerificationCodeResponseBuilder securityCodeSet(boolean securityCodeSet) {
            this.securityCodeSet = securityCodeSet;
            return this;
        }

        @JsonProperty(value="email_otp_eligible")
        public VerificationCodeResponseBuilder whatsappOtpEligible(boolean whatsappOtpEligible) {
            this.whatsappOtpEligible = whatsappOtpEligible;
            return this;
        }

        public VerificationCodeResponse build() {
            return new VerificationCodeResponse(this.number, this.lid, this.status, this.errorReason, this.method, this.codeLength, this.notifyAfter, this.retryAfter, this.voiceLength, this.voiceWait, this.smsWait, this.whatsappOtpWait, this.flashType, this.oldWait, this.securityCodeSet, this.whatsappOtpEligible, this.imageCaptcha, this.audioCaptcha);
        }

        public String toString() {
            return "VerificationCodeResponse.VerificationCodeResponseBuilder(number=" + this.number + ", lid=" + this.lid + ", status=" + this.status + ", errorReason=" + this.errorReason + ", method=" + this.method + ", codeLength=" + this.codeLength + ", notifyAfter=" + this.notifyAfter + ", retryAfter=" + this.retryAfter + ", voiceLength=" + this.voiceLength + ", voiceWait=" + this.voiceWait + ", smsWait=" + this.smsWait + ", whatsappOtpWait=" + this.whatsappOtpWait + ", flashType=" + this.flashType + ", oldWait=" + this.oldWait + ", securityCodeSet=" + this.securityCodeSet + ", whatsappOtpEligible=" + this.whatsappOtpEligible + ", imageCaptcha=" + Arrays.toString(this.imageCaptcha) + ", audioCaptcha=" + Arrays.toString(this.audioCaptcha) + ")";
        }
    }
}

