/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitleType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitleType;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.interactive.InteractiveHeaderAttachment;
import it.auties.whatsapp.model.location.InteractiveLocationAnnotation;
import it.auties.whatsapp.model.media.MediaDimensions;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=VideoMessageBuilderImpl.class)
public final class VideoMessage
extends MediaMessage
implements InteractiveHeaderAttachment,
ButtonsMessageHeader,
HighlyStructuredFourRowTemplateTitle,
HydratedFourRowTemplateTitle {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=4, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=5, type=ProtobufType.UINT32)
    private Integer duration;
    @ProtobufProperty(index=6, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=7, type=ProtobufType.STRING)
    private String caption;
    @ProtobufProperty(index=8, type=ProtobufType.BOOL)
    private boolean gifPlayback;
    @ProtobufProperty(index=9, type=ProtobufType.UINT32)
    private Integer height;
    @ProtobufProperty(index=10, type=ProtobufType.UINT32)
    private Integer width;
    @ProtobufProperty(index=11, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=12, type=ProtobufType.MESSAGE, implementation=InteractiveLocationAnnotation.class, repeated=true)
    private List<InteractiveLocationAnnotation> interactiveAnnotations;
    @ProtobufProperty(index=13, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=14, type=ProtobufType.INT64)
    private long mediaKeyTimestamp;
    @ProtobufProperty(index=16, type=ProtobufType.BYTES)
    private byte[] thumbnail;
    @ProtobufProperty(index=18, type=ProtobufType.BYTES)
    private byte[] streamingSidecar;
    @ProtobufProperty(index=19, type=ProtobufType.MESSAGE, implementation=VideoMessageAttribution.class)
    private VideoMessageAttribution gifAttribution;
    @ProtobufProperty(index=20, name="viewOnce", type=ProtobufType.BOOL)
    private boolean viewOnce;
    @ProtobufProperty(index=21, name="thumbnailDirectPath", type=ProtobufType.STRING)
    private String thumbnailDirectPath;
    @ProtobufProperty(index=22, name="thumbnailSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailSha256;
    @ProtobufProperty(index=23, name="thumbnailEncSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailEncSha256;
    @ProtobufProperty(index=24, name="staticUrl", type=ProtobufType.STRING)
    private String staticUrl;

    private static VideoMessage videoBuilder(byte[] media, String mimeType, String caption, byte[] thumbnail, ContextInfo contextInfo) {
        MediaDimensions dimensions = Medias.getDimensions(media, true);
        int duration = Medias.getDuration(media);
        return ((VideoMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)VideoMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).mimetype(Objects.requireNonNullElse(mimeType, MediaMessageType.VIDEO.defaultMimeType()))).thumbnail(thumbnail != null ? thumbnail : (byte[])Medias.getThumbnail(media, Medias.Format.VIDEO).orElse(null))).caption(caption)).width(dimensions.width())).height(dimensions.height())).duration(duration)).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).build();
    }

    private static VideoMessage gifBuilder(byte[] media, String mimeType, String caption, VideoMessageAttribution gifAttribution, byte[] thumbnail, ContextInfo contextInfo) {
        Validate.isTrue(VideoMessage.isNotGif(media, mimeType), "Cannot create a VideoMessage with mime type image/gif: gif messages on whatsapp are videos played as gifs", new Object[0]);
        MediaDimensions dimensions = Medias.getDimensions(media, true);
        int duration = Medias.getDuration(media);
        return ((VideoMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)VideoMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).mimetype(Objects.requireNonNullElse(mimeType, MediaMessageType.VIDEO.defaultMimeType()))).thumbnail(thumbnail != null ? thumbnail : (byte[])Medias.getThumbnail(media, Medias.Format.VIDEO).orElse(null))).caption(caption)).width(dimensions.width())).height(dimensions.height())).duration(duration)).gifPlayback(true)).gifAttribution(Objects.requireNonNullElse(gifAttribution, VideoMessageAttribution.NONE))).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).build();
    }

    private static boolean isNotGif(byte[] media, String mimeType) {
        return Medias.getMimeType(media).filter("image/gif"::equals).isEmpty() && !Objects.equals(mimeType, "image/gif");
    }

    @Override
    public MediaMessageType mediaType() {
        return MediaMessageType.VIDEO;
    }

    @Override
    public HighlyStructuredFourRowTemplateTitleType titleType() {
        return HighlyStructuredFourRowTemplateTitleType.VIDEO;
    }

    @Override
    public HydratedFourRowTemplateTitleType hydratedTitleType() {
        return HydratedFourRowTemplateTitleType.VIDEO;
    }

    protected VideoMessage(VideoMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.mediaUrl = b.mediaUrl;
        this.mimetype = b.mimetype;
        this.mediaSha256 = b.mediaSha256;
        this.mediaSize = b.mediaSize;
        this.duration = b.duration;
        this.mediaKey = b.mediaKey;
        this.caption = b.caption;
        this.gifPlayback = b.gifPlayback;
        this.height = b.height;
        this.width = b.width;
        this.mediaEncryptedSha256 = b.mediaEncryptedSha256;
        this.interactiveAnnotations = b.interactiveAnnotations;
        this.mediaDirectPath = b.mediaDirectPath;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.thumbnail = b.thumbnail;
        this.streamingSidecar = b.streamingSidecar;
        this.gifAttribution = b.gifAttribution;
        this.viewOnce = b.viewOnce;
        this.thumbnailDirectPath = b.thumbnailDirectPath;
        this.thumbnailSha256 = b.thumbnailSha256;
        this.thumbnailEncSha256 = b.thumbnailEncSha256;
        this.staticUrl = b.staticUrl;
    }

    public static VideoMessageBuilder<?, ?> builder() {
        return new VideoMessageBuilderImpl();
    }

    public static SimpleVideoMessageBuilder simpleVideoBuilder() {
        return new SimpleVideoMessageBuilder();
    }

    public static SimpleGifBuilder simpleGifBuilder() {
        return new SimpleGifBuilder();
    }

    public VideoMessage(String mediaUrl, String mimetype, byte[] mediaSha256, long mediaSize, Integer duration, byte[] mediaKey, String caption, boolean gifPlayback, Integer height, Integer width, byte[] mediaEncryptedSha256, List<InteractiveLocationAnnotation> interactiveAnnotations, String mediaDirectPath, long mediaKeyTimestamp, byte[] thumbnail, byte[] streamingSidecar, VideoMessageAttribution gifAttribution, boolean viewOnce, String thumbnailDirectPath, byte[] thumbnailSha256, byte[] thumbnailEncSha256, String staticUrl) {
        this.mediaUrl = mediaUrl;
        this.mimetype = mimetype;
        this.mediaSha256 = mediaSha256;
        this.mediaSize = mediaSize;
        this.duration = duration;
        this.mediaKey = mediaKey;
        this.caption = caption;
        this.gifPlayback = gifPlayback;
        this.height = height;
        this.width = width;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.interactiveAnnotations = interactiveAnnotations;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.thumbnail = thumbnail;
        this.streamingSidecar = streamingSidecar;
        this.gifAttribution = gifAttribution;
        this.viewOnce = viewOnce;
        this.thumbnailDirectPath = thumbnailDirectPath;
        this.thumbnailSha256 = thumbnailSha256;
        this.thumbnailEncSha256 = thumbnailEncSha256;
        this.staticUrl = staticUrl;
    }

    public VideoMessage() {
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    public Integer duration() {
        return this.duration;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public String caption() {
        return this.caption;
    }

    public boolean gifPlayback() {
        return this.gifPlayback;
    }

    public Integer height() {
        return this.height;
    }

    public Integer width() {
        return this.width;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    public List<InteractiveLocationAnnotation> interactiveAnnotations() {
        return this.interactiveAnnotations;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public byte[] thumbnail() {
        return this.thumbnail;
    }

    public byte[] streamingSidecar() {
        return this.streamingSidecar;
    }

    public VideoMessageAttribution gifAttribution() {
        return this.gifAttribution;
    }

    public boolean viewOnce() {
        return this.viewOnce;
    }

    public String thumbnailDirectPath() {
        return this.thumbnailDirectPath;
    }

    public byte[] thumbnailSha256() {
        return this.thumbnailSha256;
    }

    public byte[] thumbnailEncSha256() {
        return this.thumbnailEncSha256;
    }

    public String staticUrl() {
        return this.staticUrl;
    }

    @Override
    public VideoMessage mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public VideoMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @Override
    public VideoMessage mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public VideoMessage mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public VideoMessage duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public VideoMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    public VideoMessage caption(String caption) {
        this.caption = caption;
        return this;
    }

    public VideoMessage gifPlayback(boolean gifPlayback) {
        this.gifPlayback = gifPlayback;
        return this;
    }

    public VideoMessage height(Integer height) {
        this.height = height;
        return this;
    }

    public VideoMessage width(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public VideoMessage mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    public VideoMessage interactiveAnnotations(List<InteractiveLocationAnnotation> interactiveAnnotations) {
        this.interactiveAnnotations = interactiveAnnotations;
        return this;
    }

    @Override
    public VideoMessage mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    public VideoMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public VideoMessage thumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public VideoMessage streamingSidecar(byte[] streamingSidecar) {
        this.streamingSidecar = streamingSidecar;
        return this;
    }

    public VideoMessage gifAttribution(VideoMessageAttribution gifAttribution) {
        this.gifAttribution = gifAttribution;
        return this;
    }

    public VideoMessage viewOnce(boolean viewOnce) {
        this.viewOnce = viewOnce;
        return this;
    }

    public VideoMessage thumbnailDirectPath(String thumbnailDirectPath) {
        this.thumbnailDirectPath = thumbnailDirectPath;
        return this;
    }

    public VideoMessage thumbnailSha256(byte[] thumbnailSha256) {
        this.thumbnailSha256 = thumbnailSha256;
        return this;
    }

    public VideoMessage thumbnailEncSha256(byte[] thumbnailEncSha256) {
        this.thumbnailEncSha256 = thumbnailEncSha256;
        return this;
    }

    public VideoMessage staticUrl(String staticUrl) {
        this.staticUrl = staticUrl;
        return this;
    }

    @Override
    public String toString() {
        return "VideoMessage(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl() + ", mimetype=" + this.mimetype() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaSize=" + this.mediaSize() + ", duration=" + this.duration() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", caption=" + this.caption() + ", gifPlayback=" + this.gifPlayback() + ", height=" + this.height() + ", width=" + this.width() + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", interactiveAnnotations=" + this.interactiveAnnotations() + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", thumbnail=" + Arrays.toString(this.thumbnail()) + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar()) + ", gifAttribution=" + this.gifAttribution() + ", viewOnce=" + this.viewOnce() + ", thumbnailDirectPath=" + this.thumbnailDirectPath() + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256()) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256()) + ", staticUrl=" + this.staticUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoMessage)) {
            return false;
        }
        VideoMessage other = (VideoMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (this.gifPlayback() != other.gifPlayback()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.viewOnce() != other.viewOnce()) {
            return false;
        }
        Integer this$duration = this.duration();
        Integer other$duration = other.duration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Integer this$height = this.height();
        Integer other$height = other.height();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        String this$caption = this.caption();
        String other$caption = other.caption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        List<InteractiveLocationAnnotation> this$interactiveAnnotations = this.interactiveAnnotations();
        List<InteractiveLocationAnnotation> other$interactiveAnnotations = other.interactiveAnnotations();
        if (this$interactiveAnnotations == null ? other$interactiveAnnotations != null : !((Object)this$interactiveAnnotations).equals(other$interactiveAnnotations)) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnail(), other.thumbnail())) {
            return false;
        }
        if (!Arrays.equals(this.streamingSidecar(), other.streamingSidecar())) {
            return false;
        }
        VideoMessageAttribution this$gifAttribution = this.gifAttribution();
        VideoMessageAttribution other$gifAttribution = other.gifAttribution();
        if (this$gifAttribution == null ? other$gifAttribution != null : !((Object)((Object)this$gifAttribution)).equals((Object)other$gifAttribution)) {
            return false;
        }
        String this$thumbnailDirectPath = this.thumbnailDirectPath();
        String other$thumbnailDirectPath = other.thumbnailDirectPath();
        if (this$thumbnailDirectPath == null ? other$thumbnailDirectPath != null : !this$thumbnailDirectPath.equals(other$thumbnailDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailSha256(), other.thumbnailSha256())) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailEncSha256(), other.thumbnailEncSha256())) {
            return false;
        }
        String this$staticUrl = this.staticUrl();
        String other$staticUrl = other.staticUrl();
        return !(this$staticUrl == null ? other$staticUrl != null : !this$staticUrl.equals(other$staticUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VideoMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        result = result * 59 + (this.gifPlayback() ? 79 : 97);
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + (this.viewOnce() ? 79 : 97);
        Integer $duration = this.duration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Integer $height = this.height();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        String $caption = this.caption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        List<InteractiveLocationAnnotation> $interactiveAnnotations = this.interactiveAnnotations();
        result = result * 59 + ($interactiveAnnotations == null ? 43 : ((Object)$interactiveAnnotations).hashCode());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnail());
        result = result * 59 + Arrays.hashCode(this.streamingSidecar());
        VideoMessageAttribution $gifAttribution = this.gifAttribution();
        result = result * 59 + ($gifAttribution == null ? 43 : ((Object)((Object)$gifAttribution)).hashCode());
        String $thumbnailDirectPath = this.thumbnailDirectPath();
        result = result * 59 + ($thumbnailDirectPath == null ? 43 : $thumbnailDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnailSha256());
        result = result * 59 + Arrays.hashCode(this.thumbnailEncSha256());
        String $staticUrl = this.staticUrl();
        result = result * 59 + ($staticUrl == null ? 43 : $staticUrl.hashCode());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.gifAttribution != null) {
            protobufOutputStream.writeUInt32(19, this.gifAttribution.index());
        }
        protobufOutputStream.writeInt64(14, this.mediaKeyTimestamp);
        if (this.staticUrl != null) {
            protobufOutputStream.writeString(24, this.staticUrl);
        }
        if (this.thumbnailDirectPath != null) {
            protobufOutputStream.writeString(21, this.thumbnailDirectPath);
        }
        if (this.thumbnailSha256 != null) {
            protobufOutputStream.writeBytes(22, this.thumbnailSha256);
        }
        if (this.duration != null) {
            protobufOutputStream.writeUInt32(5, this.duration);
        }
        protobufOutputStream.writeUInt64(4, this.mediaSize);
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(11, this.mediaEncryptedSha256);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.width != null) {
            protobufOutputStream.writeUInt32(10, this.width);
        }
        protobufOutputStream.writeBool(20, this.viewOnce);
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(13, this.mediaDirectPath);
        }
        protobufOutputStream.writeBool(8, this.gifPlayback);
        if (this.mimetype != null) {
            protobufOutputStream.writeString(2, this.mimetype);
        }
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(6, this.mediaKey);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(3, this.mediaSha256);
        }
        if (this.height != null) {
            protobufOutputStream.writeUInt32(9, this.height);
        }
        if (this.interactiveAnnotations != null) {
            for (InteractiveLocationAnnotation interactiveLocationAnnotation : this.interactiveAnnotations) {
                protobufOutputStream.writeBytes(12, interactiveLocationAnnotation.toEncodedProtobuf());
            }
        }
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.thumbnailEncSha256 != null) {
            protobufOutputStream.writeBytes(23, this.thumbnailEncSha256);
        }
        if (this.caption != null) {
            protobufOutputStream.writeString(7, this.caption);
        }
        if (this.thumbnail != null) {
            protobufOutputStream.writeBytes(16, this.thumbnail);
        }
        if (this.streamingSidecar != null) {
            protobufOutputStream.writeBytes(18, this.streamingSidecar);
        }
        return protobufOutputStream.toByteArray();
    }

    public static VideoMessage ofProtobuf(byte[] byArray) {
        int n;
        VideoMessageBuilder<?, ?> videoMessageBuilder = VideoMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<InteractiveLocationAnnotation> arrayList = new ArrayList<InteractiveLocationAnnotation>();
        block25: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 19: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.gifAttribution(VideoMessageAttribution.of(protobufInputStream.readInt32()));
                    continue block25;
                }
                case 14: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    continue block25;
                }
                case 24: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.staticUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 21: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.thumbnailDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 22: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.thumbnailSha256(protobufInputStream.readBytes());
                    continue block25;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.duration(protobufInputStream.readInt32());
                    continue block25;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block25;
                }
                case 11: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block25;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block25;
                }
                case 10: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.width(protobufInputStream.readInt32());
                    continue block25;
                }
                case 20: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.viewOnce(protobufInputStream.readBool());
                    continue block25;
                }
                case 13: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 8: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.gifPlayback(protobufInputStream.readBool());
                    continue block25;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block25;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block25;
                }
                case 9: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.height(protobufInputStream.readInt32());
                    continue block25;
                }
                case 12: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(InteractiveLocationAnnotation.ofProtobuf(protobufInputStream.readBytes()));
                    continue block25;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 23: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.thumbnailEncSha256(protobufInputStream.readBytes());
                    continue block25;
                }
                case 7: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.caption(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block25;
                }
                case 16: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.thumbnail(protobufInputStream.readBytes());
                    continue block25;
                }
                case 18: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    videoMessageBuilder.streamingSidecar(protobufInputStream.readBytes());
                    continue block25;
                }
            }
            protobufInputStream.readBytes();
        }
        videoMessageBuilder.interactiveAnnotations(arrayList);
        return videoMessageBuilder.build();
    }

    public static abstract class VideoMessageBuilder<C extends VideoMessage, B extends VideoMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private String mediaUrl;
        private String mimetype;
        private byte[] mediaSha256;
        private long mediaSize;
        private Integer duration;
        private byte[] mediaKey;
        private String caption;
        private boolean gifPlayback;
        private Integer height;
        private Integer width;
        private byte[] mediaEncryptedSha256;
        private List<InteractiveLocationAnnotation> interactiveAnnotations;
        private String mediaDirectPath;
        private long mediaKeyTimestamp;
        private byte[] thumbnail;
        private byte[] streamingSidecar;
        private VideoMessageAttribution gifAttribution;
        private boolean viewOnce;
        private String thumbnailDirectPath;
        private byte[] thumbnailSha256;
        private byte[] thumbnailEncSha256;
        private String staticUrl;

        public B mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return (B)this.self();
        }

        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        public B mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return (B)this.self();
        }

        public B mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return (B)this.self();
        }

        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        public B gifPlayback(boolean gifPlayback) {
            this.gifPlayback = gifPlayback;
            return (B)this.self();
        }

        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        public B mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return (B)this.self();
        }

        public B interactiveAnnotations(List<InteractiveLocationAnnotation> interactiveAnnotations) {
            this.interactiveAnnotations = interactiveAnnotations;
            return (B)this.self();
        }

        public B mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return (B)this.self();
        }

        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        public B thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B streamingSidecar(byte[] streamingSidecar) {
            this.streamingSidecar = streamingSidecar;
            return (B)this.self();
        }

        public B gifAttribution(VideoMessageAttribution gifAttribution) {
            this.gifAttribution = gifAttribution;
            return (B)this.self();
        }

        public B viewOnce(boolean viewOnce) {
            this.viewOnce = viewOnce;
            return (B)this.self();
        }

        public B thumbnailDirectPath(String thumbnailDirectPath) {
            this.thumbnailDirectPath = thumbnailDirectPath;
            return (B)this.self();
        }

        public B thumbnailSha256(byte[] thumbnailSha256) {
            this.thumbnailSha256 = thumbnailSha256;
            return (B)this.self();
        }

        public B thumbnailEncSha256(byte[] thumbnailEncSha256) {
            this.thumbnailEncSha256 = thumbnailEncSha256;
            return (B)this.self();
        }

        public B staticUrl(String staticUrl) {
            this.staticUrl = staticUrl;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VideoMessage.VideoMessageBuilder(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl + ", mimetype=" + this.mimetype + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaSize=" + this.mediaSize + ", duration=" + this.duration + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", caption=" + this.caption + ", gifPlayback=" + this.gifPlayback + ", height=" + this.height + ", width=" + this.width + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", interactiveAnnotations=" + this.interactiveAnnotations + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar) + ", gifAttribution=" + this.gifAttribution + ", viewOnce=" + this.viewOnce + ", thumbnailDirectPath=" + this.thumbnailDirectPath + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256) + ", staticUrl=" + this.staticUrl + ")";
        }
    }

    @ProtobufName(value="Attribution")
    public static enum VideoMessageAttribution implements ProtobufMessage
    {
        NONE(0),
        GIPHY(1),
        TENOR(2);

        private final int index;

        private VideoMessageAttribution(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        private static /* synthetic */ boolean lambda$of$0(int index, VideoMessageAttribution entry) {
            return entry.index() == index;
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static VideoMessageAttribution of(int n) {
            Iterator iterator = Arrays.stream(VideoMessageAttribution.values()).iterator();
            while (iterator.hasNext()) {
                VideoMessageAttribution videoMessageAttribution = (VideoMessageAttribution)((Object)iterator.next());
                if (videoMessageAttribution.index() != n) continue;
                return videoMessageAttribution;
            }
            return null;
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class VideoMessageBuilderImpl
    extends VideoMessageBuilder<VideoMessage, VideoMessageBuilderImpl> {
        private VideoMessageBuilderImpl() {
        }

        @Override
        protected VideoMessageBuilderImpl self() {
            return this;
        }

        @Override
        public VideoMessage build() {
            return new VideoMessage(this);
        }
    }

    public static class SimpleVideoMessageBuilder {
        private byte[] media;
        private String mimeType;
        private String caption;
        private byte[] thumbnail;
        private ContextInfo contextInfo;

        SimpleVideoMessageBuilder() {
        }

        public SimpleVideoMessageBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleVideoMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleVideoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SimpleVideoMessageBuilder thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SimpleVideoMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public VideoMessage build() {
            return VideoMessage.videoBuilder(this.media, this.mimeType, this.caption, this.thumbnail, this.contextInfo);
        }

        public String toString() {
            return "VideoMessage.SimpleVideoMessageBuilder(media=" + Arrays.toString(this.media) + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", contextInfo=" + this.contextInfo + ")";
        }
    }

    public static class SimpleGifBuilder {
        private byte[] media;
        private String mimeType;
        private String caption;
        private VideoMessageAttribution gifAttribution;
        private byte[] thumbnail;
        private ContextInfo contextInfo;

        SimpleGifBuilder() {
        }

        public SimpleGifBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleGifBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleGifBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SimpleGifBuilder gifAttribution(VideoMessageAttribution gifAttribution) {
            this.gifAttribution = gifAttribution;
            return this;
        }

        public SimpleGifBuilder thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SimpleGifBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public VideoMessage build() {
            return VideoMessage.gifBuilder(this.media, this.mimeType, this.caption, this.gifAttribution, this.thumbnail, this.contextInfo);
        }

        public String toString() {
            return "VideoMessage.SimpleGifBuilder(media=" + Arrays.toString(this.media) + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", gifAttribution=" + this.gifAttribution + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

