/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.message.model.MessageType;

public enum MediaMessageType {
    IMAGE("image/jpeg", MessageType.IMAGE, AttachmentType.IMAGE),
    DOCUMENT("application/octet-stream", MessageType.DOCUMENT, AttachmentType.DOCUMENT),
    AUDIO("audio/mpeg", MessageType.AUDIO, AttachmentType.AUDIO),
    VIDEO("video/mp4", MessageType.VIDEO, AttachmentType.VIDEO),
    STICKER("image/webp", MessageType.STICKER, AttachmentType.IMAGE);

    private final String defaultMimeType;
    private final MessageType messageType;
    private final AttachmentType attachmentType;

    public MessageType toMessageType() {
        return this.messageType;
    }

    public AttachmentType toAttachmentType() {
        return this.attachmentType;
    }

    private MediaMessageType(String defaultMimeType, MessageType messageType, AttachmentType attachmentType) {
        this.defaultMimeType = defaultMimeType;
        this.messageType = messageType;
        this.attachmentType = attachmentType;
    }

    public String defaultMimeType() {
        return this.defaultMimeType;
    }
}

