/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.contact.ContactStatus;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

@JsonDeserialize(builder=ContactBuilder.class)
public final class Contact
implements ProtobufMessage,
ContactJidProvider {
    @NonNull
    private final ContactJid jid;
    private String chosenName;
    private String fullName;
    private String shortName;
    private ContactStatus lastKnownPresence;
    private ZonedDateTime lastSeen;
    private boolean blocked;

    public static Contact ofJid(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Contact.builder().jid(jid).build();
    }

    public String name() {
        return this.shortName != null ? this.shortName : (this.fullName != null ? this.fullName : (this.chosenName != null ? this.chosenName : this.jid().user()));
    }

    public Optional<ZonedDateTime> lastSeen() {
        return Optional.ofNullable(this.lastSeen);
    }

    public int hashCode() {
        return Objects.hashCode(this.jid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Contact)) return false;
        Contact that = (Contact)other;
        if (!Objects.equals(this.jid(), that.jid())) return false;
        return true;
    }

    @Override
    @NonNull
    public ContactJid toJid() {
        return this.jid();
    }

    private static ContactStatus $default$lastKnownPresence() {
        return ContactStatus.UNAVAILABLE;
    }

    public static ContactBuilder builder() {
        return new ContactBuilder();
    }

    public Contact(@NonNull ContactJid jid, String chosenName, String fullName, String shortName, ContactStatus lastKnownPresence, ZonedDateTime lastSeen, boolean blocked) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        this.jid = jid;
        this.chosenName = chosenName;
        this.fullName = fullName;
        this.shortName = shortName;
        this.lastKnownPresence = lastKnownPresence;
        this.lastSeen = lastSeen;
        this.blocked = blocked;
    }

    @NonNull
    public ContactJid jid() {
        return this.jid;
    }

    public String chosenName() {
        return this.chosenName;
    }

    public String fullName() {
        return this.fullName;
    }

    public String shortName() {
        return this.shortName;
    }

    public ContactStatus lastKnownPresence() {
        return this.lastKnownPresence;
    }

    public boolean blocked() {
        return this.blocked;
    }

    public Contact chosenName(String chosenName) {
        this.chosenName = chosenName;
        return this;
    }

    public Contact fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public Contact shortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public Contact lastKnownPresence(ContactStatus lastKnownPresence) {
        this.lastKnownPresence = lastKnownPresence;
        return this;
    }

    public Contact lastSeen(ZonedDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public Contact blocked(boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    public String toString() {
        return "Contact(jid=" + this.jid() + ", chosenName=" + this.chosenName() + ", fullName=" + this.fullName() + ", shortName=" + this.shortName() + ", lastKnownPresence=" + this.lastKnownPresence() + ", lastSeen=" + this.lastSeen() + ", blocked=" + this.blocked() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        return protobufOutputStream.toByteArray();
    }

    public static Contact ofProtobuf(byte[] byArray) {
        int n;
        ContactBuilder contactBuilder = Contact.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                default: 
            }
            protobufInputStream.readBytes();
        }
        return contactBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ContactBuilder {
        private ContactJid jid;
        private String chosenName;
        private String fullName;
        private String shortName;
        private boolean lastKnownPresence$set;
        private ContactStatus lastKnownPresence$value;
        private ZonedDateTime lastSeen;
        private boolean blocked;

        ContactBuilder() {
        }

        public ContactBuilder jid(@NonNull ContactJid jid) {
            if (jid == null) {
                throw new NullPointerException("jid is marked non-null but is null");
            }
            this.jid = jid;
            return this;
        }

        public ContactBuilder chosenName(String chosenName) {
            this.chosenName = chosenName;
            return this;
        }

        public ContactBuilder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public ContactBuilder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public ContactBuilder lastKnownPresence(ContactStatus lastKnownPresence) {
            this.lastKnownPresence$value = lastKnownPresence;
            this.lastKnownPresence$set = true;
            return this;
        }

        public ContactBuilder lastSeen(ZonedDateTime lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public ContactBuilder blocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public Contact build() {
            ContactStatus lastKnownPresence$value = this.lastKnownPresence$value;
            if (!this.lastKnownPresence$set) {
                lastKnownPresence$value = Contact.$default$lastKnownPresence();
            }
            return new Contact(this.jid, this.chosenName, this.fullName, this.shortName, lastKnownPresence$value, this.lastSeen, this.blocked);
        }

        public String toString() {
            return "Contact.ContactBuilder(jid=" + this.jid + ", chosenName=" + this.chosenName + ", fullName=" + this.fullName + ", shortName=" + this.shortName + ", lastKnownPresence$value=" + this.lastKnownPresence$value + ", lastSeen=" + this.lastSeen + ", blocked=" + this.blocked + ")";
        }
    }
}

