/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.request.Node;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.NonNull;

@JsonDeserialize(builder=GroupParticipantBuilder.class)
public final class GroupParticipant
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING, name="userJid")
    private final ContactJid jid;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, name="rank")
    private GroupRole role;

    public GroupParticipant(ContactJid jid, GroupRole role) {
        this.jid = jid;
        this.role = Objects.requireNonNullElse(role, GroupRole.USER);
    }

    public static GroupParticipant of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ContactJid id = node.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing participant in group response"));
        GroupRole role = GroupRole.of(node.attributes().getString("type", null));
        return new GroupParticipant(id, role);
    }

    public static GroupParticipantBuilder builder() {
        return new GroupParticipantBuilder();
    }

    public ContactJid jid() {
        return this.jid;
    }

    public GroupRole role() {
        return this.role;
    }

    public GroupParticipant role(GroupRole role) {
        this.role = role;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupParticipant)) {
            return false;
        }
        GroupParticipant other = (GroupParticipant)o;
        ContactJid this$jid = this.jid();
        ContactJid other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !((Object)this$jid).equals(other$jid)) {
            return false;
        }
        GroupRole this$role = this.role();
        GroupRole other$role = other.role();
        return !(this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContactJid $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : ((Object)$jid).hashCode());
        GroupRole $role = this.role();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        return result;
    }

    public String toString() {
        return "GroupParticipant(jid=" + this.jid() + ", role=" + this.role() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.role != null) {
            protobufOutputStream.writeUInt32(2, this.role.index());
        }
        if (this.jid != null) {
            protobufOutputStream.writeString(1, this.jid.toValue());
        }
        return protobufOutputStream.toByteArray();
    }

    public static GroupParticipant ofProtobuf(byte[] byArray) {
        int n;
        GroupParticipantBuilder groupParticipantBuilder = GroupParticipant.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block4: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    groupParticipantBuilder.role(GroupRole.of(protobufInputStream.readInt32()));
                    continue block4;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    groupParticipantBuilder.jid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block4;
                }
            }
            protobufInputStream.readBytes();
        }
        return groupParticipantBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class GroupParticipantBuilder {
        private ContactJid jid;
        private GroupRole role;

        GroupParticipantBuilder() {
        }

        public GroupParticipantBuilder jid(ContactJid jid) {
            this.jid = jid;
            return this;
        }

        public GroupParticipantBuilder role(GroupRole role) {
            this.role = role;
            return this;
        }

        public GroupParticipant build() {
            return new GroupParticipant(this.jid, this.role);
        }

        public String toString() {
            return "GroupParticipant.GroupParticipantBuilder(jid=" + this.jid + ", role=" + this.role + ")";
        }
    }
}

