/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMediaVisibility;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.chat.PastParticipant;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;

@ProtobufName(value="Conversation")
@JsonDeserialize(builder=ChatBuilder.class)
public final class Chat
implements ProtobufMessage,
ContactJidProvider {
    @NonNull
    private final UUID uuid;
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    @NonNull
    private final ContactJid jid;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private final ContactJid newJid;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private final ContactJid oldJid;
    @ProtobufProperty(index=12, type=ProtobufType.UINT64)
    private long timestampSeconds;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=HistorySyncMessage.class, repeated=true)
    @NonNull
    private final ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    private int unreadMessagesCount;
    @ProtobufProperty(index=7, name="readOnly", type=ProtobufType.BOOL)
    private boolean readOnly;
    @ProtobufProperty(index=8, name="endOfHistoryTransfer", type=ProtobufType.BOOL)
    private boolean endOfHistoryTransfer;
    @ProtobufProperty(index=9, type=ProtobufType.UINT32)
    private ChatEphemeralTimer ephemeralMessageDuration;
    @ProtobufProperty(index=10, type=ProtobufType.INT64)
    private long ephemeralMessagesToggleTime;
    @ProtobufProperty(index=11, name="endOfHistoryTransferType", type=ProtobufType.MESSAGE)
    private EndOfHistoryTransferType endOfHistoryTransferType;
    @ProtobufProperty(index=13, type=ProtobufType.STRING)
    private String name;
    @ProtobufProperty(index=15, type=ProtobufType.BOOL)
    private boolean notSpam;
    @ProtobufProperty(index=16, type=ProtobufType.BOOL)
    private boolean archived;
    @ProtobufProperty(index=17, type=ProtobufType.MESSAGE, implementation=ChatDisappear.class)
    private ChatDisappear disappearInitiator;
    @ProtobufProperty(index=19, name="markedAsUnread", type=ProtobufType.BOOL)
    private boolean markedAsUnread;
    @ProtobufProperty(implementation=GroupParticipant.class, index=20, name="participant", repeated=true, type=ProtobufType.MESSAGE)
    private Map<ContactJid, GroupParticipant> participants;
    private Map<ContactJid, PastParticipant> pastParticipants;
    @ProtobufProperty(index=21, type=ProtobufType.BYTES)
    private byte[] token;
    @ProtobufProperty(index=22, type=ProtobufType.UINT64)
    private long tokenTimestampSeconds;
    @ProtobufProperty(index=23, type=ProtobufType.BYTES)
    private byte[] identityKey;
    @ProtobufProperty(index=24, type=ProtobufType.UINT32)
    private int pinnedTimestampSeconds;
    @ProtobufProperty(index=25, type=ProtobufType.UINT64)
    @NonNull
    private ChatMute mute;
    @ProtobufProperty(index=26, type=ProtobufType.MESSAGE, implementation=ChatWallpaper.class)
    private ChatWallpaper wallpaper;
    @ProtobufProperty(index=27, type=ProtobufType.MESSAGE, implementation=ChatMediaVisibility.class)
    @NonNull
    private ChatMediaVisibility mediaVisibility;
    @ProtobufProperty(index=28, type=ProtobufType.UINT64)
    private long tokenSenderTimestampSeconds;
    @ProtobufProperty(index=29, type=ProtobufType.BOOL)
    private boolean suspended;
    @ProtobufProperty(index=30, name="terminated", type=ProtobufType.BOOL)
    private boolean terminated;
    @ProtobufProperty(index=31, name="createdAt", type=ProtobufType.UINT64)
    private long foundationTimestampSeconds;
    @ProtobufProperty(index=32, name="createdBy", type=ProtobufType.STRING)
    private ContactJid founder;
    @ProtobufProperty(index=33, name="description", type=ProtobufType.STRING)
    private String description;
    @ProtobufProperty(index=34, name="support", type=ProtobufType.BOOL)
    private boolean support;
    @ProtobufProperty(index=35, name="isParentGroup", type=ProtobufType.BOOL)
    private boolean parentGroup;
    @ProtobufProperty(index=36, name="isDefaultSubgroup", type=ProtobufType.BOOL)
    private boolean defaultSubGroup;
    @ProtobufProperty(index=37, name="parentGroupId", type=ProtobufType.STRING)
    private ContactJid parentGroupJid;
    @ProtobufProperty(index=38, name="displayName", type=ProtobufType.STRING)
    private String displayName;
    @ProtobufProperty(index=39, name="pnJid", type=ProtobufType.STRING)
    private ContactJid pnJid;
    @ProtobufProperty(index=40, name="shareOwnPn", type=ProtobufType.BOOL)
    private boolean shareOwnPn;
    @ProtobufProperty(index=41, name="pnhDuplicateLidThread", type=ProtobufType.BOOL)
    private boolean pnhDuplicateLidThread;
    @ProtobufProperty(index=42, name="lidJid", type=ProtobufType.STRING)
    private ContactJid lidJid;
    @NonNull
    private ConcurrentHashMap<ContactJid, ContactStatus> presences;
    @NonNull
    private Set<ContactJid> participantsPreKeys;

    public static Chat ofJid(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Chat.builder().jid(jid).build();
    }

    public String name() {
        return Objects.requireNonNullElse(this.name, Objects.requireNonNullElse(this.displayName, this.jid.user()));
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean isGroup() {
        return this.jid.type() == ContactJid.Type.GROUP;
    }

    public boolean isPinned() {
        return this.pinnedTimestampSeconds != 0;
    }

    public boolean isEphemeral() {
        return this.ephemeralMessageDuration != ChatEphemeralTimer.OFF && this.ephemeralMessagesToggleTime != 0L;
    }

    public boolean hasNewJid() {
        return this.newJid != null;
    }

    public boolean hasOldJid() {
        return this.oldJid != null;
    }

    public Collection<MessageInfo> unreadMessages() {
        if (!this.hasUnreadMessages()) {
            return List.of();
        }
        Iterator<HistorySyncMessage> iterator = this.historySyncMessages.iterator();
        return this.historySyncMessages.stream().limit(this.unreadMessagesCount()).map(HistorySyncMessage::messageInfo).toList();
    }

    public boolean hasUnreadMessages() {
        return this.unreadMessagesCount > 0;
    }

    public Optional<ContactJid> newJid() {
        return Optional.ofNullable(this.newJid);
    }

    public Optional<ContactJid> oldJid() {
        return Optional.ofNullable(this.oldJid);
    }

    public Optional<ChatDisappear> disappearInitiator() {
        return Optional.ofNullable(this.disappearInitiator);
    }

    public Optional<ChatWallpaper> wallpaper() {
        return Optional.ofNullable(this.wallpaper);
    }

    public ZonedDateTime pinnedTimestamp() {
        return Clock.parseSeconds((long)this.pinnedTimestampSeconds);
    }

    public ZonedDateTime timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    public ZonedDateTime ephemeralMessagesToggleTime() {
        return Clock.parseSeconds(this.ephemeralMessagesToggleTime);
    }

    public Optional<MessageInfo> newestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekLast()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<MessageInfo> oldestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekFirst()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<MessageInfo> newestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, true);
    }

    public Optional<MessageInfo> oldestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, false);
    }

    private boolean isStandardMessage(MessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && !info.hasStub();
    }

    public Optional<MessageInfo> newestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, true);
    }

    public Optional<MessageInfo> oldestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, false);
    }

    private boolean isMessageFromMe(MessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && !info.hasStub() && info.fromMe();
    }

    public Optional<MessageInfo> newestServerMessage() {
        return this.findMessageBy(this::isServerMessage, true);
    }

    public Optional<MessageInfo> oldestServerMessage() {
        return this.findMessageBy(this::isServerMessage, false);
    }

    private boolean isServerMessage(MessageInfo info) {
        return info.message().hasCategory(MessageCategory.SERVER) || info.hasStub();
    }

    private Optional<MessageInfo> findMessageBy(Function<MessageInfo, Boolean> filter, boolean newest) {
        Iterator<HistorySyncMessage> descendingIterator;
        Iterator<HistorySyncMessage> iterator = descendingIterator = newest ? this.historySyncMessages.descendingIterator() : this.historySyncMessages.iterator();
        while (descendingIterator.hasNext()) {
            MessageInfo info = descendingIterator.next().messageInfo();
            if (!filter.apply(info).booleanValue()) continue;
            return Optional.ofNullable(info);
        }
        return Optional.empty();
    }

    public Collection<MessageInfo> starredMessages() {
        return this.historySyncMessages.stream().map(HistorySyncMessage::messageInfo).filter(MessageInfo::starred).toList();
    }

    public Optional<byte[]> token() {
        return Optional.ofNullable(this.token);
    }

    public ZonedDateTime tokenTimestamp() {
        return Clock.parseSeconds(this.tokenTimestampSeconds);
    }

    public Optional<byte[]> identityKey() {
        return Optional.ofNullable(this.identityKey);
    }

    public ZonedDateTime tokenSenderTimestamp() {
        return Clock.parseSeconds(this.tokenSenderTimestampSeconds);
    }

    public ZonedDateTime foundationTimestamp() {
        return Clock.parseSeconds(this.foundationTimestampSeconds);
    }

    public Optional<ContactJid> founder() {
        return Optional.ofNullable(this.founder);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<ContactJid> pnJid() {
        return Optional.ofNullable(this.pnJid);
    }

    public Optional<ContactJid> lidJid() {
        return Optional.ofNullable(this.lidJid);
    }

    public void addMessages(@NonNull Collection<HistorySyncMessage> newMessages) {
        if (newMessages == null) {
            throw new NullPointerException("newMessages is marked non-null but is null");
        }
        this.historySyncMessages.addAll(newMessages);
    }

    public void addOldMessages(@NonNull Collection<HistorySyncMessage> oldMessages) {
        if (oldMessages == null) {
            throw new NullPointerException("oldMessages is marked non-null but is null");
        }
        oldMessages.forEach(this.historySyncMessages::addFirst);
    }

    public boolean addNewMessage(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        HistorySyncMessage sync = new HistorySyncMessage(info, this.historySyncMessages.size());
        if (this.historySyncMessages.contains(sync)) {
            return false;
        }
        this.historySyncMessages.add(sync);
        this.updateChatTimestamp(info);
        return true;
    }

    public boolean addOldMessage(@NonNull HistorySyncMessage info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.historySyncMessages.addFirst(info);
        return true;
    }

    public boolean removeMessage(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        boolean result = this.historySyncMessages.removeIf(entry -> Objects.equals(entry.messageInfo().id(), info.id()));
        this.refreshChatTimestamp();
        return result;
    }

    public boolean removeMessage(@NonNull Predicate<? super MessageInfo> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        boolean result = this.historySyncMessages.removeIf(entry -> predicate.test(entry.messageInfo()));
        this.refreshChatTimestamp();
        return result;
    }

    private void refreshChatTimestamp() {
        Optional<MessageInfo> message = this.newestMessage();
        if (message.isEmpty()) {
            return;
        }
        this.updateChatTimestamp(message.get());
    }

    private void updateChatTimestamp(MessageInfo info) {
        Long oldTimeStamp = this.newestMessage().map(MessageInfo::timestampSeconds).orElse(0L);
        if (oldTimeStamp > info.timestampSeconds()) {
            return;
        }
        this.timestampSeconds(info.timestampSeconds());
    }

    public void removeMessages() {
        this.historySyncMessages.clear();
    }

    public Collection<HistorySyncMessage> messages() {
        return Collections.unmodifiableCollection(this.historySyncMessages);
    }

    public Collection<GroupParticipant> participants() {
        return this.participants.values();
    }

    public void addParticipants(Collection<GroupParticipant> participants) {
        participants.forEach(this::addParticipant);
    }

    public Optional<GroupParticipant> addParticipant(@NonNull ContactJid jid, GroupRole role) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Optional.ofNullable(this.participants.put(jid, new GroupParticipant(jid, role)));
    }

    public Optional<GroupParticipant> addParticipant(@NonNull GroupParticipant participant) {
        if (participant == null) {
            throw new NullPointerException("participant is marked non-null but is null");
        }
        return Optional.ofNullable(this.participants.put(participant.jid(), participant));
    }

    public Optional<GroupParticipant> removeParticipant(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Optional.ofNullable(this.participants.remove(jid));
    }

    public Optional<GroupParticipant> findParticipant(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Optional.ofNullable(this.participants.get(jid));
    }

    public Collection<PastParticipant> pastParticipants() {
        return this.pastParticipants.values();
    }

    public Optional<PastParticipant> addPastParticipant(@NonNull PastParticipant participant) {
        if (participant == null) {
            throw new NullPointerException("participant is marked non-null but is null");
        }
        return Optional.ofNullable(this.pastParticipants.put(participant.jid(), participant));
    }

    public void addPastParticipants(List<PastParticipant> pastParticipants) {
        for (PastParticipant pastParticipant : pastParticipants) {
            this.pastParticipants.put(pastParticipant.jid(), pastParticipant);
        }
    }

    public Optional<PastParticipant> removePastParticipant(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Optional.ofNullable(this.pastParticipants.remove(jid));
    }

    public Optional<PastParticipant> findPastParticipant(@NonNull ContactJid jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Optional.ofNullable(this.pastParticipants.get(jid));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Chat)) return false;
        Chat that = (Chat)other;
        if (!Objects.equals(this.jid(), that.jid())) return false;
        return true;
    }

    @Override
    @NonNull
    public ContactJid toJid() {
        return this.jid();
    }

    public int hashCode() {
        return Objects.hash(this.jid());
    }

    public int fullHashCode() {
        int result = Objects.hash(new Object[]{this.jid, this.newJid, this.oldJid, this.timestampSeconds, this.historySyncMessages, this.unreadMessagesCount, this.readOnly, this.endOfHistoryTransfer, this.ephemeralMessageDuration, this.ephemeralMessagesToggleTime, this.endOfHistoryTransferType, this.name, this.notSpam, this.archived, this.disappearInitiator, this.markedAsUnread, this.participants, this.pastParticipants, this.tokenTimestampSeconds, this.pinnedTimestampSeconds, this.mute, this.wallpaper, this.mediaVisibility, this.tokenSenderTimestampSeconds, this.suspended, this.terminated, this.foundationTimestampSeconds, this.founder, this.description, this.support, this.parentGroup, this.defaultSubGroup, this.parentGroupJid, this.displayName, this.pnJid, this.shareOwnPn, this.pnhDuplicateLidThread, this.lidJid, this.presences, this.participantsPreKeys});
        result = 31 * result + Arrays.hashCode(this.token);
        result = 31 * result + Arrays.hashCode(this.identityKey);
        result = 31 * result + this.historySyncMessages.size();
        return result;
    }

    public String toString() {
        return "Chat{uuid=" + this.uuid + ", jid=" + this.jid + ", newJid=" + this.newJid + ", oldJid=" + this.oldJid + ", timestampSeconds=" + this.timestampSeconds + ", messages=" + this.historySyncMessages + ", unreadMessagesCount=" + this.unreadMessagesCount + ", readOnly=" + this.readOnly + ", endOfHistoryTransfer=" + this.endOfHistoryTransfer + ", ephemeralMessageDuration=" + this.ephemeralMessageDuration + ", ephemeralMessagesToggleTime=" + this.ephemeralMessagesToggleTime + ", endOfHistoryTransferType=" + this.endOfHistoryTransferType + ", name='" + this.name + "', notSpam=" + this.notSpam + ", archived=" + this.archived + ", disappearInitiator=" + this.disappearInitiator + ", markedAsUnread=" + this.markedAsUnread + ", participants=" + this.participants + ", pastParticipants=" + this.pastParticipants + ", token=" + Arrays.toString(this.token) + ", tokenTimestamp=" + this.tokenTimestampSeconds + ", identityKey=" + Arrays.toString(this.identityKey) + ", pinnedTimestampSeconds=" + this.pinnedTimestampSeconds + ", mute=" + this.mute + ", wallpaper=" + this.wallpaper + ", mediaVisibility=" + this.mediaVisibility + ", tokenSenderTimestamp=" + this.tokenSenderTimestampSeconds + ", suspended=" + this.suspended + ", terminated=" + this.terminated + ", createdAt=" + this.foundationTimestampSeconds + ", createdBy=" + this.founder + ", description='" + this.description + "', support=" + this.support + ", parentGroup=" + this.parentGroup + ", defaultSubGroup=" + this.defaultSubGroup + ", parentGroupJid=" + this.parentGroupJid + ", displayName='" + this.displayName + "', pnJid=" + this.pnJid + ", shareOwnPn=" + this.shareOwnPn + ", pnhDuplicateLidThread=" + this.pnhDuplicateLidThread + ", lidJid=" + this.lidJid + ", presences=" + this.presences + ", participantsPreKeys=" + this.participantsPreKeys + "}";
    }

    private static UUID $default$uuid() {
        return UUID.randomUUID();
    }

    private static ConcurrentLinkedDeque<HistorySyncMessage> $default$historySyncMessages() {
        return new ConcurrentLinkedDeque<HistorySyncMessage>();
    }

    private static ChatEphemeralTimer $default$ephemeralMessageDuration() {
        return ChatEphemeralTimer.OFF;
    }

    private static EndOfHistoryTransferType $default$endOfHistoryTransferType() {
        return EndOfHistoryTransferType.COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY;
    }

    private static Map<ContactJid, GroupParticipant> $default$participants() {
        return new ConcurrentHashMap<ContactJid, GroupParticipant>();
    }

    private static Map<ContactJid, PastParticipant> $default$pastParticipants() {
        return new ConcurrentHashMap<ContactJid, PastParticipant>();
    }

    private static ChatMute $default$mute() {
        return ChatMute.notMuted();
    }

    private static ChatMediaVisibility $default$mediaVisibility() {
        return ChatMediaVisibility.OFF;
    }

    private static ConcurrentHashMap<ContactJid, ContactStatus> $default$presences() {
        return new ConcurrentHashMap<ContactJid, ContactStatus>();
    }

    private static Set<ContactJid> $default$participantsPreKeys() {
        return new HashSet<ContactJid>();
    }

    public static ChatBuilder builder() {
        return new ChatBuilder();
    }

    private Chat(@NonNull UUID uuid, @NonNull ContactJid jid, ContactJid newJid, ContactJid oldJid, long timestampSeconds, @NonNull ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages, int unreadMessagesCount, boolean readOnly, boolean endOfHistoryTransfer, ChatEphemeralTimer ephemeralMessageDuration, long ephemeralMessagesToggleTime, EndOfHistoryTransferType endOfHistoryTransferType, String name, boolean notSpam, boolean archived, ChatDisappear disappearInitiator, boolean markedAsUnread, Map<ContactJid, GroupParticipant> participants, Map<ContactJid, PastParticipant> pastParticipants, byte[] token, long tokenTimestampSeconds, byte[] identityKey, int pinnedTimestampSeconds, @NonNull ChatMute mute, ChatWallpaper wallpaper, @NonNull ChatMediaVisibility mediaVisibility, long tokenSenderTimestampSeconds, boolean suspended, boolean terminated, long foundationTimestampSeconds, ContactJid founder, String description, boolean support, boolean parentGroup, boolean defaultSubGroup, ContactJid parentGroupJid, String displayName, ContactJid pnJid, boolean shareOwnPn, boolean pnhDuplicateLidThread, ContactJid lidJid, @NonNull ConcurrentHashMap<ContactJid, ContactStatus> presences, @NonNull Set<ContactJid> participantsPreKeys) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (historySyncMessages == null) {
            throw new NullPointerException("historySyncMessages is marked non-null but is null");
        }
        if (mute == null) {
            throw new NullPointerException("mute is marked non-null but is null");
        }
        if (mediaVisibility == null) {
            throw new NullPointerException("mediaVisibility is marked non-null but is null");
        }
        if (presences == null) {
            throw new NullPointerException("presences is marked non-null but is null");
        }
        if (participantsPreKeys == null) {
            throw new NullPointerException("participantsPreKeys is marked non-null but is null");
        }
        this.uuid = uuid;
        this.jid = jid;
        this.newJid = newJid;
        this.oldJid = oldJid;
        this.timestampSeconds = timestampSeconds;
        this.historySyncMessages = historySyncMessages;
        this.unreadMessagesCount = unreadMessagesCount;
        this.readOnly = readOnly;
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        this.name = name;
        this.notSpam = notSpam;
        this.archived = archived;
        this.disappearInitiator = disappearInitiator;
        this.markedAsUnread = markedAsUnread;
        this.participants = participants;
        this.pastParticipants = pastParticipants;
        this.token = token;
        this.tokenTimestampSeconds = tokenTimestampSeconds;
        this.identityKey = identityKey;
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        this.mute = mute;
        this.wallpaper = wallpaper;
        this.mediaVisibility = mediaVisibility;
        this.tokenSenderTimestampSeconds = tokenSenderTimestampSeconds;
        this.suspended = suspended;
        this.terminated = terminated;
        this.foundationTimestampSeconds = foundationTimestampSeconds;
        this.founder = founder;
        this.description = description;
        this.support = support;
        this.parentGroup = parentGroup;
        this.defaultSubGroup = defaultSubGroup;
        this.parentGroupJid = parentGroupJid;
        this.displayName = displayName;
        this.pnJid = pnJid;
        this.shareOwnPn = shareOwnPn;
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        this.lidJid = lidJid;
        this.presences = presences;
        this.participantsPreKeys = participantsPreKeys;
    }

    @NonNull
    public UUID uuid() {
        return this.uuid;
    }

    @NonNull
    public ContactJid jid() {
        return this.jid;
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    @NonNull
    public ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages() {
        return this.historySyncMessages;
    }

    public int unreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public boolean endOfHistoryTransfer() {
        return this.endOfHistoryTransfer;
    }

    public ChatEphemeralTimer ephemeralMessageDuration() {
        return this.ephemeralMessageDuration;
    }

    public EndOfHistoryTransferType endOfHistoryTransferType() {
        return this.endOfHistoryTransferType;
    }

    public boolean notSpam() {
        return this.notSpam;
    }

    public boolean archived() {
        return this.archived;
    }

    public boolean markedAsUnread() {
        return this.markedAsUnread;
    }

    public long tokenTimestampSeconds() {
        return this.tokenTimestampSeconds;
    }

    public int pinnedTimestampSeconds() {
        return this.pinnedTimestampSeconds;
    }

    @NonNull
    public ChatMute mute() {
        return this.mute;
    }

    @NonNull
    public ChatMediaVisibility mediaVisibility() {
        return this.mediaVisibility;
    }

    public long tokenSenderTimestampSeconds() {
        return this.tokenSenderTimestampSeconds;
    }

    public boolean suspended() {
        return this.suspended;
    }

    public boolean terminated() {
        return this.terminated;
    }

    public long foundationTimestampSeconds() {
        return this.foundationTimestampSeconds;
    }

    public boolean support() {
        return this.support;
    }

    public boolean parentGroup() {
        return this.parentGroup;
    }

    public boolean defaultSubGroup() {
        return this.defaultSubGroup;
    }

    public ContactJid parentGroupJid() {
        return this.parentGroupJid;
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean shareOwnPn() {
        return this.shareOwnPn;
    }

    public boolean pnhDuplicateLidThread() {
        return this.pnhDuplicateLidThread;
    }

    @NonNull
    public ConcurrentHashMap<ContactJid, ContactStatus> presences() {
        return this.presences;
    }

    @NonNull
    public Set<ContactJid> participantsPreKeys() {
        return this.participantsPreKeys;
    }

    public Chat timestampSeconds(long timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
        return this;
    }

    public Chat unreadMessagesCount(int unreadMessagesCount) {
        this.unreadMessagesCount = unreadMessagesCount;
        return this;
    }

    public Chat readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Chat endOfHistoryTransfer(boolean endOfHistoryTransfer) {
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        return this;
    }

    public Chat ephemeralMessageDuration(ChatEphemeralTimer ephemeralMessageDuration) {
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        return this;
    }

    public Chat ephemeralMessagesToggleTime(long ephemeralMessagesToggleTime) {
        this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
        return this;
    }

    public Chat endOfHistoryTransferType(EndOfHistoryTransferType endOfHistoryTransferType) {
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        return this;
    }

    public Chat name(String name) {
        this.name = name;
        return this;
    }

    public Chat notSpam(boolean notSpam) {
        this.notSpam = notSpam;
        return this;
    }

    public Chat archived(boolean archived) {
        this.archived = archived;
        return this;
    }

    public Chat disappearInitiator(ChatDisappear disappearInitiator) {
        this.disappearInitiator = disappearInitiator;
        return this;
    }

    public Chat markedAsUnread(boolean markedAsUnread) {
        this.markedAsUnread = markedAsUnread;
        return this;
    }

    public Chat participants(Map<ContactJid, GroupParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public Chat pastParticipants(Map<ContactJid, PastParticipant> pastParticipants) {
        this.pastParticipants = pastParticipants;
        return this;
    }

    public Chat token(byte[] token) {
        this.token = token;
        return this;
    }

    public Chat tokenTimestampSeconds(long tokenTimestampSeconds) {
        this.tokenTimestampSeconds = tokenTimestampSeconds;
        return this;
    }

    public Chat identityKey(byte[] identityKey) {
        this.identityKey = identityKey;
        return this;
    }

    public Chat pinnedTimestampSeconds(int pinnedTimestampSeconds) {
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        return this;
    }

    public Chat mute(@NonNull ChatMute mute) {
        if (mute == null) {
            throw new NullPointerException("mute is marked non-null but is null");
        }
        this.mute = mute;
        return this;
    }

    public Chat wallpaper(ChatWallpaper wallpaper) {
        this.wallpaper = wallpaper;
        return this;
    }

    public Chat mediaVisibility(@NonNull ChatMediaVisibility mediaVisibility) {
        if (mediaVisibility == null) {
            throw new NullPointerException("mediaVisibility is marked non-null but is null");
        }
        this.mediaVisibility = mediaVisibility;
        return this;
    }

    public Chat tokenSenderTimestampSeconds(long tokenSenderTimestampSeconds) {
        this.tokenSenderTimestampSeconds = tokenSenderTimestampSeconds;
        return this;
    }

    public Chat suspended(boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    public Chat terminated(boolean terminated) {
        this.terminated = terminated;
        return this;
    }

    public Chat foundationTimestampSeconds(long foundationTimestampSeconds) {
        this.foundationTimestampSeconds = foundationTimestampSeconds;
        return this;
    }

    public Chat founder(ContactJid founder) {
        this.founder = founder;
        return this;
    }

    public Chat description(String description) {
        this.description = description;
        return this;
    }

    public Chat support(boolean support) {
        this.support = support;
        return this;
    }

    public Chat parentGroup(boolean parentGroup) {
        this.parentGroup = parentGroup;
        return this;
    }

    public Chat defaultSubGroup(boolean defaultSubGroup) {
        this.defaultSubGroup = defaultSubGroup;
        return this;
    }

    public Chat parentGroupJid(ContactJid parentGroupJid) {
        this.parentGroupJid = parentGroupJid;
        return this;
    }

    public Chat displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Chat pnJid(ContactJid pnJid) {
        this.pnJid = pnJid;
        return this;
    }

    public Chat shareOwnPn(boolean shareOwnPn) {
        this.shareOwnPn = shareOwnPn;
        return this;
    }

    public Chat pnhDuplicateLidThread(boolean pnhDuplicateLidThread) {
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        return this;
    }

    public Chat lidJid(ContactJid lidJid) {
        this.lidJid = lidJid;
        return this;
    }

    public Chat presences(@NonNull ConcurrentHashMap<ContactJid, ContactStatus> presences) {
        if (presences == null) {
            throw new NullPointerException("presences is marked non-null but is null");
        }
        this.presences = presences;
        return this;
    }

    public Chat participantsPreKeys(@NonNull Set<ContactJid> participantsPreKeys) {
        if (participantsPreKeys == null) {
            throw new NullPointerException("participantsPreKeys is marked non-null but is null");
        }
        this.participantsPreKeys = participantsPreKeys;
        return this;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeInt64(10, this.ephemeralMessagesToggleTime);
        if (this.mediaVisibility != null) {
            protobufOutputStream.writeUInt32(27, this.mediaVisibility.index());
        }
        protobufOutputStream.writeUInt64(31, this.foundationTimestampSeconds);
        if (this.participants != null) {
            for (GroupParticipant groupParticipant : this.participants()) {
                protobufOutputStream.writeBytes(20, groupParticipant.toEncodedProtobuf());
            }
        }
        protobufOutputStream.writeBool(40, this.shareOwnPn);
        protobufOutputStream.writeBool(15, this.notSpam);
        if (this.historySyncMessages != null) {
            for (HistorySyncMessage historySyncMessage : this.historySyncMessages) {
                protobufOutputStream.writeBytes(2, historySyncMessage.toEncodedProtobuf());
            }
        }
        if (this.displayName != null) {
            protobufOutputStream.writeString(38, this.displayName);
        }
        protobufOutputStream.writeUInt32(6, this.unreadMessagesCount);
        if (this.wallpaper != null) {
            protobufOutputStream.writeBytes(26, this.wallpaper.toEncodedProtobuf());
        }
        protobufOutputStream.writeBool(41, this.pnhDuplicateLidThread);
        if (this.ephemeralMessageDuration != null) {
            protobufOutputStream.writeUInt32(9, this.ephemeralMessageDuration.periodSeconds());
        }
        if (this.identityKey != null) {
            protobufOutputStream.writeBytes(23, this.identityKey);
        }
        protobufOutputStream.writeBool(30, this.terminated);
        protobufOutputStream.writeBool(8, this.endOfHistoryTransfer);
        protobufOutputStream.writeBool(35, this.parentGroup);
        if (this.founder != null) {
            protobufOutputStream.writeString(32, this.founder.toValue());
        }
        if (this.jid != null) {
            protobufOutputStream.writeString(1, this.jid.toValue());
        }
        protobufOutputStream.writeUInt64(12, this.timestampSeconds);
        protobufOutputStream.writeBool(36, this.defaultSubGroup);
        protobufOutputStream.writeBool(29, this.suspended);
        if (this.endOfHistoryTransferType != null) {
            protobufOutputStream.writeUInt32(11, this.endOfHistoryTransferType.index());
        }
        if (this.mute != null) {
            protobufOutputStream.writeUInt64(25, this.mute.endTimeStamp());
        }
        if (this.newJid != null) {
            protobufOutputStream.writeString(3, this.newJid.toValue());
        }
        protobufOutputStream.writeUInt64(28, this.tokenSenderTimestampSeconds);
        protobufOutputStream.writeUInt32(24, this.pinnedTimestampSeconds);
        if (this.parentGroupJid != null) {
            protobufOutputStream.writeString(37, this.parentGroupJid.toValue());
        }
        if (this.disappearInitiator != null) {
            protobufOutputStream.writeBytes(17, this.disappearInitiator.toEncodedProtobuf());
        }
        if (this.token != null) {
            protobufOutputStream.writeBytes(21, this.token);
        }
        if (this.pnJid != null) {
            protobufOutputStream.writeString(39, this.pnJid.toValue());
        }
        protobufOutputStream.writeBool(7, this.readOnly);
        if (this.description != null) {
            protobufOutputStream.writeString(33, this.description);
        }
        protobufOutputStream.writeBool(34, this.support);
        if (this.oldJid != null) {
            protobufOutputStream.writeString(4, this.oldJid.toValue());
        }
        if (this.name != null) {
            protobufOutputStream.writeString(13, this.name);
        }
        protobufOutputStream.writeBool(16, this.archived);
        protobufOutputStream.writeUInt64(22, this.tokenTimestampSeconds);
        protobufOutputStream.writeBool(19, this.markedAsUnread);
        if (this.lidJid != null) {
            protobufOutputStream.writeString(42, this.lidJid.toValue());
        }
        return protobufOutputStream.toByteArray();
    }

    public static Chat ofProtobuf(byte[] byArray) {
        int n;
        ChatBuilder chatBuilder = Chat.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<GroupParticipant> arrayList = new ArrayList<GroupParticipant>();
        ConcurrentLinkedDeque<HistorySyncMessage> concurrentLinkedDeque = new ConcurrentLinkedDeque<HistorySyncMessage>();
        block41: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 10: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.ephemeralMessagesToggleTime(protobufInputStream.readInt64());
                    continue block41;
                }
                case 27: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.mediaVisibility(ChatMediaVisibility.of(protobufInputStream.readInt32()));
                    continue block41;
                }
                case 31: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.foundationTimestampSeconds(protobufInputStream.readInt64());
                    continue block41;
                }
                case 20: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(GroupParticipant.ofProtobuf(protobufInputStream.readBytes()));
                    continue block41;
                }
                case 40: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.shareOwnPn(protobufInputStream.readBool());
                    continue block41;
                }
                case 15: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.notSpam(protobufInputStream.readBool());
                    continue block41;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    concurrentLinkedDeque.add(HistorySyncMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block41;
                }
                case 38: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.displayName(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block41;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.unreadMessagesCount(protobufInputStream.readInt32());
                    continue block41;
                }
                case 26: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.wallpaper(ChatWallpaper.ofProtobuf(protobufInputStream.readBytes()));
                    continue block41;
                }
                case 41: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.pnhDuplicateLidThread(protobufInputStream.readBool());
                    continue block41;
                }
                case 9: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.ephemeralMessageDuration(ChatEphemeralTimer.ofProtobuf(protobufInputStream.readInt32()));
                    continue block41;
                }
                case 23: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.identityKey(protobufInputStream.readBytes());
                    continue block41;
                }
                case 30: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.terminated(protobufInputStream.readBool());
                    continue block41;
                }
                case 8: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.endOfHistoryTransfer(protobufInputStream.readBool());
                    continue block41;
                }
                case 35: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.parentGroup(protobufInputStream.readBool());
                    continue block41;
                }
                case 32: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.founder(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.jid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 12: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.timestampSeconds(protobufInputStream.readInt64());
                    continue block41;
                }
                case 36: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.defaultSubGroup(protobufInputStream.readBool());
                    continue block41;
                }
                case 29: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.suspended(protobufInputStream.readBool());
                    continue block41;
                }
                case 11: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.endOfHistoryTransferType(EndOfHistoryTransferType.of(protobufInputStream.readInt32()));
                    continue block41;
                }
                case 25: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.mute(ChatMute.ofProtobuf(protobufInputStream.readInt64()));
                    continue block41;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.newJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 28: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.tokenSenderTimestampSeconds(protobufInputStream.readInt64());
                    continue block41;
                }
                case 24: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.pinnedTimestampSeconds(protobufInputStream.readInt32());
                    continue block41;
                }
                case 37: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.parentGroupJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.disappearInitiator(ChatDisappear.ofProtobuf(protobufInputStream.readBytes()));
                    continue block41;
                }
                case 21: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.token(protobufInputStream.readBytes());
                    continue block41;
                }
                case 39: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.pnJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 7: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.readOnly(protobufInputStream.readBool());
                    continue block41;
                }
                case 33: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.description(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block41;
                }
                case 34: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.support(protobufInputStream.readBool());
                    continue block41;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.oldJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
                case 13: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.name(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block41;
                }
                case 16: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.archived(protobufInputStream.readBool());
                    continue block41;
                }
                case 22: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.tokenTimestampSeconds(protobufInputStream.readInt64());
                    continue block41;
                }
                case 19: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.markedAsUnread(protobufInputStream.readBool());
                    continue block41;
                }
                case 42: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    chatBuilder.lidJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block41;
                }
            }
            protobufInputStream.readBytes();
        }
        chatBuilder.participants(arrayList);
        chatBuilder.historySyncMessages(concurrentLinkedDeque);
        return chatBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ChatBuilder {
        private boolean uuid$set;
        private UUID uuid$value;
        private ContactJid jid;
        private ContactJid newJid;
        private ContactJid oldJid;
        private long timestampSeconds;
        private boolean historySyncMessages$set;
        private ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages$value;
        private int unreadMessagesCount;
        private boolean readOnly;
        private boolean endOfHistoryTransfer;
        private boolean ephemeralMessageDuration$set;
        private ChatEphemeralTimer ephemeralMessageDuration$value;
        private long ephemeralMessagesToggleTime;
        private boolean endOfHistoryTransferType$set;
        private EndOfHistoryTransferType endOfHistoryTransferType$value;
        private String name;
        private boolean notSpam;
        private boolean archived;
        private ChatDisappear disappearInitiator;
        private boolean markedAsUnread;
        private boolean participants$set;
        private Map<ContactJid, GroupParticipant> participants$value;
        private boolean pastParticipants$set;
        private Map<ContactJid, PastParticipant> pastParticipants$value;
        private byte[] token;
        private long tokenTimestampSeconds;
        private byte[] identityKey;
        private int pinnedTimestampSeconds;
        private boolean mute$set;
        private ChatMute mute$value;
        private ChatWallpaper wallpaper;
        private boolean mediaVisibility$set;
        private ChatMediaVisibility mediaVisibility$value;
        private long tokenSenderTimestampSeconds;
        private boolean suspended;
        private boolean terminated;
        private long foundationTimestampSeconds;
        private ContactJid founder;
        private String description;
        private boolean support;
        private boolean parentGroup;
        private boolean defaultSubGroup;
        private ContactJid parentGroupJid;
        private String displayName;
        private ContactJid pnJid;
        private boolean shareOwnPn;
        private boolean pnhDuplicateLidThread;
        private ContactJid lidJid;
        private boolean presences$set;
        private ConcurrentHashMap<ContactJid, ContactStatus> presences$value;
        private boolean participantsPreKeys$set;
        private Set<ContactJid> participantsPreKeys$value;

        public ChatBuilder participants(Collection<GroupParticipant> participants) {
            this.participants$set = true;
            this.participants$value = participants.stream().collect(Collectors.toConcurrentMap(GroupParticipant::jid, Function.identity()));
            return this;
        }

        @JsonSetter(value="participants")
        public ChatBuilder participants(Map<ContactJid, GroupParticipant> participants) {
            this.participants$set = true;
            this.participants$value = participants;
            return this;
        }

        ChatBuilder() {
        }

        public ChatBuilder uuid(@NonNull UUID uuid) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            this.uuid$value = uuid;
            this.uuid$set = true;
            return this;
        }

        public ChatBuilder jid(@NonNull ContactJid jid) {
            if (jid == null) {
                throw new NullPointerException("jid is marked non-null but is null");
            }
            this.jid = jid;
            return this;
        }

        public ChatBuilder newJid(ContactJid newJid) {
            this.newJid = newJid;
            return this;
        }

        public ChatBuilder oldJid(ContactJid oldJid) {
            this.oldJid = oldJid;
            return this;
        }

        public ChatBuilder timestampSeconds(long timestampSeconds) {
            this.timestampSeconds = timestampSeconds;
            return this;
        }

        public ChatBuilder historySyncMessages(@NonNull ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages) {
            if (historySyncMessages == null) {
                throw new NullPointerException("historySyncMessages is marked non-null but is null");
            }
            this.historySyncMessages$value = historySyncMessages;
            this.historySyncMessages$set = true;
            return this;
        }

        public ChatBuilder unreadMessagesCount(int unreadMessagesCount) {
            this.unreadMessagesCount = unreadMessagesCount;
            return this;
        }

        public ChatBuilder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public ChatBuilder endOfHistoryTransfer(boolean endOfHistoryTransfer) {
            this.endOfHistoryTransfer = endOfHistoryTransfer;
            return this;
        }

        public ChatBuilder ephemeralMessageDuration(ChatEphemeralTimer ephemeralMessageDuration) {
            this.ephemeralMessageDuration$value = ephemeralMessageDuration;
            this.ephemeralMessageDuration$set = true;
            return this;
        }

        public ChatBuilder ephemeralMessagesToggleTime(long ephemeralMessagesToggleTime) {
            this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
            return this;
        }

        public ChatBuilder endOfHistoryTransferType(EndOfHistoryTransferType endOfHistoryTransferType) {
            this.endOfHistoryTransferType$value = endOfHistoryTransferType;
            this.endOfHistoryTransferType$set = true;
            return this;
        }

        public ChatBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatBuilder notSpam(boolean notSpam) {
            this.notSpam = notSpam;
            return this;
        }

        public ChatBuilder archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        public ChatBuilder disappearInitiator(ChatDisappear disappearInitiator) {
            this.disappearInitiator = disappearInitiator;
            return this;
        }

        public ChatBuilder markedAsUnread(boolean markedAsUnread) {
            this.markedAsUnread = markedAsUnread;
            return this;
        }

        public ChatBuilder pastParticipants(Map<ContactJid, PastParticipant> pastParticipants) {
            this.pastParticipants$value = pastParticipants;
            this.pastParticipants$set = true;
            return this;
        }

        public ChatBuilder token(byte[] token) {
            this.token = token;
            return this;
        }

        public ChatBuilder tokenTimestampSeconds(long tokenTimestampSeconds) {
            this.tokenTimestampSeconds = tokenTimestampSeconds;
            return this;
        }

        public ChatBuilder identityKey(byte[] identityKey) {
            this.identityKey = identityKey;
            return this;
        }

        public ChatBuilder pinnedTimestampSeconds(int pinnedTimestampSeconds) {
            this.pinnedTimestampSeconds = pinnedTimestampSeconds;
            return this;
        }

        public ChatBuilder mute(@NonNull ChatMute mute) {
            if (mute == null) {
                throw new NullPointerException("mute is marked non-null but is null");
            }
            this.mute$value = mute;
            this.mute$set = true;
            return this;
        }

        public ChatBuilder wallpaper(ChatWallpaper wallpaper) {
            this.wallpaper = wallpaper;
            return this;
        }

        public ChatBuilder mediaVisibility(@NonNull ChatMediaVisibility mediaVisibility) {
            if (mediaVisibility == null) {
                throw new NullPointerException("mediaVisibility is marked non-null but is null");
            }
            this.mediaVisibility$value = mediaVisibility;
            this.mediaVisibility$set = true;
            return this;
        }

        public ChatBuilder tokenSenderTimestampSeconds(long tokenSenderTimestampSeconds) {
            this.tokenSenderTimestampSeconds = tokenSenderTimestampSeconds;
            return this;
        }

        public ChatBuilder suspended(boolean suspended) {
            this.suspended = suspended;
            return this;
        }

        public ChatBuilder terminated(boolean terminated) {
            this.terminated = terminated;
            return this;
        }

        public ChatBuilder foundationTimestampSeconds(long foundationTimestampSeconds) {
            this.foundationTimestampSeconds = foundationTimestampSeconds;
            return this;
        }

        public ChatBuilder founder(ContactJid founder) {
            this.founder = founder;
            return this;
        }

        public ChatBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ChatBuilder support(boolean support) {
            this.support = support;
            return this;
        }

        public ChatBuilder parentGroup(boolean parentGroup) {
            this.parentGroup = parentGroup;
            return this;
        }

        public ChatBuilder defaultSubGroup(boolean defaultSubGroup) {
            this.defaultSubGroup = defaultSubGroup;
            return this;
        }

        public ChatBuilder parentGroupJid(ContactJid parentGroupJid) {
            this.parentGroupJid = parentGroupJid;
            return this;
        }

        public ChatBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ChatBuilder pnJid(ContactJid pnJid) {
            this.pnJid = pnJid;
            return this;
        }

        public ChatBuilder shareOwnPn(boolean shareOwnPn) {
            this.shareOwnPn = shareOwnPn;
            return this;
        }

        public ChatBuilder pnhDuplicateLidThread(boolean pnhDuplicateLidThread) {
            this.pnhDuplicateLidThread = pnhDuplicateLidThread;
            return this;
        }

        public ChatBuilder lidJid(ContactJid lidJid) {
            this.lidJid = lidJid;
            return this;
        }

        public ChatBuilder presences(@NonNull ConcurrentHashMap<ContactJid, ContactStatus> presences) {
            if (presences == null) {
                throw new NullPointerException("presences is marked non-null but is null");
            }
            this.presences$value = presences;
            this.presences$set = true;
            return this;
        }

        public ChatBuilder participantsPreKeys(@NonNull Set<ContactJid> participantsPreKeys) {
            if (participantsPreKeys == null) {
                throw new NullPointerException("participantsPreKeys is marked non-null but is null");
            }
            this.participantsPreKeys$value = participantsPreKeys;
            this.participantsPreKeys$set = true;
            return this;
        }

        public Chat build() {
            UUID uuid$value = this.uuid$value;
            if (!this.uuid$set) {
                uuid$value = Chat.$default$uuid();
            }
            ConcurrentLinkedDeque<HistorySyncMessage> historySyncMessages$value = this.historySyncMessages$value;
            if (!this.historySyncMessages$set) {
                historySyncMessages$value = Chat.$default$historySyncMessages();
            }
            ChatEphemeralTimer ephemeralMessageDuration$value = this.ephemeralMessageDuration$value;
            if (!this.ephemeralMessageDuration$set) {
                ephemeralMessageDuration$value = Chat.$default$ephemeralMessageDuration();
            }
            EndOfHistoryTransferType endOfHistoryTransferType$value = this.endOfHistoryTransferType$value;
            if (!this.endOfHistoryTransferType$set) {
                endOfHistoryTransferType$value = Chat.$default$endOfHistoryTransferType();
            }
            Map<ContactJid, GroupParticipant> participants$value = this.participants$value;
            if (!this.participants$set) {
                participants$value = Chat.$default$participants();
            }
            Map<ContactJid, PastParticipant> pastParticipants$value = this.pastParticipants$value;
            if (!this.pastParticipants$set) {
                pastParticipants$value = Chat.$default$pastParticipants();
            }
            ChatMute mute$value = this.mute$value;
            if (!this.mute$set) {
                mute$value = Chat.$default$mute();
            }
            ChatMediaVisibility mediaVisibility$value = this.mediaVisibility$value;
            if (!this.mediaVisibility$set) {
                mediaVisibility$value = Chat.$default$mediaVisibility();
            }
            ConcurrentHashMap<ContactJid, ContactStatus> presences$value = this.presences$value;
            if (!this.presences$set) {
                presences$value = Chat.$default$presences();
            }
            Set<ContactJid> participantsPreKeys$value = this.participantsPreKeys$value;
            if (!this.participantsPreKeys$set) {
                participantsPreKeys$value = Chat.$default$participantsPreKeys();
            }
            return new Chat(uuid$value, this.jid, this.newJid, this.oldJid, this.timestampSeconds, historySyncMessages$value, this.unreadMessagesCount, this.readOnly, this.endOfHistoryTransfer, ephemeralMessageDuration$value, this.ephemeralMessagesToggleTime, endOfHistoryTransferType$value, this.name, this.notSpam, this.archived, this.disappearInitiator, this.markedAsUnread, participants$value, pastParticipants$value, this.token, this.tokenTimestampSeconds, this.identityKey, this.pinnedTimestampSeconds, mute$value, this.wallpaper, mediaVisibility$value, this.tokenSenderTimestampSeconds, this.suspended, this.terminated, this.foundationTimestampSeconds, this.founder, this.description, this.support, this.parentGroup, this.defaultSubGroup, this.parentGroupJid, this.displayName, this.pnJid, this.shareOwnPn, this.pnhDuplicateLidThread, this.lidJid, presences$value, participantsPreKeys$value);
        }

        public String toString() {
            return "Chat.ChatBuilder(uuid$value=" + this.uuid$value + ", jid=" + this.jid + ", newJid=" + this.newJid + ", oldJid=" + this.oldJid + ", timestampSeconds=" + this.timestampSeconds + ", historySyncMessages$value=" + this.historySyncMessages$value + ", unreadMessagesCount=" + this.unreadMessagesCount + ", readOnly=" + this.readOnly + ", endOfHistoryTransfer=" + this.endOfHistoryTransfer + ", ephemeralMessageDuration$value=" + this.ephemeralMessageDuration$value + ", ephemeralMessagesToggleTime=" + this.ephemeralMessagesToggleTime + ", endOfHistoryTransferType$value=" + this.endOfHistoryTransferType$value + ", name=" + this.name + ", notSpam=" + this.notSpam + ", archived=" + this.archived + ", disappearInitiator=" + this.disappearInitiator + ", markedAsUnread=" + this.markedAsUnread + ", participants$value=" + this.participants$value + ", pastParticipants$value=" + this.pastParticipants$value + ", token=" + Arrays.toString(this.token) + ", tokenTimestampSeconds=" + this.tokenTimestampSeconds + ", identityKey=" + Arrays.toString(this.identityKey) + ", pinnedTimestampSeconds=" + this.pinnedTimestampSeconds + ", mute$value=" + this.mute$value + ", wallpaper=" + this.wallpaper + ", mediaVisibility$value=" + this.mediaVisibility$value + ", tokenSenderTimestampSeconds=" + this.tokenSenderTimestampSeconds + ", suspended=" + this.suspended + ", terminated=" + this.terminated + ", foundationTimestampSeconds=" + this.foundationTimestampSeconds + ", founder=" + this.founder + ", description=" + this.description + ", support=" + this.support + ", parentGroup=" + this.parentGroup + ", defaultSubGroup=" + this.defaultSubGroup + ", parentGroupJid=" + this.parentGroupJid + ", displayName=" + this.displayName + ", pnJid=" + this.pnJid + ", shareOwnPn=" + this.shareOwnPn + ", pnhDuplicateLidThread=" + this.pnhDuplicateLidThread + ", lidJid=" + this.lidJid + ", presences$value=" + this.presences$value + ", participantsPreKeys$value=" + this.participantsPreKeys$value + ")";
        }
    }

    public static enum EndOfHistoryTransferType implements ProtobufMessage
    {
        COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY(0),
        COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY(1);

        private final int index;

        private EndOfHistoryTransferType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public static EndOfHistoryTransferType of(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static EndOfHistoryTransferType of(int n) {
            Iterator iterator = Arrays.stream(EndOfHistoryTransferType.values()).iterator();
            while (iterator.hasNext()) {
                EndOfHistoryTransferType endOfHistoryTransferType = (EndOfHistoryTransferType)((Object)iterator.next());
                if (endOfHistoryTransferType.index() != n) continue;
                return endOfHistoryTransferType;
            }
            return null;
        }
    }
}

