/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.request.Node;
import java.net.URI;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import lombok.NonNull;

public record BusinessCatalogEntry(@NonNull String id, @NonNull URI encryptedImage, @NonNull ReviewStatus reviewStatus, @NonNull Availability availability, @NonNull String name, @NonNull String sellerId, @NonNull URI uri, @NonNull String description, long price, @NonNull String currency, boolean hidden) {
    public BusinessCatalogEntry(@NonNull String id, @NonNull URI encryptedImage, @NonNull ReviewStatus reviewStatus, @NonNull Availability availability, @NonNull String name, @NonNull String sellerId, @NonNull URI uri, @NonNull String description, long price, @NonNull String currency, boolean hidden) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (encryptedImage == null) {
            throw new NullPointerException("encryptedImage is marked non-null but is null");
        }
        if (reviewStatus == null) {
            throw new NullPointerException("reviewStatus is marked non-null but is null");
        }
        if (availability == null) {
            throw new NullPointerException("availability is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sellerId == null) {
            throw new NullPointerException("sellerId is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
    }

    public static BusinessCatalogEntry of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String id = node.attributes().getRequiredString("id");
        boolean hidden = node.attributes().getBoolean("is_hidden");
        String name = (String)node.findNode("name").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing name for catalog entry"));
        URI encryptedImage = node.findNode("media").flatMap(entry -> entry.findNode("original_image_url")).flatMap(Node::contentAsString).map(URI::create).orElseThrow(() -> new NoSuchElementException("Missing image for catalog entry"));
        ReviewStatus statusInfo = node.findNode("status_info").flatMap(entry -> entry.findNode("status")).flatMap(Node::contentAsString).map(ReviewStatus::of).orElse(ReviewStatus.NO_REVIEW);
        Availability availability = node.findNode("availability").flatMap(Node::contentAsString).map(Availability::of).orElse(Availability.UNKNOWN);
        String sellerId = (String)node.findNode("retailer_id").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing seller id for catalog entry"));
        URI uri = node.findNode("url").flatMap(Node::contentAsString).map(URI::create).orElseThrow(() -> new NoSuchElementException("Missing uri for catalog entry"));
        String description = node.findNode("description").flatMap(Node::contentAsString).orElse("");
        Long price = node.findNode("price").flatMap(Node::contentAsString).map(Long::parseUnsignedLong).orElseThrow(() -> new NoSuchElementException("Missing price for catalog entry"));
        String currency = (String)node.findNode("currency").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing currency for catalog entry"));
        return new BusinessCatalogEntry(id, encryptedImage, statusInfo, availability, name, sellerId, uri, description, price, currency, hidden);
    }

    public static enum ReviewStatus {
        NO_REVIEW,
        PENDING,
        REJECTED,
        APPROVED,
        OUTDATED;


        public static ReviewStatus of(String name) {
            return ReviewStatus.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }

    public static enum Availability {
        UNKNOWN,
        IN_STOCK,
        OUT_OF_STOCK;


        public static Availability of(String name) {
            return Arrays.stream(Availability.values()).filter(entry -> entry.name().toLowerCase(Locale.ROOT).replaceAll("_", " ").equals(name)).findFirst().orElse(UNKNOWN);
        }
    }
}

