/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.api.WebHistoryLength;
import it.auties.whatsapp.controller.Controller;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.DefaultControllerSerializer;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.listener.Listener;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.message.standard.PollUpdateMessage;
import it.auties.whatsapp.model.message.standard.ReactionMessage;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.request.ReplyHandler;
import it.auties.whatsapp.model.request.Request;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.MetadataHelper;
import it.auties.whatsapp.util.Protobuf;
import it.auties.whatsapp.util.ProxyAuthenticator;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

@JsonDeserialize(builder=StoreBuilderImpl.class)
public final class Store
extends Controller<Store> {
    private URI proxy;
    private Version version;
    private boolean online;
    private String locale;
    private String name;
    private boolean business;
    private String businessAddress;
    private Double businessLongitude;
    private Double businessLatitude;
    private String businessDescription;
    private String businessWebsite;
    private String businessEmail;
    private BusinessCategory businessCategory;
    private String deviceHash;
    private LinkedHashMap<ContactJid, Integer> linkedDevicesKeys;
    private URI profilePicture;
    private String about;
    private ContactJid jid;
    private ContactJid lid;
    @NonNull
    private ConcurrentHashMap<String, String> properties;
    @JsonIgnore
    @NonNull
    private ConcurrentHashMap<ContactJid, Chat> chats;
    @NonNull
    private ConcurrentHashMap<ContactJid, Contact> contacts;
    @NonNull
    private ConcurrentHashMap<ContactJid, ConcurrentLinkedDeque<MessageInfo>> status;
    @NonNull
    private ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> privacySettings;
    private boolean unarchiveChats;
    private boolean twentyFourHourFormat;
    @JsonIgnore
    @NonNull
    private ConcurrentHashMap<String, Request> requests;
    @JsonIgnore
    @NonNull
    private ConcurrentHashMap.KeySetView<ReplyHandler, Boolean> replyHandlers;
    @JsonIgnore
    @NonNull
    private final ConcurrentHashMap.KeySetView<Listener, Boolean> listeners;
    @JsonIgnore
    @NonNull
    private String tag;
    private long initializationTimeStamp;
    @JsonIgnore
    private MediaConnection mediaConnection;
    @JsonIgnore
    private CountDownLatch mediaConnectionLatch;
    @NonNull
    private ChatEphemeralTimer newChatsEphemeralTimer;
    private TextPreviewSetting textPreviewSetting;
    @NonNull
    private WebHistoryLength historyLength;
    private boolean autodetectListeners;
    private boolean automaticPresenceUpdates;
    @NonNull
    private UserAgent.UserAgentReleaseChannel releaseChannel;
    @NonNull
    private CompanionDevice device;
    private UserAgent.UserAgentPlatform companionDeviceOs;
    private boolean checkPatchMacs;

    public static Store of(UUID uuid, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.of(uuid, clientType, DefaultControllerSerializer.instance());
    }

    public static Store of(UUID uuid, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Store.ofNullable(uuid, clientType, serializer).orElseGet(() -> Store.random(uuid, null, clientType, serializer, new String[0]));
    }

    public static Optional<Store> ofNullable(UUID uuid, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.ofNullable(uuid, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Store> ofNullable(UUID uuid, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (uuid == null) {
            return Optional.empty();
        }
        Optional<Store> store = serializer.deserializeStore(clientType, uuid);
        store.ifPresent(serializer::attributeStore);
        return store;
    }

    public static Store of(UUID uuid, long phoneNumber, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.of(uuid, phoneNumber, clientType, DefaultControllerSerializer.instance());
    }

    public static Store of(UUID uuid, long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Store.ofNullable(phoneNumber, clientType, serializer).orElseGet(() -> Store.random(uuid, (Long)phoneNumber, clientType, serializer, new String[0]));
    }

    public static Optional<Store> ofNullable(Long phoneNumber, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.ofNullable(phoneNumber, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Store> ofNullable(Long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (phoneNumber == null) {
            return Optional.empty();
        }
        Optional<Store> store = serializer.deserializeStore(clientType, phoneNumber);
        store.ifPresent(serializer::attributeStore);
        return store;
    }

    public static Store of(UUID uuid, String alias, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.of(uuid, alias, clientType, DefaultControllerSerializer.instance());
    }

    public static Store of(UUID uuid, String alias, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        return Store.ofNullable(alias, clientType, serializer).orElseGet(() -> Store.random(uuid, null, clientType, serializer, alias));
    }

    public static Optional<Store> ofNullable(String alias, @NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.ofNullable(alias, clientType, DefaultControllerSerializer.instance());
    }

    public static Optional<Store> ofNullable(String alias, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (alias == null) {
            return Optional.empty();
        }
        Optional<Store> store = serializer.deserializeStore(clientType, alias);
        store.ifPresent(serializer::attributeStore);
        return store;
    }

    public static Store random(UUID uuid, Long phoneNumber, @NonNull ClientType clientType, String ... alias) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        return Store.random(uuid, phoneNumber, clientType, DefaultControllerSerializer.instance(), alias);
    }

    public static Store random(UUID uuid, Long phoneNumber, @NonNull ClientType clientType, @NonNull ControllerSerializer serializer, String ... alias) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        PhoneNumber phone = PhoneNumber.ofNullable(phoneNumber).orElse(null);
        Controller result = ((StoreBuilder)((Controller.ControllerBuilder)((StoreBuilder)((Controller.ControllerBuilder)((StoreBuilder)((StoreBuilder)((StoreBuilder)Store.builder().alias(Objects.requireNonNullElseGet(Arrays.asList(alias), ArrayList::new))).serializer(serializer)).clientType(clientType)).jid(phone == null ? null : phone.toJid())).phoneNumber(phone)).device(Store.getDefaultDevice(clientType))).uuid(Objects.requireNonNullElseGet(uuid, UUID::randomUUID))).build();
        serializer.linkMetadata(result);
        return result;
    }

    private static CompanionDevice getDefaultDevice(ClientType clientType) {
        return switch (clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> CompanionDevice.windows();
            case ClientType.MOBILE -> CompanionDevice.android();
        };
    }

    public Optional<Contact> findContactByJid(ContactJidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Contact) {
            Contact contact = (Contact)jid;
            return Optional.of(contact);
        }
        return Optional.ofNullable(this.contacts.get(jid.toJid()));
    }

    public Optional<Contact> findContactByName(String name) {
        return this.findContactsStream(name).findAny();
    }

    private Stream<Contact> findContactsStream(String name) {
        return name == null ? Stream.empty() : this.contacts().parallelStream().filter(contact -> Objects.equals(contact.fullName(), name) || Objects.equals(contact.shortName(), name) || Objects.equals(contact.chosenName(), name));
    }

    public Collection<Contact> contacts() {
        return Collections.unmodifiableCollection(this.contacts.values());
    }

    public Set<Contact> findContactsByName(String name) {
        return this.findContactsStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<MessageInfo> findMessageByKey(MessageKey key) {
        return key == null ? Optional.empty() : this.findMessageById(key.chatJid(), key.id());
    }

    public Optional<MessageInfo> findMessageById(ContactJidProvider provider, String id) {
        if (provider == null || id == null) {
            return Optional.empty();
        }
        Chat chat = this.findChatByJid(provider.toJid()).orElse(null);
        if (chat == null) {
            return Optional.empty();
        }
        return chat.messages().parallelStream().map(HistorySyncMessage::messageInfo).filter(message -> Objects.equals(message.key().id(), id)).findAny();
    }

    public Optional<Chat> findChatByJid(ContactJidProvider jid) {
        if (jid == null) {
            return Optional.empty();
        }
        if (jid instanceof Chat) {
            Chat chat = (Chat)jid;
            return Optional.of(chat);
        }
        return Optional.ofNullable(this.chats.get(jid.toJid()));
    }

    public Optional<Chat> findChatByName(String name) {
        return this.findChatsStream(name).findAny();
    }

    private Stream<Chat> findChatsStream(String name) {
        return name == null ? Stream.empty() : this.chats.values().parallelStream().filter(chat -> chat.name().equalsIgnoreCase(name));
    }

    public Optional<Chat> findChatBy(@NonNull Function<Chat, Boolean> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.chats.values().parallelStream().filter(function::apply).findFirst();
    }

    public Set<Chat> findChatsByName(String name) {
        return this.findChatsStream(name).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Chat> findChatsBy(@NonNull Function<Chat, Boolean> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.chats.values().stream().filter(function::apply).collect(Collectors.toUnmodifiableSet());
    }

    public Optional<MessageInfo> findStatusById(String id) {
        return id == null ? Optional.empty() : this.status().stream().filter(status -> Objects.equals(status.id(), id)).findFirst();
    }

    public Collection<MessageInfo> status() {
        return this.status.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<MessageInfo> findStatusBySender(ContactJidProvider jid) {
        return Optional.ofNullable(this.status.get(jid.toJid())).map(Collections::unmodifiableCollection).orElseGet(Set::of);
    }

    public boolean resolvePendingRequest(@NonNull Node response, boolean exceptionally) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        return this.findPendingRequest(response.id()).map(request -> this.deleteAndComplete((Request)request, response, exceptionally)).isPresent();
    }

    public Optional<Request> findPendingRequest(String id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.requests.get(id));
    }

    private Request deleteAndComplete(Request request, Node response, boolean exceptionally) {
        if (request.complete(response, exceptionally)) {
            this.requests.remove(request.id());
        }
        return request;
    }

    public void resolveAllPendingRequests() {
        this.requests.values().forEach(request -> request.complete(null, false));
    }

    public Collection<Request> pendingRequests() {
        return Collections.unmodifiableCollection(this.requests.values());
    }

    public boolean resolvePendingReply(@NonNull MessageInfo response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Optional<ContextualMessage> contextualMessage = response.message().contentWithContext();
        if (contextualMessage.isEmpty()) {
            return false;
        }
        String contextualMessageId = contextualMessage.get().contextInfo().quotedMessageId().orElse(null);
        if (contextualMessageId == null) {
            return false;
        }
        Optional<ReplyHandler> result = this.replyHandlers.stream().filter(entry -> entry.id().equals(contextualMessageId)).findFirst();
        result.ifPresent(reply -> {
            this.replyHandlers.remove(reply);
            reply.future().complete(response);
        });
        return result.isPresent();
    }

    public Chat addNewChat(@NonNull ContactJid chatJid) {
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        Chat chat = Chat.ofJid(chatJid);
        this.addChat(chat);
        return chat;
    }

    public Optional<Chat> addChat(@NonNull Chat chat) {
        Chat oldChat;
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        chat.messages().forEach(this::attribute);
        if (chat.hasName() && chat.jid().hasServer(ContactJid.Server.WHATSAPP)) {
            Contact contact = this.findContactByJid(chat.jid()).orElseGet(() -> this.addContact(Contact.ofJid(chat.jid())));
            contact.fullName(chat.name());
        }
        if ((oldChat = this.chats.get(chat.jid())) != null) {
            if (oldChat.hasName() && !chat.hasName()) {
                chat.name(oldChat.name());
            }
            this.joinMessages(chat, oldChat);
        }
        return this.addChatDirect(chat);
    }

    private void joinMessages(Chat chat, Chat oldChat) {
        Long newChatTimestamp = chat.newestMessage().map(MessageInfo::timestampSeconds).orElse(0L);
        Long oldChatTimestamp = oldChat.newestMessage().map(MessageInfo::timestampSeconds).orElse(0L);
        if (newChatTimestamp <= oldChatTimestamp) {
            chat.addMessages(oldChat.messages());
            return;
        }
        chat.addOldMessages(chat.messages());
    }

    public Optional<Chat> addChatDirect(Chat chat) {
        return Optional.ofNullable(this.chats.put(chat.jid(), chat));
    }

    public Optional<Chat> removeChat(@NonNull ContactJid chatJid) {
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        return Optional.ofNullable(this.chats.remove(chatJid));
    }

    public Contact addContact(@NonNull ContactJid contactJid) {
        if (contactJid == null) {
            throw new NullPointerException("contactJid is marked non-null but is null");
        }
        return this.addContact(Contact.ofJid(contactJid));
    }

    public Contact addContact(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        this.contacts.put(contact.jid(), contact);
        return contact;
    }

    public MessageInfo attribute(@NonNull HistorySyncMessage historySyncMessage) {
        if (historySyncMessage == null) {
            throw new NullPointerException("historySyncMessage is marked non-null but is null");
        }
        return this.attribute(historySyncMessage.messageInfo());
    }

    public MessageInfo attribute(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        Chat chat = this.findChatByJid(info.chatJid()).orElseGet(() -> this.addNewChat(info.chatJid()));
        info.key().chat(chat);
        if (info.fromMe() && this.jid != null && !Objects.equals(info.senderJid().user(), this.jid.user())) {
            info.key().senderJid(this.jid.toWhatsappJid());
        }
        info.key().senderJid().ifPresent(senderJid -> this.attributeSender(info, (ContactJid)senderJid));
        info.message().contentWithContext().map(ContextualMessage::contextInfo).ifPresent(this::attributeContext);
        this.processMessage(info);
        return info;
    }

    private MessageKey attributeSender(MessageInfo info, ContactJid senderJid) {
        Contact contact = this.findContactByJid(senderJid).orElseGet(() -> this.addContact(Contact.ofJid(senderJid)));
        return info.sender(contact).key().sender(contact);
    }

    private void attributeContext(ContextInfo contextInfo) {
        contextInfo.quotedMessageSenderJid().ifPresent(senderJid -> this.attributeContextSender(contextInfo, (ContactJid)senderJid));
        contextInfo.quotedMessageChatJid().ifPresent(chatJid -> this.attributeContextChat(contextInfo, (ContactJid)chatJid));
    }

    private void attributeContextChat(ContextInfo contextInfo, ContactJid chatJid) {
        Chat chat = this.findChatByJid(chatJid).orElseGet(() -> this.addNewChat(chatJid));
        contextInfo.quotedMessageChat(chat);
    }

    private void attributeContextSender(ContextInfo contextInfo, ContactJid senderJid) {
        Contact contact = this.findContactByJid(senderJid).orElseGet(() -> this.addContact(Contact.ofJid(senderJid)));
        contextInfo.quotedMessageSender(contact);
    }

    private void processMessage(MessageInfo info) {
        Message content = info.message().content();
        Message message = Objects.requireNonNull(content);
        if (message instanceof PollCreationMessage) {
            PollCreationMessage pollCreationMessage = (PollCreationMessage)message;
            this.handlePollCreation(info, pollCreationMessage);
        } else if (content instanceof PollUpdateMessage) {
            PollUpdateMessage pollUpdateMessage = (PollUpdateMessage)content;
            this.handlePollUpdate(info, pollUpdateMessage);
        } else if (content instanceof ReactionMessage) {
            ReactionMessage reactionMessage = (ReactionMessage)content;
            this.handleReactionMessage(info, reactionMessage);
        }
    }

    private void handlePollCreation(MessageInfo info, PollCreationMessage pollCreationMessage) {
        if (pollCreationMessage.encryptionKey() != null) {
            return;
        }
        info.message().deviceInfo().messageSecret().or(info::messageSecret).ifPresent(pollCreationMessage::encryptionKey);
    }

    private void handlePollUpdate(MessageInfo info, PollUpdateMessage pollUpdateMessage) {
        MessageInfo originalPollInfo = this.findMessageByKey(pollUpdateMessage.pollCreationMessageKey()).orElseThrow(() -> new NoSuchElementException("Missing original poll message"));
        PollCreationMessage originalPollMessage = (PollCreationMessage)originalPollInfo.message().content();
        pollUpdateMessage.pollCreationMessage(originalPollMessage);
        byte[] originalPollSender = originalPollInfo.senderJid().toWhatsappJid().toString().getBytes(StandardCharsets.UTF_8);
        ContactJid modificationSenderJid = info.senderJid().toWhatsappJid();
        pollUpdateMessage.voter(modificationSenderJid);
        byte[] modificationSender = modificationSenderJid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] secretName = pollUpdateMessage.secretName().getBytes(StandardCharsets.UTF_8);
        byte[] useSecretPayload = BytesHelper.concat(originalPollInfo.id().getBytes(StandardCharsets.UTF_8), originalPollSender, modificationSender, secretName);
        byte[] useCaseSecret = Hkdf.extractAndExpand(originalPollMessage.encryptionKey(), useSecretPayload, 32);
        String additionalData = "%s\u0000%s".formatted(originalPollInfo.id(), modificationSenderJid);
        PollUpdateEncryptedMetadata metadata = pollUpdateMessage.encryptedMetadata();
        byte[] decrypted = AesGmc.decrypt(metadata.iv(), metadata.payload(), useCaseSecret, additionalData.getBytes(StandardCharsets.UTF_8));
        PollUpdateEncryptedOptions pollVoteMessage = Protobuf.readMessage(decrypted, PollUpdateEncryptedOptions.class);
        List<PollOption> selectedOptions = pollVoteMessage.selectedOptions().stream().map(sha256 -> originalPollMessage.selectableOptionsHashesMap().get(HexFormat.of().formatHex((byte[])sha256))).filter(Objects::nonNull).toList();
        originalPollMessage.selectedOptionsMap().put(modificationSenderJid, selectedOptions);
        pollUpdateMessage.votes(selectedOptions);
        PollUpdate update = new PollUpdate(info.key(), pollVoteMessage, Clock.nowMilliseconds());
        info.pollUpdates().add(update);
    }

    private void handleReactionMessage(MessageInfo info, ReactionMessage reactionMessage) {
        info.ignore(true);
        this.findMessageByKey(reactionMessage.key()).ifPresent(message -> message.reactions().add(reactionMessage));
    }

    public List<Chat> pinnedChats() {
        return this.chats.values().parallelStream().filter(Chat::isPinned).sorted(Comparator.comparingLong(chat -> chat.pinnedTimestampSeconds()).reversed()).toList();
    }

    public List<MessageInfo> starredMessages() {
        return this.chats().parallelStream().map(Chat::starredMessages).flatMap(Collection::stream).toList();
    }

    public List<Chat> chats() {
        return this.chats.values().stream().sorted(Comparator.comparingLong(chat -> chat.timestampSeconds()).reversed()).toList();
    }

    public Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public MediaConnection mediaConnection() {
        return this.mediaConnection(Duration.ofMinutes(2L));
    }

    public MediaConnection mediaConnection(@NonNull Duration timeout) {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        try {
            boolean result = this.mediaConnectionLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                throw new RuntimeException("Cannot get media connection");
            }
            return this.mediaConnection;
        }
        catch (InterruptedException exception) {
            throw new RuntimeException("Cannot lock on media connection", exception);
        }
    }

    public Store mediaConnection(MediaConnection mediaConnection) {
        this.mediaConnection = mediaConnection;
        this.mediaConnectionLatch.countDown();
        return this;
    }

    public Collection<Contact> blockedContacts() {
        return this.contacts().stream().filter(Contact::blocked).toList();
    }

    public Store addStatus(@NonNull MessageInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.attribute(info);
        ConcurrentLinkedDeque wrapper = Objects.requireNonNullElseGet(this.status.get(info.senderJid()), ConcurrentLinkedDeque::new);
        wrapper.add(info);
        this.status.put(info.senderJid(), wrapper);
        return this;
    }

    public CompletableFuture<Node> addRequest(@NonNull Request request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (request.id() == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.requests.put(request.id(), request);
        return request.future();
    }

    public CompletableFuture<MessageInfo> addPendingReply(@NonNull ReplyHandler reply) {
        if (reply == null) {
            throw new NullPointerException("reply is marked non-null but is null");
        }
        this.replyHandlers.add(reply);
        return reply.future();
    }

    public Optional<URI> profilePicture() {
        return Optional.ofNullable(this.profilePicture);
    }

    public Collection<PrivacySettingEntry> privacySettings() {
        return this.privacySettings.values();
    }

    public PrivacySettingEntry findPrivacySetting(@NonNull PrivacySettingType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.privacySettings.get((Object)type);
    }

    public PrivacySettingEntry addPrivacySetting(@NonNull PrivacySettingType type, @NonNull PrivacySettingEntry entry) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.privacySettings.put(type, entry);
    }

    public Map<ContactJid, Integer> linkedDevicesKeys() {
        return Collections.unmodifiableMap(this.linkedDevicesKeys);
    }

    public Collection<ContactJid> linkedDevices() {
        return Collections.unmodifiableCollection(this.linkedDevicesKeys.keySet());
    }

    public Optional<Integer> addLinkedDevice(@NonNull ContactJid companion, int keyId) {
        if (companion == null) {
            throw new NullPointerException("companion is marked non-null but is null");
        }
        return Optional.ofNullable(this.linkedDevicesKeys.put(companion, keyId));
    }

    public Optional<Integer> removeLinkedCompanion(@NonNull ContactJid companion) {
        if (companion == null) {
            throw new NullPointerException("companion is marked non-null but is null");
        }
        return Optional.ofNullable((Integer)this.linkedDevicesKeys.remove(companion));
    }

    public void removeLinkedCompanions() {
        this.linkedDevicesKeys.clear();
    }

    public Collection<Listener> listeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public Store addListener(@NonNull Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.listeners.add(listener);
        return this;
    }

    public Store addListeners(@NonNull Collection<Listener> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.listeners.addAll(listeners);
        return this;
    }

    public Store removeListener(@NonNull Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.listeners.remove(listener);
        return this;
    }

    public Store removeListener() {
        this.listeners.clear();
        return this;
    }

    public Store version(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
        return this;
    }

    public Version version() {
        if (this.version == null) {
            this.version = MetadataHelper.getVersion(this.device.osType(), this.business).join();
        }
        return this.version;
    }

    public Store proxy(URI proxy) {
        if (proxy != null && proxy.getUserInfo() != null) {
            ProxyAuthenticator.register(proxy);
        } else if (proxy == null && this.proxy != null && this.proxy.getUserInfo() != null) {
            ProxyAuthenticator.unregister(this.proxy);
        }
        this.proxy = proxy;
        return this;
    }

    public Optional<URI> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<UserAgent.UserAgentPlatform> companionDeviceOs() {
        return Optional.ofNullable(this.companionDeviceOs);
    }

    public Optional<String> businessAddress() {
        return Optional.ofNullable(this.businessAddress);
    }

    public Optional<Double> businessLongitude() {
        return Optional.ofNullable(this.businessLongitude);
    }

    public Optional<Double> businessLatitude() {
        return Optional.ofNullable(this.businessLatitude);
    }

    public Optional<String> businessDescription() {
        return Optional.ofNullable(this.businessDescription);
    }

    public Optional<String> businessWebsite() {
        return Optional.ofNullable(this.businessWebsite);
    }

    public Optional<String> businessEmail() {
        return Optional.ofNullable(this.businessEmail);
    }

    public Optional<BusinessCategory> businessCategory() {
        return Optional.ofNullable(this.businessCategory);
    }

    @Override
    public void dispose() {
        this.serialize(false);
        this.mediaConnectionLatch.countDown();
        this.mediaConnectionLatch = new CountDownLatch(1);
    }

    @Override
    public void serialize(boolean async) {
        this.serializer.serializeStore(this, async);
    }

    private static boolean $default$online() {
        return false;
    }

    private static String $default$name() {
        return "Whatsapp4j";
    }

    private static LinkedHashMap<ContactJid, Integer> $default$linkedDevicesKeys() {
        return new LinkedHashMap<ContactJid, Integer>();
    }

    private static ConcurrentHashMap<String, String> $default$properties() {
        return new ConcurrentHashMap<String, String>();
    }

    private static ConcurrentHashMap<ContactJid, Chat> $default$chats() {
        return new ConcurrentHashMap<ContactJid, Chat>();
    }

    private static ConcurrentHashMap<ContactJid, Contact> $default$contacts() {
        return new ConcurrentHashMap<ContactJid, Contact>();
    }

    private static ConcurrentHashMap<ContactJid, ConcurrentLinkedDeque<MessageInfo>> $default$status() {
        return new ConcurrentHashMap<ContactJid, ConcurrentLinkedDeque<MessageInfo>>();
    }

    private static ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> $default$privacySettings() {
        return new ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry>();
    }

    private static ConcurrentHashMap<String, Request> $default$requests() {
        return new ConcurrentHashMap<String, Request>();
    }

    private static ConcurrentHashMap.KeySetView<ReplyHandler, Boolean> $default$replyHandlers() {
        return ConcurrentHashMap.newKeySet();
    }

    private static ConcurrentHashMap.KeySetView<Listener, Boolean> $default$listeners() {
        return ConcurrentHashMap.newKeySet();
    }

    private static String $default$tag() {
        return HexFormat.of().formatHex(BytesHelper.random(1));
    }

    private static long $default$initializationTimeStamp() {
        return Clock.nowSeconds();
    }

    private static CountDownLatch $default$mediaConnectionLatch() {
        return new CountDownLatch(1);
    }

    private static ChatEphemeralTimer $default$newChatsEphemeralTimer() {
        return ChatEphemeralTimer.OFF;
    }

    private static TextPreviewSetting $default$textPreviewSetting() {
        return TextPreviewSetting.ENABLED_WITH_INFERENCE;
    }

    private static WebHistoryLength $default$historyLength() {
        return WebHistoryLength.STANDARD;
    }

    private static boolean $default$autodetectListeners() {
        return true;
    }

    private static boolean $default$automaticPresenceUpdates() {
        return true;
    }

    private static UserAgent.UserAgentReleaseChannel $default$releaseChannel() {
        return UserAgent.UserAgentReleaseChannel.RELEASE;
    }

    private static boolean $default$checkPatchMacs() {
        return false;
    }

    protected Store(StoreBuilder<?, ?> b) {
        super(b);
        this.proxy = b.proxy;
        this.version = b.version;
        this.online = b.online$set ? b.online$value : Store.$default$online();
        this.locale = b.locale;
        this.name = b.name$set ? b.name$value : Store.$default$name();
        this.business = b.business;
        this.businessAddress = b.businessAddress;
        this.businessLongitude = b.businessLongitude;
        this.businessLatitude = b.businessLatitude;
        this.businessDescription = b.businessDescription;
        this.businessWebsite = b.businessWebsite;
        this.businessEmail = b.businessEmail;
        this.businessCategory = b.businessCategory;
        this.deviceHash = b.deviceHash;
        this.linkedDevicesKeys = b.linkedDevicesKeys$set ? b.linkedDevicesKeys$value : Store.$default$linkedDevicesKeys();
        this.profilePicture = b.profilePicture;
        this.about = b.about;
        this.jid = b.jid;
        this.lid = b.lid;
        this.properties = b.properties$set ? b.properties$value : Store.$default$properties();
        if (this.properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.chats = b.chats$set ? b.chats$value : Store.$default$chats();
        if (this.chats == null) {
            throw new NullPointerException("chats is marked non-null but is null");
        }
        this.contacts = b.contacts$set ? b.contacts$value : Store.$default$contacts();
        if (this.contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        this.status = b.status$set ? b.status$value : Store.$default$status();
        if (this.status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.privacySettings = b.privacySettings$set ? b.privacySettings$value : Store.$default$privacySettings();
        if (this.privacySettings == null) {
            throw new NullPointerException("privacySettings is marked non-null but is null");
        }
        this.unarchiveChats = b.unarchiveChats;
        this.twentyFourHourFormat = b.twentyFourHourFormat;
        this.requests = b.requests$set ? b.requests$value : Store.$default$requests();
        if (this.requests == null) {
            throw new NullPointerException("requests is marked non-null but is null");
        }
        this.replyHandlers = b.replyHandlers$set ? b.replyHandlers$value : Store.$default$replyHandlers();
        if (this.replyHandlers == null) {
            throw new NullPointerException("replyHandlers is marked non-null but is null");
        }
        this.listeners = b.listeners$set ? b.listeners$value : Store.$default$listeners();
        if (this.listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.tag = b.tag$set ? b.tag$value : Store.$default$tag();
        if (this.tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.initializationTimeStamp = b.initializationTimeStamp$set ? b.initializationTimeStamp$value : Store.$default$initializationTimeStamp();
        this.mediaConnection = b.mediaConnection;
        this.mediaConnectionLatch = b.mediaConnectionLatch$set ? b.mediaConnectionLatch$value : Store.$default$mediaConnectionLatch();
        this.newChatsEphemeralTimer = b.newChatsEphemeralTimer$set ? b.newChatsEphemeralTimer$value : Store.$default$newChatsEphemeralTimer();
        if (this.newChatsEphemeralTimer == null) {
            throw new NullPointerException("newChatsEphemeralTimer is marked non-null but is null");
        }
        this.textPreviewSetting = b.textPreviewSetting$set ? b.textPreviewSetting$value : Store.$default$textPreviewSetting();
        this.historyLength = b.historyLength$set ? b.historyLength$value : Store.$default$historyLength();
        if (this.historyLength == null) {
            throw new NullPointerException("historyLength is marked non-null but is null");
        }
        this.autodetectListeners = b.autodetectListeners$set ? b.autodetectListeners$value : Store.$default$autodetectListeners();
        this.automaticPresenceUpdates = b.automaticPresenceUpdates$set ? b.automaticPresenceUpdates$value : Store.$default$automaticPresenceUpdates();
        this.releaseChannel = b.releaseChannel$set ? b.releaseChannel$value : Store.$default$releaseChannel();
        if (this.releaseChannel == null) {
            throw new NullPointerException("releaseChannel is marked non-null but is null");
        }
        this.device = b.device;
        if (this.device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        this.companionDeviceOs = b.companionDeviceOs;
        this.checkPatchMacs = b.checkPatchMacs$set ? b.checkPatchMacs$value : Store.$default$checkPatchMacs();
    }

    public static StoreBuilder<?, ?> builder() {
        return new StoreBuilderImpl();
    }

    public boolean online() {
        return this.online;
    }

    public Store online(boolean online) {
        this.online = online;
        return this;
    }

    public String locale() {
        return this.locale;
    }

    public Store locale(String locale) {
        this.locale = locale;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Store name(String name) {
        this.name = name;
        return this;
    }

    public boolean business() {
        return this.business;
    }

    public Store business(boolean business) {
        this.business = business;
        return this;
    }

    public Store businessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public Store businessLongitude(Double businessLongitude) {
        this.businessLongitude = businessLongitude;
        return this;
    }

    public Store businessLatitude(Double businessLatitude) {
        this.businessLatitude = businessLatitude;
        return this;
    }

    public Store businessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
        return this;
    }

    public Store businessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public Store businessEmail(String businessEmail) {
        this.businessEmail = businessEmail;
        return this;
    }

    public Store businessCategory(BusinessCategory businessCategory) {
        this.businessCategory = businessCategory;
        return this;
    }

    public String deviceHash() {
        return this.deviceHash;
    }

    public Store deviceHash(String deviceHash) {
        this.deviceHash = deviceHash;
        return this;
    }

    public Store linkedDevicesKeys(LinkedHashMap<ContactJid, Integer> linkedDevicesKeys) {
        this.linkedDevicesKeys = linkedDevicesKeys;
        return this;
    }

    public Store profilePicture(URI profilePicture) {
        this.profilePicture = profilePicture;
        return this;
    }

    public String about() {
        return this.about;
    }

    public Store about(String about) {
        this.about = about;
        return this;
    }

    public ContactJid jid() {
        return this.jid;
    }

    public Store jid(ContactJid jid) {
        this.jid = jid;
        return this;
    }

    public ContactJid lid() {
        return this.lid;
    }

    public Store lid(ContactJid lid) {
        this.lid = lid;
        return this;
    }

    public Store properties(@NonNull ConcurrentHashMap<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        return this;
    }

    public boolean unarchiveChats() {
        return this.unarchiveChats;
    }

    public Store unarchiveChats(boolean unarchiveChats) {
        this.unarchiveChats = unarchiveChats;
        return this;
    }

    public boolean twentyFourHourFormat() {
        return this.twentyFourHourFormat;
    }

    public Store twentyFourHourFormat(boolean twentyFourHourFormat) {
        this.twentyFourHourFormat = twentyFourHourFormat;
        return this;
    }

    public long initializationTimeStamp() {
        return this.initializationTimeStamp;
    }

    @NonNull
    public ChatEphemeralTimer newChatsEphemeralTimer() {
        return this.newChatsEphemeralTimer;
    }

    public Store newChatsEphemeralTimer(@NonNull ChatEphemeralTimer newChatsEphemeralTimer) {
        if (newChatsEphemeralTimer == null) {
            throw new NullPointerException("newChatsEphemeralTimer is marked non-null but is null");
        }
        this.newChatsEphemeralTimer = newChatsEphemeralTimer;
        return this;
    }

    public TextPreviewSetting textPreviewSetting() {
        return this.textPreviewSetting;
    }

    public Store textPreviewSetting(TextPreviewSetting textPreviewSetting) {
        this.textPreviewSetting = textPreviewSetting;
        return this;
    }

    @NonNull
    public WebHistoryLength historyLength() {
        return this.historyLength;
    }

    public Store historyLength(@NonNull WebHistoryLength historyLength) {
        if (historyLength == null) {
            throw new NullPointerException("historyLength is marked non-null but is null");
        }
        this.historyLength = historyLength;
        return this;
    }

    public boolean autodetectListeners() {
        return this.autodetectListeners;
    }

    public Store autodetectListeners(boolean autodetectListeners) {
        this.autodetectListeners = autodetectListeners;
        return this;
    }

    public boolean automaticPresenceUpdates() {
        return this.automaticPresenceUpdates;
    }

    public Store automaticPresenceUpdates(boolean automaticPresenceUpdates) {
        this.automaticPresenceUpdates = automaticPresenceUpdates;
        return this;
    }

    @NonNull
    public UserAgent.UserAgentReleaseChannel releaseChannel() {
        return this.releaseChannel;
    }

    public Store releaseChannel(@NonNull UserAgent.UserAgentReleaseChannel releaseChannel) {
        if (releaseChannel == null) {
            throw new NullPointerException("releaseChannel is marked non-null but is null");
        }
        this.releaseChannel = releaseChannel;
        return this;
    }

    @NonNull
    public CompanionDevice device() {
        return this.device;
    }

    public Store device(@NonNull CompanionDevice device) {
        if (device == null) {
            throw new NullPointerException("device is marked non-null but is null");
        }
        this.device = device;
        return this;
    }

    public Store companionDeviceOs(UserAgent.UserAgentPlatform companionDeviceOs) {
        this.companionDeviceOs = companionDeviceOs;
        return this;
    }

    public boolean checkPatchMacs() {
        return this.checkPatchMacs;
    }

    public Store checkPatchMacs(boolean checkPatchMacs) {
        this.checkPatchMacs = checkPatchMacs;
        return this;
    }

    public static abstract class StoreBuilder<C extends Store, B extends StoreBuilder<C, B>>
    extends Controller.ControllerBuilder<Store, C, B> {
        private URI proxy;
        private Version version;
        private boolean online$set;
        private boolean online$value;
        private String locale;
        private boolean name$set;
        private String name$value;
        private boolean business;
        private String businessAddress;
        private Double businessLongitude;
        private Double businessLatitude;
        private String businessDescription;
        private String businessWebsite;
        private String businessEmail;
        private BusinessCategory businessCategory;
        private String deviceHash;
        private boolean linkedDevicesKeys$set;
        private LinkedHashMap<ContactJid, Integer> linkedDevicesKeys$value;
        private URI profilePicture;
        private String about;
        private ContactJid jid;
        private ContactJid lid;
        private boolean properties$set;
        private ConcurrentHashMap<String, String> properties$value;
        private boolean chats$set;
        private ConcurrentHashMap<ContactJid, Chat> chats$value;
        private boolean contacts$set;
        private ConcurrentHashMap<ContactJid, Contact> contacts$value;
        private boolean status$set;
        private ConcurrentHashMap<ContactJid, ConcurrentLinkedDeque<MessageInfo>> status$value;
        private boolean privacySettings$set;
        private ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> privacySettings$value;
        private boolean unarchiveChats;
        private boolean twentyFourHourFormat;
        private boolean requests$set;
        private ConcurrentHashMap<String, Request> requests$value;
        private boolean replyHandlers$set;
        private ConcurrentHashMap.KeySetView<ReplyHandler, Boolean> replyHandlers$value;
        private boolean listeners$set;
        private ConcurrentHashMap.KeySetView<Listener, Boolean> listeners$value;
        private boolean tag$set;
        private String tag$value;
        private boolean initializationTimeStamp$set;
        private long initializationTimeStamp$value;
        private MediaConnection mediaConnection;
        private boolean mediaConnectionLatch$set;
        private CountDownLatch mediaConnectionLatch$value;
        private boolean newChatsEphemeralTimer$set;
        private ChatEphemeralTimer newChatsEphemeralTimer$value;
        private boolean textPreviewSetting$set;
        private TextPreviewSetting textPreviewSetting$value;
        private boolean historyLength$set;
        private WebHistoryLength historyLength$value;
        private boolean autodetectListeners$set;
        private boolean autodetectListeners$value;
        private boolean automaticPresenceUpdates$set;
        private boolean automaticPresenceUpdates$value;
        private boolean releaseChannel$set;
        private UserAgent.UserAgentReleaseChannel releaseChannel$value;
        private CompanionDevice device;
        private UserAgent.UserAgentPlatform companionDeviceOs;
        private boolean checkPatchMacs$set;
        private boolean checkPatchMacs$value;

        public StoreBuilder<C, B> proxy(URI proxy) {
            if (proxy != null && proxy.getUserInfo() != null) {
                ProxyAuthenticator.register(proxy);
            }
            this.proxy = proxy;
            return this;
        }

        public B version(Version version) {
            this.version = version;
            return (B)this.self();
        }

        public B online(boolean online) {
            this.online$value = online;
            this.online$set = true;
            return (B)this.self();
        }

        public B locale(String locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B name(String name) {
            this.name$value = name;
            this.name$set = true;
            return (B)this.self();
        }

        public B business(boolean business) {
            this.business = business;
            return (B)this.self();
        }

        public B businessAddress(String businessAddress) {
            this.businessAddress = businessAddress;
            return (B)this.self();
        }

        public B businessLongitude(Double businessLongitude) {
            this.businessLongitude = businessLongitude;
            return (B)this.self();
        }

        public B businessLatitude(Double businessLatitude) {
            this.businessLatitude = businessLatitude;
            return (B)this.self();
        }

        public B businessDescription(String businessDescription) {
            this.businessDescription = businessDescription;
            return (B)this.self();
        }

        public B businessWebsite(String businessWebsite) {
            this.businessWebsite = businessWebsite;
            return (B)this.self();
        }

        public B businessEmail(String businessEmail) {
            this.businessEmail = businessEmail;
            return (B)this.self();
        }

        public B businessCategory(BusinessCategory businessCategory) {
            this.businessCategory = businessCategory;
            return (B)this.self();
        }

        public B deviceHash(String deviceHash) {
            this.deviceHash = deviceHash;
            return (B)this.self();
        }

        public B linkedDevicesKeys(LinkedHashMap<ContactJid, Integer> linkedDevicesKeys) {
            this.linkedDevicesKeys$value = linkedDevicesKeys;
            this.linkedDevicesKeys$set = true;
            return (B)this.self();
        }

        public B profilePicture(URI profilePicture) {
            this.profilePicture = profilePicture;
            return (B)this.self();
        }

        public B about(String about) {
            this.about = about;
            return (B)this.self();
        }

        public B jid(ContactJid jid) {
            this.jid = jid;
            return (B)this.self();
        }

        public B lid(ContactJid lid) {
            this.lid = lid;
            return (B)this.self();
        }

        public B properties(@NonNull ConcurrentHashMap<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties$value = properties;
            this.properties$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B chats(@NonNull ConcurrentHashMap<ContactJid, Chat> chats) {
            if (chats == null) {
                throw new NullPointerException("chats is marked non-null but is null");
            }
            this.chats$value = chats;
            this.chats$set = true;
            return (B)this.self();
        }

        public B contacts(@NonNull ConcurrentHashMap<ContactJid, Contact> contacts) {
            if (contacts == null) {
                throw new NullPointerException("contacts is marked non-null but is null");
            }
            this.contacts$value = contacts;
            this.contacts$set = true;
            return (B)this.self();
        }

        public B status(@NonNull ConcurrentHashMap<ContactJid, ConcurrentLinkedDeque<MessageInfo>> status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status$value = status;
            this.status$set = true;
            return (B)this.self();
        }

        public B privacySettings(@NonNull ConcurrentHashMap<PrivacySettingType, PrivacySettingEntry> privacySettings) {
            if (privacySettings == null) {
                throw new NullPointerException("privacySettings is marked non-null but is null");
            }
            this.privacySettings$value = privacySettings;
            this.privacySettings$set = true;
            return (B)this.self();
        }

        public B unarchiveChats(boolean unarchiveChats) {
            this.unarchiveChats = unarchiveChats;
            return (B)this.self();
        }

        public B twentyFourHourFormat(boolean twentyFourHourFormat) {
            this.twentyFourHourFormat = twentyFourHourFormat;
            return (B)this.self();
        }

        @JsonIgnore
        public B requests(@NonNull ConcurrentHashMap<String, Request> requests) {
            if (requests == null) {
                throw new NullPointerException("requests is marked non-null but is null");
            }
            this.requests$value = requests;
            this.requests$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B replyHandlers(@NonNull ConcurrentHashMap.KeySetView<ReplyHandler, Boolean> replyHandlers) {
            if (replyHandlers == null) {
                throw new NullPointerException("replyHandlers is marked non-null but is null");
            }
            this.replyHandlers$value = replyHandlers;
            this.replyHandlers$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B listeners(@NonNull ConcurrentHashMap.KeySetView<Listener, Boolean> listeners) {
            if (listeners == null) {
                throw new NullPointerException("listeners is marked non-null but is null");
            }
            this.listeners$value = listeners;
            this.listeners$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B tag(@NonNull String tag) {
            if (tag == null) {
                throw new NullPointerException("tag is marked non-null but is null");
            }
            this.tag$value = tag;
            this.tag$set = true;
            return (B)this.self();
        }

        public B initializationTimeStamp(long initializationTimeStamp) {
            this.initializationTimeStamp$value = initializationTimeStamp;
            this.initializationTimeStamp$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B mediaConnection(MediaConnection mediaConnection) {
            this.mediaConnection = mediaConnection;
            return (B)this.self();
        }

        @JsonIgnore
        public B mediaConnectionLatch(CountDownLatch mediaConnectionLatch) {
            this.mediaConnectionLatch$value = mediaConnectionLatch;
            this.mediaConnectionLatch$set = true;
            return (B)this.self();
        }

        public B newChatsEphemeralTimer(@NonNull ChatEphemeralTimer newChatsEphemeralTimer) {
            if (newChatsEphemeralTimer == null) {
                throw new NullPointerException("newChatsEphemeralTimer is marked non-null but is null");
            }
            this.newChatsEphemeralTimer$value = newChatsEphemeralTimer;
            this.newChatsEphemeralTimer$set = true;
            return (B)this.self();
        }

        public B textPreviewSetting(TextPreviewSetting textPreviewSetting) {
            this.textPreviewSetting$value = textPreviewSetting;
            this.textPreviewSetting$set = true;
            return (B)this.self();
        }

        public B historyLength(@NonNull WebHistoryLength historyLength) {
            if (historyLength == null) {
                throw new NullPointerException("historyLength is marked non-null but is null");
            }
            this.historyLength$value = historyLength;
            this.historyLength$set = true;
            return (B)this.self();
        }

        public B autodetectListeners(boolean autodetectListeners) {
            this.autodetectListeners$value = autodetectListeners;
            this.autodetectListeners$set = true;
            return (B)this.self();
        }

        public B automaticPresenceUpdates(boolean automaticPresenceUpdates) {
            this.automaticPresenceUpdates$value = automaticPresenceUpdates;
            this.automaticPresenceUpdates$set = true;
            return (B)this.self();
        }

        public B releaseChannel(@NonNull UserAgent.UserAgentReleaseChannel releaseChannel) {
            if (releaseChannel == null) {
                throw new NullPointerException("releaseChannel is marked non-null but is null");
            }
            this.releaseChannel$value = releaseChannel;
            this.releaseChannel$set = true;
            return (B)this.self();
        }

        public B device(@NonNull CompanionDevice device) {
            if (device == null) {
                throw new NullPointerException("device is marked non-null but is null");
            }
            this.device = device;
            return (B)this.self();
        }

        public B companionDeviceOs(UserAgent.UserAgentPlatform companionDeviceOs) {
            this.companionDeviceOs = companionDeviceOs;
            return (B)this.self();
        }

        public B checkPatchMacs(boolean checkPatchMacs) {
            this.checkPatchMacs$value = checkPatchMacs;
            this.checkPatchMacs$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Store.StoreBuilder(super=" + super.toString() + ", proxy=" + this.proxy + ", version=" + this.version + ", online$value=" + this.online$value + ", locale=" + this.locale + ", name$value=" + this.name$value + ", business=" + this.business + ", businessAddress=" + this.businessAddress + ", businessLongitude=" + this.businessLongitude + ", businessLatitude=" + this.businessLatitude + ", businessDescription=" + this.businessDescription + ", businessWebsite=" + this.businessWebsite + ", businessEmail=" + this.businessEmail + ", businessCategory=" + this.businessCategory + ", deviceHash=" + this.deviceHash + ", linkedDevicesKeys$value=" + this.linkedDevicesKeys$value + ", profilePicture=" + this.profilePicture + ", about=" + this.about + ", jid=" + this.jid + ", lid=" + this.lid + ", properties$value=" + this.properties$value + ", chats$value=" + this.chats$value + ", contacts$value=" + this.contacts$value + ", status$value=" + this.status$value + ", privacySettings$value=" + this.privacySettings$value + ", unarchiveChats=" + this.unarchiveChats + ", twentyFourHourFormat=" + this.twentyFourHourFormat + ", requests$value=" + this.requests$value + ", replyHandlers$value=" + this.replyHandlers$value + ", listeners$value=" + this.listeners$value + ", tag$value=" + this.tag$value + ", initializationTimeStamp$value=" + this.initializationTimeStamp$value + ", mediaConnection=" + this.mediaConnection + ", mediaConnectionLatch$value=" + this.mediaConnectionLatch$value + ", newChatsEphemeralTimer$value=" + this.newChatsEphemeralTimer$value + ", textPreviewSetting$value=" + this.textPreviewSetting$value + ", historyLength$value=" + this.historyLength$value + ", autodetectListeners$value=" + this.autodetectListeners$value + ", automaticPresenceUpdates$value=" + this.automaticPresenceUpdates$value + ", releaseChannel$value=" + this.releaseChannel$value + ", device=" + this.device + ", companionDeviceOs=" + this.companionDeviceOs + ", checkPatchMacs$value=" + this.checkPatchMacs$value + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class StoreBuilderImpl
    extends StoreBuilder<Store, StoreBuilderImpl> {
        private StoreBuilderImpl() {
        }

        @Override
        protected StoreBuilderImpl self() {
            return this;
        }

        @Override
        public Store build() {
            return new Store(this);
        }
    }
}

