/*
 * Decompiled with CFR 0.152.
 */
package it.auties.map;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import it.auties.map.MapEntry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

class MapDeserializer<K, V>
extends StdDeserializer<Map<K, V>> {
    private final CollectionType type;
    private final MapType mapType;

    public MapDeserializer(MapType type, TypeFactory factory) {
        super(Map.class);
        this.mapType = type;
        JavaType argument = factory.constructParametricType(MapEntry.class, new JavaType[]{type.getKeyType(), type.getContentType()});
        this.type = factory.constructCollectionType(List.class, argument);
    }

    public Map<K, V> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return ((List)context.readValue(parser, (JavaType)this.type)).stream().collect(Collectors.toMap(MapEntry::key, MapEntry::value, this::handleDuplicates, this::initMap));
    }

    private Map<K, V> initMap() {
        try {
            return (Map)this.mapType.getRawClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new NoSuchElementException("Cannot initialize map with type %s".formatted(this.mapType.getRawClass().getName()), exception);
        }
    }

    private V handleDuplicates(V first, V second) {
        return second;
    }
}

