/*
 * Decompiled with CFR 0.152.
 */
package it.auties.curve25519.crypto;

import it.auties.curve25519.crypto.Sha512;
import it.auties.curve25519.crypto.ge_p3;
import it.auties.curve25519.crypto.ge_p3_tobytes;
import it.auties.curve25519.crypto.ge_scalarmult_base;
import it.auties.curve25519.crypto.sc_muladd;
import it.auties.curve25519.crypto.sc_reduce;
import java.util.Arrays;

public class sign_modified {
    static int crypto_sign_modified(byte[] sm, byte[] m, long n, byte[] sk, byte[] pk, byte[] random) {
        byte[] h = new byte[64];
        byte[] r = new byte[64];
        ge_p3 p = new ge_p3();
        if (random != null) {
            sm[0] = -2;
            for (int count = 1; count < 32; ++count) {
                sm[count] = -1;
            }
            System.arraycopy(sk, 0, sm, 32, 32);
            System.arraycopy(m, 0, sm, 64, (int)n);
            System.arraycopy(random, 0, sm, (int)(n + 64L), 64);
            Sha512.calculateDigest(r, sm, n + 128L);
            return sign_modified.crypto_sign_modified(sm, n, sk, pk, h, r, p);
        }
        System.arraycopy(m, 0, sm, 64, (int)n);
        System.arraycopy(sk, 0, sm, 32, 32);
        Sha512.calculateDigest(r, Arrays.copyOfRange(sm, 32, sm.length), n + 32L);
        return sign_modified.crypto_sign_modified(sm, n, sk, pk, h, r, p);
    }

    private static int crypto_sign_modified(byte[] sm, long n, byte[] sk, byte[] pk, byte[] h, byte[] r, ge_p3 p) {
        System.arraycopy(pk, 0, sm, 32, 32);
        sc_reduce.sc_reduce(r);
        ge_scalarmult_base.ge_scalarmult_base(p, r);
        ge_p3_tobytes.ge_p3_tobytes(sm, p);
        Sha512.calculateDigest(h, sm, n + 64L);
        sc_reduce.sc_reduce(h);
        byte[] x = new byte[32];
        sc_muladd.sc_muladd(x, h, sk, r);
        System.arraycopy(x, 0, sm, 32, 32);
        return 0;
    }
}

