/*
 * Decompiled with CFR 0.152.
 */
package it.auties.curve25519;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;

public class XecUtils {
    private static final String KEY_ALGORITHM = "X25519";

    public static XECPublicKey toPublicKey(byte[] rawPublicKey) {
        try {
            Objects.requireNonNull(rawPublicKey, "Public key cannot be null!");
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), rawPublicKey);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyInfo.getEncoded());
            return (XECPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (ClassCastException | NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing Curve25519 implementation", exception);
        }
        catch (IOException | InvalidKeySpecException exception) {
            throw new RuntimeException("Internal exception during key generation", exception);
        }
    }

    public static XECPrivateKey toPrivateKey(byte[] rawPrivateKey) {
        try {
            Objects.requireNonNull(rawPrivateKey, "Private key cannot be null!");
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), (ASN1Encodable)new DEROctetString(rawPrivateKey));
            PKCS8EncodedKeySpec privateKey = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            return (XECPrivateKey)keyFactory.generatePrivate(privateKey);
        }
        catch (ClassCastException | NoSuchAlgorithmException exception) {
            throw new UnsupportedOperationException("Missing Curve25519 implementation", exception);
        }
        catch (IOException | InvalidKeySpecException exception) {
            throw new RuntimeException("Internal exception during key generation", exception);
        }
    }

    public static byte[] toBytes(XECPublicKey publicKey) {
        try {
            Objects.requireNonNull(publicKey, "Public key cannot be null!");
            X25519PublicKeyParameters x25519PublicKeyParameters = (X25519PublicKeyParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded());
            return x25519PublicKeyParameters.getEncoded();
        }
        catch (IOException exception) {
            throw new RuntimeException("Cannot extract public key", exception);
        }
    }

    public static byte[] toBytes(XECPrivateKey privateKey) {
        return (byte[])Optional.of(privateKey).flatMap(XECPrivateKey::getScalar).orElseThrow(() -> new NoSuchElementException("Private key cannot be null!"));
    }
}

