/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.protocol.simple;

import com.flowpowered.network.Codec;
import com.flowpowered.network.Message;
import com.flowpowered.network.MessageHandler;
import com.flowpowered.network.protocol.AbstractProtocol;
import com.flowpowered.network.service.CodecLookupService;
import com.flowpowered.network.service.HandlerLookupService;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;

public abstract class SimpleProtocol
extends AbstractProtocol {
    private final CodecLookupService codecLookup;
    private final HandlerLookupService handlerLookup;

    public SimpleProtocol(String name, int maxPackets) {
        super(name);
        this.codecLookup = new CodecLookupService(maxPackets);
        this.handlerLookup = new HandlerLookupService();
    }

    public SimpleProtocol(String name, int maxPackets, Logger logger) {
        super(name, logger);
        this.codecLookup = new CodecLookupService(maxPackets);
        this.handlerLookup = new HandlerLookupService();
    }

    protected HandlerLookupService getHandlerLookupService() {
        return this.handlerLookup;
    }

    protected CodecLookupService getCodecLookupService() {
        return this.codecLookup;
    }

    @Override
    public <M extends Message> Codec.CodecRegistration getCodecRegistration(Class<M> message) {
        return this.codecLookup.find(message);
    }

    @Override
    public <M extends Message> MessageHandler<?, M> getMessageHandle(Class<M> message) {
        return this.handlerLookup.find(message);
    }

    public <M extends Message, C extends Codec<? super M>, H extends MessageHandler<?, ? super M>> Codec.CodecRegistration registerMessage(Class<M> message, Class<C> codec, Class<H> handler, Integer opcode) {
        try {
            Codec.CodecRegistration bind = this.codecLookup.bind(message, codec, opcode);
            if (bind != null && handler != null) {
                this.handlerLookup.bind(message, handler);
            }
            return bind;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().error("Error registering codec " + codec + ": ", (Throwable)e);
            return null;
        }
    }
}

