/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.pipeline;

import com.flowpowered.network.pipeline.MessageHandler;
import com.flowpowered.network.processor.MessageProcessor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MessageProcessorDecoder
extends ByteToMessageDecoder {
    private final MessageHandler messageHandler;

    public MessageProcessorDecoder(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> frames) throws Exception {
        MessageProcessor processor = this.getProcessor();
        if (processor == null) {
            frames.add(buf.readBytes(buf.readableBytes()));
            return;
        }
        ByteBuf liveBuffer = ctx.alloc().buffer();
        liveBuffer = processor.processInbound(ctx, buf, liveBuffer);
        frames.add(liveBuffer);
    }

    protected MessageProcessor getProcessor() {
        return this.messageHandler.getSession().getProcessor();
    }
}

