/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.listeners;

import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.kitteh.vanish.Settings;
import org.kitteh.vanish.VanishPerms;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.utils.StringUtil;

public final class ListenPlayerOther
implements Listener {
    private final VanishPlugin plugin;
    private final HashSet<Material> fakeInventoryBlockTypes;

    public ListenPlayerOther(VanishPlugin instance) {
        this.plugin = instance;
        this.fakeInventoryBlockTypes = new HashSet();
        try {
            this.fakeInventoryBlockTypes.add(Material.CHEST);
            this.fakeInventoryBlockTypes.add(Material.TRAPPED_CHEST);
            this.fakeInventoryBlockTypes.add(Material.BARREL);
            this.fakeInventoryBlockTypes.add(Material.CHISELED_BOOKSHELF);
            this.fakeInventoryBlockTypes.add(Material.DECORATED_POT);
            this.fakeInventoryBlockTypes.addAll(Tag.COPPER_CHESTS.getValues());
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotInteract(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrop(PlayerDropItemEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotInteract(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFoodChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.plugin.getManager().isVanished(player) && VanishPerms.canNotHunger(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.chestFakeInUse(player.getName()) && !player.isSneaking() && event.getAction() == Action.RIGHT_CLICK_BLOCK && this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canReadChestsSilently(event.getPlayer())) {
            Block block = event.getClickedBlock();
            BlockState blockState = block.getState();
            Material blockType = block.getType();
            boolean fake = false;
            if (this.fakeInventoryBlockTypes.contains(blockType) || blockState instanceof ShulkerBox) {
                fake = true;
            }
            Inventory inventory = null;
            if (blockState instanceof BlockInventoryHolder) {
                BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)blockState;
                inventory = blockInventoryHolder.getInventory();
            } else if (blockType == Material.ENDER_CHEST) {
                if (this.plugin.getServer().getPluginManager().isPluginEnabled("EnderChestPlus") && VanishPerms.canNotInteract(player)) {
                    event.setCancelled(true);
                    return;
                }
                inventory = player.getEnderChest();
            }
            if (inventory != null) {
                event.setCancelled(true);
                if (fake) {
                    Inventory originalInventory = inventory;
                    inventory = this.plugin.getServer().createInventory((InventoryHolder)player, (originalInventory.getSize() + 8) / 9 * 9, StringUtil.capitalizeFirstLetter(blockType.name()));
                    inventory.setContents(originalInventory.getContents());
                    this.plugin.chestFakeOpen(player.getName());
                    player.sendMessage(String.valueOf(ChatColor.AQUA) + "[VNP] Opening chest silently. Can not edit.");
                }
                player.openInventory(inventory);
                return;
            }
        }
        if (this.plugin.getManager().isVanished(player) && VanishPerms.canNotInteract(player)) {
            event.setCancelled(true);
            return;
        }
        if (event.getAction() == Action.PHYSICAL && event.getClickedBlock().getType() == Material.FARMLAND && this.plugin.getManager().isVanished(player) && VanishPerms.canNotTrample(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotInteract(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupItem(EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Player && this.plugin.getManager().isVanished((Player)event.getEntity()) && VanishPerms.canNotPickUp((Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPickupArrow(PlayerPickupArrowEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotPickUp(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getManager().isVanished(player)) {
            this.plugin.messageStatusUpdate(String.valueOf(ChatColor.DARK_AQUA) + event.getPlayer().getName() + " has quit vanished");
        }
        this.plugin.getManager().playerQuit(player);
        this.plugin.hooksQuit(player);
        this.plugin.getManager().getAnnounceManipulator().dropDelayedAnnounce(player.getName());
        if (!this.plugin.getManager().getAnnounceManipulator().playerHasQuit(player.getName()) || VanishPerms.silentQuit(player)) {
            event.setQuitMessage(null);
        }
        this.plugin.chestFakeClose(event.getPlayer().getName());
        player.removeMetadata("vanished", (Plugin)this.plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onShear(PlayerShearEntityEvent event) {
        if (this.plugin.getManager().isVanished(event.getPlayer()) && VanishPerms.canNotInteract(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        if (Settings.getWorldChangeCheck()) {
            this.plugin.getManager().playerRefresh(event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE && !VanishPerms.canSeeAll(event.getPlayer())) {
            for (Player target : event.getTo().getWorld().getPlayers()) {
                if (target == event.getPlayer() || !target.getLocation().equals((Object)event.getTo()) || !this.plugin.getManager().isVanished(target)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }
}

