/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GiveCommand
extends SubCommand {
    private TreasureChest plugin;

    public GiveCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.give";
    }

    public boolean requiresPlayer() {
        return true;
    }

    public String getUsage() {
        return "<player> [...]";
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() < 1) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        Player player = (Player)sender;
        TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
        if (activeItem == null) {
            this.plugin.sendMessage(sender, "You have no active item!", true);
            return true;
        }
        while (args.hasNext()) {
            String nameOrId = args.getNext().replace(",", "").trim();
            if (nameOrId.length() <= 0) continue;
            CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(nameOrId);
            if (target == null) {
                this.plugin.sendMessage(sender, "Unknown player: " + nameOrId, true);
                continue;
            }
            this.plugin.addItem((OfflinePlayer)target, activeItem.getDisplayItem(), activeItem.getPriceItems(), activeItem.getPriceMoney());
            this.plugin.sendMessage(sender, "Item given to: " + target.getName());
        }
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return null;
    }
}

